use Test::More;

use strict;
use File::Spec;
use Zim::Store::Man;
use Zim;

$| = 1;
$Zim::CODESET = $Zim::CODESET = 'utf8'; # surpress warning by repetition
$SIG{__WARN__} = sub {
	print STDERR @_ unless $_[0] =~ /^(#|Searching|Indexing)/;
};

my $rep = Zim::Store::Man->new();
plan $rep->{has_man}
	? (tests => 4)
	: (skip_all => "No man page support") ;

print "\n## 1 - resolve_name man => :1:man\n";
my $name = $rep->resolve_name('man');
is($name, ':1:man', 'resolve_name');

my $page = $rep->get_page(':1:man');
my $tree = $page->get_parse_tree();
ok(@$tree > 3, "Page not empty");

print "\n## 3 - resolve_name Module::Build => :3:Module::Build\n";
$name = $rep->resolve_name('Module::Build');
is($name, ':3:Module::Build', 'resolve_name');

$page = $rep->get_page(':3:Module:Build');
$tree = $page->get_parse_tree();
ok(@$tree > 3, "Page not empty");

