/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void about_close __P((GtkWidget *, GtkWidget *));
void about_window __P((GtkWidget *, gpointer));

__END_DECLS

void about_close(GtkWidget *widget,GtkWidget *dialog)
{
  gtk_widget_destroy( dialog );
  ABOUT_DIALOG_FLAG = 0;
}

void about_window(GtkWidget *widget,gpointer data)
{
  GtkWidget *a_dialog;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *a_main_box;

  /*
   * Dont open dialog if other dialog window is already open.
   */

  if (ABOUT_DIALOG_FLAG == FALSE)
    {
      ABOUT_DIALOG_FLAG = TRUE;
    }
  else
    {
      return;
    }

  a_dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW (a_dialog),"About Xwhois");
  gtk_signal_connect (GTK_OBJECT (a_dialog), "destroy",
                      GTK_SIGNAL_FUNC (about_close), a_dialog);
  gtk_widget_show (a_dialog);

  a_main_box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a_dialog)->vbox), a_main_box, TRUE, TRUE, 5);
  gtk_widget_show (a_main_box);

  label = gtk_label_new ("Xwhois version "VERSION"");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("Bjorn Lindgren  (bjorn@500mhz.net)");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("(c) 1998, 1999, 2000");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("   Licensed under GNU General Public License (GPL)   ");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("Homepage:  http://oxygene.500mhz.net/xwhois/");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("Main dist site:  ftp://sangis.kalix.net/pub/nr/xwhois/");
  gtk_box_pack_start (GTK_BOX (a_main_box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  button = gtk_button_new_with_label (" Close ");
  gtk_signal_connect (GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(about_close),a_dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(a_dialog)->action_area), button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);
}
