/*
    chips.h - Part of xsensors

    Copyright (c) 2002 Kris Kersey <augustus@linuxhardware.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define UNDEFMAXMIN -1

/* Link list to hold sensor feature data.  This is used since the number of 
 * features vary.
 */
typedef struct _updates {
    sensors_chip_name name;
    GtkWidget *pbar;
    GtkWidget *darea;
    int featnum;
    int featminnum;
    int featmaxnum;
    int feattype;
    double curvalue;
    double curmin;
    double curmax;
    struct _updates *next;
} updates;

/* Add a node to the sensor's features linked list. */
updates *add_node( updates *, sensors_chip_name, GtkWidget *, GtkWidget *, 
                   int );

/* Get the number of features of a given sensor. */
int get_num_feat( sensors_chip_name );

/* Feature Info Prototypes */
int get_feat_info_adm1021( updates *node, sensors_chip_name name, int num );
int get_feat_info_eeprom( updates *node, sensors_chip_name name, int num );
int get_feat_info_it87( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm75( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm78( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm78j( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm79( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm80( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm85( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm87( updates *node, sensors_chip_name name, int num );
int get_feat_info_lm90( updates *node, sensors_chip_name name, int num );
int get_feat_info_max1617( updates *node, sensors_chip_name name, int num );
int get_feat_info_max1617a( updates *node, sensors_chip_name name, int num );
int get_feat_info_smsc47b397( updates *node, sensors_chip_name name, int num );
int get_feat_info_via686a( updates *node, sensors_chip_name name, int num );
int get_feat_info_w83781d( updates *node, sensors_chip_name name, int num );
int get_feat_info_w83782d( updates *node, sensors_chip_name name, int num );
int get_feat_info_w83783s( updates *node, sensors_chip_name name, int num );
int get_feat_info_as99127f( updates *node, sensors_chip_name name, int num );
