/*-
# X-BASED MASTERBALL(tm)
#
#  Mball.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Mball */

#ifndef _XtMball_h
#define _XtMball_h

/***********************************************************************
 *
 * Mball Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNwedgeColor0 ((char *) "wedgeColor0")
#define XtNwedgeColor1 ((char *) "wedgeColor1")
#define XtNwedgeColor2 ((char *) "wedgeColor2")
#define XtNwedgeColor3 ((char *) "wedgeColor3")
#define XtNwedgeColor4 ((char *) "wedgeColor4")
#define XtNwedgeColor5 ((char *) "wedgeColor5")
#define XtNwedgeColor6 ((char *) "wedgeColor6")
#define XtNwedgeColor7 ((char *) "wedgeColor7")
#define XtNwedgeColor8 ((char *) "wedgeColor8")
#define XtNwedgeColor9 ((char *) "wedgeColor9")
#define XtNwedgeColor10 ((char *) "wedgeColor10")
#define XtNwedgeColor11 ((char *) "wedgeColor11")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNwedges ((char *) "wedges")
#define XtNrings ((char *) "rings")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCWedges ((char *) "Wedges")
#define XtCRings ((char *) "Rings")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _MballClassRec *MballWidgetClass;

extern WidgetClass mballWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} mballCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_SOLVE_MESSAGE 106
#define ACTION_RESTORE 107
#define ACTION_RESET 108
#define ACTION_AMBIGUOUS 109
#define ACTION_ILLEGAL 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_INCREMENT 206
#define ACTION_DECREMENT 207
#define ACTION_ORIENTIZE 208
#define ACTION_WEDGE2 209
#define ACTION_WEDGE4 210
#define ACTION_WEDGE6 211
#define ACTION_WEDGE8 212
#define ACTION_WEDGE10 213
#define ACTION_WEDGE12 214
#define ACTION_SPEED 215
#define ACTION_SLOW 216
#define ACTION_SOUND 217
#define ACTION_TOP 300
#define ACTION_TTR 301
#define ACTION_TR 302
#define ACTION_RIGHT 303
#define ACTION_BR 304
#define ACTION_BBR 305
#define ACTION_BOTTOM 306
#define ACTION_BBL 307
#define ACTION_BL 308
#define ACTION_LEFT 309
#define ACTION_TL 310
#define ACTION_TTL 311
#define ACTION_CW 313
#define ACTION_CCW 323
#define ACTION_CONTROL_TOP 340
#define ACTION_CONTROL_TTR 341
#define ACTION_CONTROL_TR 342
#define ACTION_CONTROL_RIGHT 343
#define ACTION_CONTROL_BR 344
#define ACTION_CONTROL_BBR 345
#define ACTION_CONTROL_BOTTOM 346
#define ACTION_CONTROL_BBL 347
#define ACTION_CONTROL_BL 348
#define ACTION_CONTROL_LEFT 349
#define ACTION_CONTROL_TL 350
#define ACTION_CONTROL_TTL 351
#define ACTION_CONTROL_CW 353
#define ACTION_CONTROL_CCW 363
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define MINWEDGES 2
#define MAXWEDGES 12
#define MINRINGS 1
#define DEFAULTWEDGES 8
#define DEFAULTRINGS 4
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE TRUE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 16 /* works good for 12 wedges */

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _MballRec *MballWidget;

#endif /* _XtMball_h */
/* DON'T ADD STUFF AFTER THIS #endif */
