/*-
# X-BASED BARREL(tm)
#
#  Barrel.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Barrel */

#ifndef _XtBarrel_h
#define _XtBarrel_h

/***********************************************************************
 *
 * Barrel Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNtiles ((char *) "tiles")
#define XtNfaces ((char *) "faces")
#define XtNorient ((char *) "orient")
#define XtNpairs ((char *) "pairs")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCTiles ((char *) "Tiles")
#define XtCFaces ((char *) "Faces")
#define XtCOrient ((char *) "Orient")
#define XtCPairs ((char *) "Pairs")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _BarrelClassRec *BarrelWidgetClass;

extern WidgetClass barrelWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} barrelCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_SOLVE_MESSAGE 106
#define ACTION_RESTORE 107
#define ACTION_RESET 108
#define ACTION_BLOCKED 109
#define ACTION_SPACE 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_ORIENTIZE 206
#define ACTION_PAIRS 207
#define ACTION_SPEED 208
#define ACTION_SLOW 209
#define ACTION_SOUND 210
#define ACTION_SHIFT_UP 300
#define ACTION_RIGHT 301
#define ACTION_SHIFT_DOWN 302
#define ACTION_LEFT 303
#define ACTION_UP 310
#define ACTION_DOWN 312
#define ACTION_INCX 400
#define ACTION_DECX 401
#define ACTION_INCY 402
#define ACTION_DECY 403
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define MINFACES 5
#define MAXFACES 5
#define MINTILES 6
#define MAXTILES 6
#define DEFAULTFACES 5
#define DEFAULTTILES 6
#define DEFAULTORIENT FALSE
#define DEFAULTPAIRS TRUE
#define DEFAULTPRACTICE TRUE
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _BarrelRec *BarrelWidget;

#endif /* _XtBarrel_h */
/* DON'T ADD STUFF AFTER THIS #endif */
