/*

    xpuyopuyo - pdialog-gtk.h       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    Header for dialogs


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pdialog_gtk_h_included
#define __pdialog_gtk_h_included


#include <pwindow-gtk.h>


#define P_DIALOG_PUYO_SIZE       4        /* Number of puyos to each side in puyo-grid */


/* Subwindows */
struct _p_dialog_window;
typedef void (*p_dialog_window_handler)(struct _p_dialog_window *dw);
typedef struct _p_dialog_window {
   pwindow_gtk *w;
   GtkWidget *dialog;
   GtkWidget *container;
   p_dialog_window_handler apply;
   gint waiting_for_close;
   gint dialog_accepted;
   gint dialog_modal;
   gpointer data;
} p_dialog_window;

#define  P_DIALOG_OK          0x0001
#define  P_DIALOG_CANCEL      0x0002
#define  P_DIALOG_CLOSE       0x0004
#define  P_DIALOG_APPLY       0x0008
#define  P_DIALOG_PUYOS       0x0400
#define  P_DIALOG_NONMODAL    0x0800
#define  P_DIALOG_MESSAGE     (P_DIALOG_OK | P_DIALOG_PUYOS)
#define  P_DIALOG_QUERY       (P_DIALOG_OK | P_DIALOG_CANCEL | P_DIALOG_PUYOS)


/* Subwindow functions */
void p_dialog_window_new(p_dialog_window *dw, pwindow_gtk *w, const char *title, const char *msgtext, int flags);
void p_dialog_window_set_apply(p_dialog_window *dw, p_dialog_window_handler apply);
void p_dialog_window_set_data(p_dialog_window *dw, gpointer data);
gint p_dialog_window_run(p_dialog_window *dw);


/* Interface functions */
GtkWidget *p_dialog_puyos(pwindow_gtk *w, GtkWidget *msg);
void p_dialog(pwindow_gtk *w, const char *t, const char *s);
void p_dialog_error(pwindow_gtk *w, const char *s);
int  p_dialog_query(pwindow_gtk *w, const char *t, const char *s, char *d, int size);
int  p_dialog_query_value(pwindow_gtk *w, const char *t, const char *s, int *value);
int  p_dialog_query_double(pwindow_gtk *w, const char *t, const char *s, double *value);
void p_dialog_text(pwindow_gtk *w, const char *filename);


#endif

