/*
 * Copyright (c) 2001-2008 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/rib_xif.cc,v 1.37 2008/01/04 03:18:00 pavlin Exp $"

#include "rib_xif.hh"

bool
XrlRibV0p1Client::send_enable_rib(
	const char*	dst_xrl_target_name,
	const EnableRibCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/enable_rib");
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_enable_rib, cb));
}


/* Unmarshall enable_rib */
void
XrlRibV0p1Client::unmarshall_enable_rib(
	const XrlError&	e,
	XrlArgs*	a,
	EnableRibCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_disable_rib(
	const char*	dst_xrl_target_name,
	const DisableRibCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/disable_rib");
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_disable_rib, cb));
}


/* Unmarshall disable_rib */
void
XrlRibV0p1Client::unmarshall_disable_rib(
	const XrlError&	e,
	XrlArgs*	a,
	DisableRibCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_start_rib(
	const char*	dst_xrl_target_name,
	const StartRibCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/start_rib");
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_start_rib, cb));
}


/* Unmarshall start_rib */
void
XrlRibV0p1Client::unmarshall_start_rib(
	const XrlError&	e,
	XrlArgs*	a,
	StartRibCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_stop_rib(
	const char*	dst_xrl_target_name,
	const StopRibCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/stop_rib");
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_stop_rib, cb));
}


/* Unmarshall stop_rib */
void
XrlRibV0p1Client::unmarshall_stop_rib(
	const XrlError&	e,
	XrlArgs*	a,
	StopRibCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_make_errors_fatal(
	const char*	dst_xrl_target_name,
	const MakeErrorsFatalCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/make_errors_fatal");
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_make_errors_fatal, cb));
}


/* Unmarshall make_errors_fatal */
void
XrlRibV0p1Client::unmarshall_make_errors_fatal(
	const XrlError&	e,
	XrlArgs*	a,
	MakeErrorsFatalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_get_registered_protocols(
	const char*	dst_xrl_target_name,
	const bool&	ipv4,
	const bool&	ipv6,
	const bool&	unicast,
	const bool&	multicast,
	const GetRegisteredProtocolsCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/get_registered_protocols");
    x.args().add("ipv4", ipv4);
    x.args().add("ipv6", ipv6);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_get_registered_protocols, cb));
}


/* Unmarshall get_registered_protocols */
void
XrlRibV0p1Client::unmarshall_get_registered_protocols(
	const XrlError&	e,
	XrlArgs*	a,
	GetRegisteredProtocolsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    XrlAtomList ipv4_unicast_protocols;
    XrlAtomList ipv6_unicast_protocols;
    XrlAtomList ipv4_multicast_protocols;
    XrlAtomList ipv6_multicast_protocols;
    try {
	a->get("ipv4_unicast_protocols", ipv4_unicast_protocols);
	a->get("ipv6_unicast_protocols", ipv6_unicast_protocols);
	a->get("ipv4_multicast_protocols", ipv4_multicast_protocols);
	a->get("ipv6_multicast_protocols", ipv6_multicast_protocols);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &ipv4_unicast_protocols, &ipv6_unicast_protocols, &ipv4_multicast_protocols, &ipv6_multicast_protocols);
}

bool
XrlRibV0p1Client::send_add_igp_table4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const AddIgpTable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_igp_table4");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_igp_table4, cb));
}


/* Unmarshall add_igp_table4 */
void
XrlRibV0p1Client::unmarshall_add_igp_table4(
	const XrlError&	e,
	XrlArgs*	a,
	AddIgpTable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_igp_table6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const AddIgpTable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_igp_table6");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_igp_table6, cb));
}


/* Unmarshall add_igp_table6 */
void
XrlRibV0p1Client::unmarshall_add_igp_table6(
	const XrlError&	e,
	XrlArgs*	a,
	AddIgpTable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_delete_igp_table4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const DeleteIgpTable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/delete_igp_table4");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_delete_igp_table4, cb));
}


/* Unmarshall delete_igp_table4 */
void
XrlRibV0p1Client::unmarshall_delete_igp_table4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteIgpTable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_delete_igp_table6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const DeleteIgpTable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/delete_igp_table6");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_delete_igp_table6, cb));
}


/* Unmarshall delete_igp_table6 */
void
XrlRibV0p1Client::unmarshall_delete_igp_table6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteIgpTable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_egp_table4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const AddEgpTable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_egp_table4");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_egp_table4, cb));
}


/* Unmarshall add_egp_table4 */
void
XrlRibV0p1Client::unmarshall_add_egp_table4(
	const XrlError&	e,
	XrlArgs*	a,
	AddEgpTable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_egp_table6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const AddEgpTable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_egp_table6");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_egp_table6, cb));
}


/* Unmarshall add_egp_table6 */
void
XrlRibV0p1Client::unmarshall_add_egp_table6(
	const XrlError&	e,
	XrlArgs*	a,
	AddEgpTable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_delete_egp_table4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const DeleteEgpTable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/delete_egp_table4");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_delete_egp_table4, cb));
}


/* Unmarshall delete_egp_table4 */
void
XrlRibV0p1Client::unmarshall_delete_egp_table4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteEgpTable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_delete_egp_table6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const string&	target_class,
	const string&	target_instance,
	const bool&	unicast,
	const bool&	multicast,
	const DeleteEgpTable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/delete_egp_table6");
    x.args().add("protocol", protocol);
    x.args().add("target_class", target_class);
    x.args().add("target_instance", target_instance);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_delete_egp_table6, cb));
}


/* Unmarshall delete_egp_table6 */
void
XrlRibV0p1Client::unmarshall_delete_egp_table6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteEgpTable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_route4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network,
	const IPv4&	nexthop,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const AddRoute4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_route4");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_route4, cb));
}


/* Unmarshall add_route4 */
void
XrlRibV0p1Client::unmarshall_add_route4(
	const XrlError&	e,
	XrlArgs*	a,
	AddRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_route6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network,
	const IPv6&	nexthop,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const AddRoute6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_route6");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_route6, cb));
}


/* Unmarshall add_route6 */
void
XrlRibV0p1Client::unmarshall_add_route6(
	const XrlError&	e,
	XrlArgs*	a,
	AddRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_replace_route4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network,
	const IPv4&	nexthop,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const ReplaceRoute4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/replace_route4");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_replace_route4, cb));
}


/* Unmarshall replace_route4 */
void
XrlRibV0p1Client::unmarshall_replace_route4(
	const XrlError&	e,
	XrlArgs*	a,
	ReplaceRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_replace_route6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network,
	const IPv6&	nexthop,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const ReplaceRoute6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/replace_route6");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_replace_route6, cb));
}


/* Unmarshall replace_route6 */
void
XrlRibV0p1Client::unmarshall_replace_route6(
	const XrlError&	e,
	XrlArgs*	a,
	ReplaceRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_delete_route4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network,
	const DeleteRoute4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/delete_route4");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_delete_route4, cb));
}


/* Unmarshall delete_route4 */
void
XrlRibV0p1Client::unmarshall_delete_route4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_delete_route6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network,
	const DeleteRoute6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/delete_route6");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_delete_route6, cb));
}


/* Unmarshall delete_route6 */
void
XrlRibV0p1Client::unmarshall_delete_route6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_interface_route4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network,
	const IPv4&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const AddInterfaceRoute4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_interface_route4");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_interface_route4, cb));
}


/* Unmarshall add_interface_route4 */
void
XrlRibV0p1Client::unmarshall_add_interface_route4(
	const XrlError&	e,
	XrlArgs*	a,
	AddInterfaceRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_interface_route6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network,
	const IPv6&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const AddInterfaceRoute6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_interface_route6");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_interface_route6, cb));
}


/* Unmarshall add_interface_route6 */
void
XrlRibV0p1Client::unmarshall_add_interface_route6(
	const XrlError&	e,
	XrlArgs*	a,
	AddInterfaceRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_replace_interface_route4(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network,
	const IPv4&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const ReplaceInterfaceRoute4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/replace_interface_route4");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_replace_interface_route4, cb));
}


/* Unmarshall replace_interface_route4 */
void
XrlRibV0p1Client::unmarshall_replace_interface_route4(
	const XrlError&	e,
	XrlArgs*	a,
	ReplaceInterfaceRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_replace_interface_route6(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network,
	const IPv6&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const XrlAtomList&	policytags,
	const ReplaceInterfaceRoute6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/replace_interface_route6");
    x.args().add("protocol", protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network", network);
    x.args().add("nexthop", nexthop);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_replace_interface_route6, cb));
}


/* Unmarshall replace_interface_route6 */
void
XrlRibV0p1Client::unmarshall_replace_interface_route6(
	const XrlError&	e,
	XrlArgs*	a,
	ReplaceInterfaceRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_lookup_route_by_dest4(
	const char*	dst_xrl_target_name,
	const IPv4&	addr,
	const bool&	unicast,
	const bool&	multicast,
	const LookupRouteByDest4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/lookup_route_by_dest4");
    x.args().add("addr", addr);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_lookup_route_by_dest4, cb));
}


/* Unmarshall lookup_route_by_dest4 */
void
XrlRibV0p1Client::unmarshall_lookup_route_by_dest4(
	const XrlError&	e,
	XrlArgs*	a,
	LookupRouteByDest4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv4 nexthop;
    try {
	a->get("nexthop", nexthop);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &nexthop);
}

bool
XrlRibV0p1Client::send_lookup_route_by_dest6(
	const char*	dst_xrl_target_name,
	const IPv6&	addr,
	const bool&	unicast,
	const bool&	multicast,
	const LookupRouteByDest6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/lookup_route_by_dest6");
    x.args().add("addr", addr);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_lookup_route_by_dest6, cb));
}


/* Unmarshall lookup_route_by_dest6 */
void
XrlRibV0p1Client::unmarshall_lookup_route_by_dest6(
	const XrlError&	e,
	XrlArgs*	a,
	LookupRouteByDest6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv6 nexthop;
    try {
	a->get("nexthop", nexthop);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &nexthop);
}

bool
XrlRibV0p1Client::send_new_vif(
	const char*	dst_xrl_target_name,
	const string&	name,
	const NewVifCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/new_vif");
    x.args().add("name", name);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_new_vif, cb));
}


/* Unmarshall new_vif */
void
XrlRibV0p1Client::unmarshall_new_vif(
	const XrlError&	e,
	XrlArgs*	a,
	NewVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_vif_addr4(
	const char*	dst_xrl_target_name,
	const string&	name,
	const IPv4&	addr,
	const IPv4Net&	subnet,
	const AddVifAddr4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_vif_addr4");
    x.args().add("name", name);
    x.args().add("addr", addr);
    x.args().add("subnet", subnet);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_vif_addr4, cb));
}


/* Unmarshall add_vif_addr4 */
void
XrlRibV0p1Client::unmarshall_add_vif_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	AddVifAddr4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_add_vif_addr6(
	const char*	dst_xrl_target_name,
	const string&	name,
	const IPv6&	addr,
	const IPv6Net&	subnet,
	const AddVifAddr6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/add_vif_addr6");
    x.args().add("name", name);
    x.args().add("addr", addr);
    x.args().add("subnet", subnet);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_add_vif_addr6, cb));
}


/* Unmarshall add_vif_addr6 */
void
XrlRibV0p1Client::unmarshall_add_vif_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	AddVifAddr6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_enable4(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network_prefix,
	const string&	cookie,
	const RedistEnable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_enable4");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network_prefix", network_prefix);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_enable4, cb));
}


/* Unmarshall redist_enable4 */
void
XrlRibV0p1Client::unmarshall_redist_enable4(
	const XrlError&	e,
	XrlArgs*	a,
	RedistEnable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_enable6(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network_prefix,
	const string&	cookie,
	const RedistEnable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_enable6");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network_prefix", network_prefix);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_enable6, cb));
}


/* Unmarshall redist_enable6 */
void
XrlRibV0p1Client::unmarshall_redist_enable6(
	const XrlError&	e,
	XrlArgs*	a,
	RedistEnable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_disable4(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const string&	cookie,
	const RedistDisable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_disable4");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_disable4, cb));
}


/* Unmarshall redist_disable4 */
void
XrlRibV0p1Client::unmarshall_redist_disable4(
	const XrlError&	e,
	XrlArgs*	a,
	RedistDisable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_disable6(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const string&	cookie,
	const RedistDisable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_disable6");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_disable6, cb));
}


/* Unmarshall redist_disable6 */
void
XrlRibV0p1Client::unmarshall_redist_disable6(
	const XrlError&	e,
	XrlArgs*	a,
	RedistDisable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_transaction_enable4(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv4Net&	network_prefix,
	const string&	cookie,
	const RedistTransactionEnable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_transaction_enable4");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network_prefix", network_prefix);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_transaction_enable4, cb));
}


/* Unmarshall redist_transaction_enable4 */
void
XrlRibV0p1Client::unmarshall_redist_transaction_enable4(
	const XrlError&	e,
	XrlArgs*	a,
	RedistTransactionEnable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_transaction_enable6(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const IPv6Net&	network_prefix,
	const string&	cookie,
	const RedistTransactionEnable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_transaction_enable6");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("network_prefix", network_prefix);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_transaction_enable6, cb));
}


/* Unmarshall redist_transaction_enable6 */
void
XrlRibV0p1Client::unmarshall_redist_transaction_enable6(
	const XrlError&	e,
	XrlArgs*	a,
	RedistTransactionEnable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_transaction_disable4(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const string&	cookie,
	const RedistTransactionDisable4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_transaction_disable4");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_transaction_disable4, cb));
}


/* Unmarshall redist_transaction_disable4 */
void
XrlRibV0p1Client::unmarshall_redist_transaction_disable4(
	const XrlError&	e,
	XrlArgs*	a,
	RedistTransactionDisable4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_redist_transaction_disable6(
	const char*	dst_xrl_target_name,
	const string&	to_xrl_target,
	const string&	from_protocol,
	const bool&	unicast,
	const bool&	multicast,
	const string&	cookie,
	const RedistTransactionDisable6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/redist_transaction_disable6");
    x.args().add("to_xrl_target", to_xrl_target);
    x.args().add("from_protocol", from_protocol);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_redist_transaction_disable6, cb));
}


/* Unmarshall redist_transaction_disable6 */
void
XrlRibV0p1Client::unmarshall_redist_transaction_disable6(
	const XrlError&	e,
	XrlArgs*	a,
	RedistTransactionDisable6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_register_interest4(
	const char*	dst_xrl_target_name,
	const string&	target,
	const IPv4&	addr,
	const RegisterInterest4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/register_interest4");
    x.args().add("target", target);
    x.args().add("addr", addr);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_register_interest4, cb));
}


/* Unmarshall register_interest4 */
void
XrlRibV0p1Client::unmarshall_register_interest4(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterInterest4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(6));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    bool resolves;
    IPv4 base_addr;
    uint32_t prefix_len;
    uint32_t real_prefix_len;
    IPv4 nexthop;
    uint32_t metric;
    try {
	a->get("resolves", resolves);
	a->get("base_addr", base_addr);
	a->get("prefix_len", prefix_len);
	a->get("real_prefix_len", real_prefix_len);
	a->get("nexthop", nexthop);
	a->get("metric", metric);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &resolves, &base_addr, &prefix_len, &real_prefix_len, &nexthop, &metric);
}

bool
XrlRibV0p1Client::send_deregister_interest4(
	const char*	dst_xrl_target_name,
	const string&	target,
	const IPv4&	addr,
	const uint32_t&	prefix_len,
	const DeregisterInterest4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/deregister_interest4");
    x.args().add("target", target);
    x.args().add("addr", addr);
    x.args().add("prefix_len", prefix_len);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_deregister_interest4, cb));
}


/* Unmarshall deregister_interest4 */
void
XrlRibV0p1Client::unmarshall_deregister_interest4(
	const XrlError&	e,
	XrlArgs*	a,
	DeregisterInterest4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_register_interest6(
	const char*	dst_xrl_target_name,
	const string&	target,
	const IPv6&	addr,
	const RegisterInterest6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/register_interest6");
    x.args().add("target", target);
    x.args().add("addr", addr);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_register_interest6, cb));
}


/* Unmarshall register_interest6 */
void
XrlRibV0p1Client::unmarshall_register_interest6(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterInterest6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(6));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    bool resolves;
    IPv6 base_addr;
    uint32_t prefix_len;
    uint32_t real_prefix_len;
    IPv6 nexthop;
    uint32_t metric;
    try {
	a->get("resolves", resolves);
	a->get("base_addr", base_addr);
	a->get("prefix_len", prefix_len);
	a->get("real_prefix_len", real_prefix_len);
	a->get("nexthop", nexthop);
	a->get("metric", metric);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &resolves, &base_addr, &prefix_len, &real_prefix_len, &nexthop, &metric);
}

bool
XrlRibV0p1Client::send_deregister_interest6(
	const char*	dst_xrl_target_name,
	const string&	target,
	const IPv6&	addr,
	const uint32_t&	prefix_len,
	const DeregisterInterest6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/deregister_interest6");
    x.args().add("target", target);
    x.args().add("addr", addr);
    x.args().add("prefix_len", prefix_len);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_deregister_interest6, cb));
}


/* Unmarshall deregister_interest6 */
void
XrlRibV0p1Client::unmarshall_deregister_interest6(
	const XrlError&	e,
	XrlArgs*	a,
	DeregisterInterest6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_insert_policy_redist_tags(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const XrlAtomList&	policytags,
	const InsertPolicyRedistTagsCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/insert_policy_redist_tags");
    x.args().add("protocol", protocol);
    x.args().add("policytags", policytags);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_insert_policy_redist_tags, cb));
}


/* Unmarshall insert_policy_redist_tags */
void
XrlRibV0p1Client::unmarshall_insert_policy_redist_tags(
	const XrlError&	e,
	XrlArgs*	a,
	InsertPolicyRedistTagsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_reset_policy_redist_tags(
	const char*	dst_xrl_target_name,
	const ResetPolicyRedistTagsCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/reset_policy_redist_tags");
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_reset_policy_redist_tags, cb));
}


/* Unmarshall reset_policy_redist_tags */
void
XrlRibV0p1Client::unmarshall_reset_policy_redist_tags(
	const XrlError&	e,
	XrlArgs*	a,
	ResetPolicyRedistTagsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRibV0p1Client::send_get_protocol_admin_distances(
	const char*	dst_xrl_target_name,
	const bool&	ipv4,
	const bool&	unicast,
	const GetProtocolAdminDistancesCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/get_protocol_admin_distances");
    x.args().add("ipv4", ipv4);
    x.args().add("unicast", unicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_get_protocol_admin_distances, cb));
}


/* Unmarshall get_protocol_admin_distances */
void
XrlRibV0p1Client::unmarshall_get_protocol_admin_distances(
	const XrlError&	e,
	XrlArgs*	a,
	GetProtocolAdminDistancesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    XrlAtomList protocols;
    XrlAtomList admin_distances;
    try {
	a->get("protocols", protocols);
	a->get("admin_distances", admin_distances);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &protocols, &admin_distances);
}

bool
XrlRibV0p1Client::send_get_protocol_admin_distance(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	ipv4,
	const bool&	unicast,
	const GetProtocolAdminDistanceCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/get_protocol_admin_distance");
    x.args().add("protocol", protocol);
    x.args().add("ipv4", ipv4);
    x.args().add("unicast", unicast);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_get_protocol_admin_distance, cb));
}


/* Unmarshall get_protocol_admin_distance */
void
XrlRibV0p1Client::unmarshall_get_protocol_admin_distance(
	const XrlError&	e,
	XrlArgs*	a,
	GetProtocolAdminDistanceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t admin_distance;
    try {
	a->get("admin_distance", admin_distance);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &admin_distance);
}

bool
XrlRibV0p1Client::send_set_protocol_admin_distance(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const bool&	ipv4,
	const bool&	ipv6,
	const bool&	unicast,
	const bool&	multicast,
	const uint32_t&	admin_distance,
	const SetProtocolAdminDistanceCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "rib/0.1/set_protocol_admin_distance");
    x.args().add("protocol", protocol);
    x.args().add("ipv4", ipv4);
    x.args().add("ipv6", ipv6);
    x.args().add("unicast", unicast);
    x.args().add("multicast", multicast);
    x.args().add("admin_distance", admin_distance);
    return _sender->send(x, callback(this, &XrlRibV0p1Client::unmarshall_set_protocol_admin_distance, cb));
}


/* Unmarshall set_protocol_admin_distance */
void
XrlRibV0p1Client::unmarshall_set_protocol_admin_distance(
	const XrlError&	e,
	XrlArgs*	a,
	SetProtocolAdminDistanceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
