/*
 * Copyright (c) 2001-2008 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/fea_ifmgr_xif.cc,v 1.40 2008/01/04 03:17:53 pavlin Exp $"

#include "fea_ifmgr_xif.hh"

bool
XrlIfmgrV0p1Client::send_set_restore_original_config_on_shutdown(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const SetRestoreOriginalConfigOnShutdownCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_restore_original_config_on_shutdown");
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_restore_original_config_on_shutdown, cb));
}


/* Unmarshall set_restore_original_config_on_shutdown */
void
XrlIfmgrV0p1Client::unmarshall_set_restore_original_config_on_shutdown(
	const XrlError&	e,
	XrlArgs*	a,
	SetRestoreOriginalConfigOnShutdownCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_get_configured_interface_names(
	const char*	dst_xrl_target_name,
	const GetConfiguredInterfaceNamesCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_interface_names");
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_interface_names, cb));
}


/* Unmarshall get_configured_interface_names */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_interface_names(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceNamesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList ifnames;
    try {
	a->get("ifnames", ifnames);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &ifnames);
}

bool
XrlIfmgrV0p1Client::send_get_configured_vif_names(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredVifNamesCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_vif_names");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_vif_names, cb));
}


/* Unmarshall get_configured_vif_names */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_vif_names(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifNamesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList vifs;
    try {
	a->get("vifs", vifs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &vifs);
}

bool
XrlIfmgrV0p1Client::send_get_configured_vif_flags(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifFlagsCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_vif_flags");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_vif_flags, cb));
}


/* Unmarshall get_configured_vif_flags */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_vif_flags(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifFlagsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	a->get("enabled", enabled);
	a->get("broadcast", broadcast);
	a->get("loopback", loopback);
	a->get("point_to_point", point_to_point);
	a->get("multicast", multicast);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &enabled, &broadcast, &loopback, &point_to_point, &multicast);
}

bool
XrlIfmgrV0p1Client::send_get_configured_vif_pif_index(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifPifIndexCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_vif_pif_index");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_vif_pif_index, cb));
}


/* Unmarshall get_configured_vif_pif_index */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_vif_pif_index(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifPifIndexCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t pif_index;
    try {
	a->get("pif_index", pif_index);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &pif_index);
}

bool
XrlIfmgrV0p1Client::send_get_configured_vif_addresses4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifAddresses4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_vif_addresses4");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_vif_addresses4, cb));
}


/* Unmarshall get_configured_vif_addresses4 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_vif_addresses4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifAddresses4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList addresses;
    try {
	a->get("addresses", addresses);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &addresses);
}

bool
XrlIfmgrV0p1Client::send_get_configured_vif_addresses6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifAddresses6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_vif_addresses6");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_vif_addresses6, cb));
}


/* Unmarshall get_configured_vif_addresses6 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_vif_addresses6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifAddresses6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList addresses;
    try {
	a->get("addresses", addresses);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &addresses);
}

bool
XrlIfmgrV0p1Client::send_get_configured_address_flags4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredAddressFlags4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_address_flags4");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_address_flags4, cb));
}


/* Unmarshall get_configured_address_flags4 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_address_flags4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressFlags4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	a->get("enabled", enabled);
	a->get("broadcast", broadcast);
	a->get("loopback", loopback);
	a->get("point_to_point", point_to_point);
	a->get("multicast", multicast);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &enabled, &broadcast, &loopback, &point_to_point, &multicast);
}

bool
XrlIfmgrV0p1Client::send_get_configured_address_flags6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredAddressFlags6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_address_flags6");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_address_flags6, cb));
}


/* Unmarshall get_configured_address_flags6 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_address_flags6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressFlags6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    bool enabled;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	a->get("enabled", enabled);
	a->get("loopback", loopback);
	a->get("point_to_point", point_to_point);
	a->get("multicast", multicast);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &enabled, &loopback, &point_to_point, &multicast);
}

bool
XrlIfmgrV0p1Client::send_get_configured_interface_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceEnabledCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_interface_enabled");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_interface_enabled, cb));
}


/* Unmarshall get_configured_interface_enabled */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_interface_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlIfmgrV0p1Client::send_get_configured_interface_discard(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceDiscardCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_interface_discard");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_interface_discard, cb));
}


/* Unmarshall get_configured_interface_discard */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_interface_discard(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceDiscardCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool discard;
    try {
	a->get("discard", discard);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &discard);
}

bool
XrlIfmgrV0p1Client::send_get_configured_interface_unreachable(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceUnreachableCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_interface_unreachable");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_interface_unreachable, cb));
}


/* Unmarshall get_configured_interface_unreachable */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_interface_unreachable(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceUnreachableCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool unreachable;
    try {
	a->get("unreachable", unreachable);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &unreachable);
}

bool
XrlIfmgrV0p1Client::send_get_configured_interface_management(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceManagementCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_interface_management");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_interface_management, cb));
}


/* Unmarshall get_configured_interface_management */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_interface_management(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceManagementCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool management;
    try {
	a->get("management", management);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &management);
}

bool
XrlIfmgrV0p1Client::send_get_configured_mac(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredMacCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_mac");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_mac, cb));
}


/* Unmarshall get_configured_mac */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_mac(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredMacCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    Mac mac;
    try {
	a->get("mac", mac);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &mac);
}

bool
XrlIfmgrV0p1Client::send_get_configured_mtu(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredMtuCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_mtu");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_mtu, cb));
}


/* Unmarshall get_configured_mtu */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredMtuCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t mtu;
    try {
	a->get("mtu", mtu);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &mtu);
}

bool
XrlIfmgrV0p1Client::send_get_configured_no_carrier(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredNoCarrierCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_no_carrier");
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_no_carrier, cb));
}


/* Unmarshall get_configured_no_carrier */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_no_carrier(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredNoCarrierCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool no_carrier;
    try {
	a->get("no_carrier", no_carrier);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &no_carrier);
}

bool
XrlIfmgrV0p1Client::send_get_configured_vif_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifEnabledCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_vif_enabled");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_vif_enabled, cb));
}


/* Unmarshall get_configured_vif_enabled */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_vif_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlIfmgrV0p1Client::send_get_configured_prefix4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredPrefix4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_prefix4");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_prefix4, cb));
}


/* Unmarshall get_configured_prefix4 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_prefix4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredPrefix4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t prefix_len;
    try {
	a->get("prefix_len", prefix_len);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &prefix_len);
}

bool
XrlIfmgrV0p1Client::send_get_configured_broadcast4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredBroadcast4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_broadcast4");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_broadcast4, cb));
}


/* Unmarshall get_configured_broadcast4 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_broadcast4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredBroadcast4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv4 broadcast;
    try {
	a->get("broadcast", broadcast);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &broadcast);
}

bool
XrlIfmgrV0p1Client::send_get_configured_endpoint4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredEndpoint4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_endpoint4");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_endpoint4, cb));
}


/* Unmarshall get_configured_endpoint4 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_endpoint4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredEndpoint4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv4 endpoint;
    try {
	a->get("endpoint", endpoint);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &endpoint);
}

bool
XrlIfmgrV0p1Client::send_get_configured_prefix6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredPrefix6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_prefix6");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_prefix6, cb));
}


/* Unmarshall get_configured_prefix6 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_prefix6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredPrefix6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t prefix_len;
    try {
	a->get("prefix_len", prefix_len);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &prefix_len);
}

bool
XrlIfmgrV0p1Client::send_get_configured_endpoint6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredEndpoint6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_endpoint6");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_endpoint6, cb));
}


/* Unmarshall get_configured_endpoint6 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_endpoint6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredEndpoint6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv6 endpoint;
    try {
	a->get("endpoint", endpoint);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &endpoint);
}

bool
XrlIfmgrV0p1Client::send_start_transaction(
	const char*	dst_xrl_target_name,
	const StartTransactionCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/start_transaction");
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_start_transaction, cb));
}


/* Unmarshall start_transaction */
void
XrlIfmgrV0p1Client::unmarshall_start_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	StartTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t tid;
    try {
	a->get("tid", tid);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &tid);
}

bool
XrlIfmgrV0p1Client::send_commit_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const CommitTransactionCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/commit_transaction");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_commit_transaction, cb));
}


/* Unmarshall commit_transaction */
void
XrlIfmgrV0p1Client::unmarshall_commit_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	CommitTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_abort_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const AbortTransactionCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/abort_transaction");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_abort_transaction, cb));
}


/* Unmarshall abort_transaction */
void
XrlIfmgrV0p1Client::unmarshall_abort_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	AbortTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_create_interface(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const CreateInterfaceCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/create_interface");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_create_interface, cb));
}


/* Unmarshall create_interface */
void
XrlIfmgrV0p1Client::unmarshall_create_interface(
	const XrlError&	e,
	XrlArgs*	a,
	CreateInterfaceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_delete_interface(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const DeleteInterfaceCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/delete_interface");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_delete_interface, cb));
}


/* Unmarshall delete_interface */
void
XrlIfmgrV0p1Client::unmarshall_delete_interface(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteInterfaceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_configure_all_interfaces_from_system(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const bool&	enable,
	const ConfigureAllInterfacesFromSystemCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/configure_all_interfaces_from_system");
    x.args().add("tid", tid);
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_configure_all_interfaces_from_system, cb));
}


/* Unmarshall configure_all_interfaces_from_system */
void
XrlIfmgrV0p1Client::unmarshall_configure_all_interfaces_from_system(
	const XrlError&	e,
	XrlArgs*	a,
	ConfigureAllInterfacesFromSystemCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_configure_interface_from_system(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	enable,
	const ConfigureInterfaceFromSystemCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/configure_interface_from_system");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_configure_interface_from_system, cb));
}


/* Unmarshall configure_interface_from_system */
void
XrlIfmgrV0p1Client::unmarshall_configure_interface_from_system(
	const XrlError&	e,
	XrlArgs*	a,
	ConfigureInterfaceFromSystemCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_interface_enabled(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	enabled,
	const SetInterfaceEnabledCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_interface_enabled");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_interface_enabled, cb));
}


/* Unmarshall set_interface_enabled */
void
XrlIfmgrV0p1Client::unmarshall_set_interface_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_interface_discard(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	discard,
	const SetInterfaceDiscardCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_interface_discard");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("discard", discard);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_interface_discard, cb));
}


/* Unmarshall set_interface_discard */
void
XrlIfmgrV0p1Client::unmarshall_set_interface_discard(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceDiscardCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_interface_unreachable(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	unreachable,
	const SetInterfaceUnreachableCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_interface_unreachable");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("unreachable", unreachable);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_interface_unreachable, cb));
}


/* Unmarshall set_interface_unreachable */
void
XrlIfmgrV0p1Client::unmarshall_set_interface_unreachable(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceUnreachableCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_interface_management(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	management,
	const SetInterfaceManagementCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_interface_management");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("management", management);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_interface_management, cb));
}


/* Unmarshall set_interface_management */
void
XrlIfmgrV0p1Client::unmarshall_set_interface_management(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceManagementCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_mac(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const Mac&	mac,
	const SetMacCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_mac");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("mac", mac);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_mac, cb));
}


/* Unmarshall set_mac */
void
XrlIfmgrV0p1Client::unmarshall_set_mac(
	const XrlError&	e,
	XrlArgs*	a,
	SetMacCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_restore_original_mac(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const RestoreOriginalMacCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/restore_original_mac");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_restore_original_mac, cb));
}


/* Unmarshall restore_original_mac */
void
XrlIfmgrV0p1Client::unmarshall_restore_original_mac(
	const XrlError&	e,
	XrlArgs*	a,
	RestoreOriginalMacCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_mtu(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const uint32_t&	mtu,
	const SetMtuCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_mtu");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("mtu", mtu);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_mtu, cb));
}


/* Unmarshall set_mtu */
void
XrlIfmgrV0p1Client::unmarshall_set_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	SetMtuCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_restore_original_mtu(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const RestoreOriginalMtuCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/restore_original_mtu");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_restore_original_mtu, cb));
}


/* Unmarshall restore_original_mtu */
void
XrlIfmgrV0p1Client::unmarshall_restore_original_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	RestoreOriginalMtuCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_create_vif(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const CreateVifCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/create_vif");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_create_vif, cb));
}


/* Unmarshall create_vif */
void
XrlIfmgrV0p1Client::unmarshall_create_vif(
	const XrlError&	e,
	XrlArgs*	a,
	CreateVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_delete_vif(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const DeleteVifCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/delete_vif");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_delete_vif, cb));
}


/* Unmarshall delete_vif */
void
XrlIfmgrV0p1Client::unmarshall_delete_vif(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_vif_enabled(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const bool&	enabled,
	const SetVifEnabledCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_vif_enabled");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_vif_enabled, cb));
}


/* Unmarshall set_vif_enabled */
void
XrlIfmgrV0p1Client::unmarshall_set_vif_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_vif_vlan(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const uint32_t&	vlan_id,
	const SetVifVlanCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_vif_vlan");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("vlan_id", vlan_id);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_vif_vlan, cb));
}


/* Unmarshall set_vif_vlan */
void
XrlIfmgrV0p1Client::unmarshall_set_vif_vlan(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifVlanCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_create_address4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const CreateAddress4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/create_address4");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_create_address4, cb));
}


/* Unmarshall create_address4 */
void
XrlIfmgrV0p1Client::unmarshall_create_address4(
	const XrlError&	e,
	XrlArgs*	a,
	CreateAddress4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_delete_address4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const DeleteAddress4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/delete_address4");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_delete_address4, cb));
}


/* Unmarshall delete_address4 */
void
XrlIfmgrV0p1Client::unmarshall_delete_address4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAddress4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_address_enabled4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const bool&	enabled,
	const SetAddressEnabled4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_address_enabled4");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_address_enabled4, cb));
}


/* Unmarshall set_address_enabled4 */
void
XrlIfmgrV0p1Client::unmarshall_set_address_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	SetAddressEnabled4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_get_configured_address_enabled4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredAddressEnabled4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_address_enabled4");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_address_enabled4, cb));
}


/* Unmarshall get_configured_address_enabled4 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_address_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressEnabled4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlIfmgrV0p1Client::send_set_prefix4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const uint32_t&	prefix_len,
	const SetPrefix4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_prefix4");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("prefix_len", prefix_len);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_prefix4, cb));
}


/* Unmarshall set_prefix4 */
void
XrlIfmgrV0p1Client::unmarshall_set_prefix4(
	const XrlError&	e,
	XrlArgs*	a,
	SetPrefix4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_broadcast4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const IPv4&	broadcast,
	const SetBroadcast4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_broadcast4");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("broadcast", broadcast);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_broadcast4, cb));
}


/* Unmarshall set_broadcast4 */
void
XrlIfmgrV0p1Client::unmarshall_set_broadcast4(
	const XrlError&	e,
	XrlArgs*	a,
	SetBroadcast4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_endpoint4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const IPv4&	endpoint,
	const SetEndpoint4CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_endpoint4");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("endpoint", endpoint);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_endpoint4, cb));
}


/* Unmarshall set_endpoint4 */
void
XrlIfmgrV0p1Client::unmarshall_set_endpoint4(
	const XrlError&	e,
	XrlArgs*	a,
	SetEndpoint4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_create_address6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const CreateAddress6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/create_address6");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_create_address6, cb));
}


/* Unmarshall create_address6 */
void
XrlIfmgrV0p1Client::unmarshall_create_address6(
	const XrlError&	e,
	XrlArgs*	a,
	CreateAddress6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_delete_address6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const DeleteAddress6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/delete_address6");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_delete_address6, cb));
}


/* Unmarshall delete_address6 */
void
XrlIfmgrV0p1Client::unmarshall_delete_address6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAddress6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_address_enabled6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const bool&	enabled,
	const SetAddressEnabled6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_address_enabled6");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_address_enabled6, cb));
}


/* Unmarshall set_address_enabled6 */
void
XrlIfmgrV0p1Client::unmarshall_set_address_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	SetAddressEnabled6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_get_configured_address_enabled6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredAddressEnabled6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/get_configured_address_enabled6");
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_get_configured_address_enabled6, cb));
}


/* Unmarshall get_configured_address_enabled6 */
void
XrlIfmgrV0p1Client::unmarshall_get_configured_address_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressEnabled6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlIfmgrV0p1Client::send_set_prefix6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const uint32_t&	prefix_len,
	const SetPrefix6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_prefix6");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("prefix_len", prefix_len);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_prefix6, cb));
}


/* Unmarshall set_prefix6 */
void
XrlIfmgrV0p1Client::unmarshall_set_prefix6(
	const XrlError&	e,
	XrlArgs*	a,
	SetPrefix6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlIfmgrV0p1Client::send_set_endpoint6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const IPv6&	endpoint,
	const SetEndpoint6CB&	cb
)
{
    Xrl x(dst_xrl_target_name, "ifmgr/0.1/set_endpoint6");
    x.args().add("tid", tid);
    x.args().add("ifname", ifname);
    x.args().add("vif", vif);
    x.args().add("address", address);
    x.args().add("endpoint", endpoint);
    return _sender->send(x, callback(this, &XrlIfmgrV0p1Client::unmarshall_set_endpoint6, cb));
}


/* Unmarshall set_endpoint6 */
void
XrlIfmgrV0p1Client::unmarshall_set_endpoint6(
	const XrlError&	e,
	XrlArgs*	a,
	SetEndpoint6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
