static_routes_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_common_get_target_name"
        exit 1
    fi

    XRL="finder://static_routes/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_common_get_version"
        exit 1
    fi

    XRL="finder://static_routes/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_common_get_status"
        exit 1
    fi

    XRL="finder://static_routes/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_common_shutdown"
        exit 1
    fi

    XRL="finder://static_routes/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_finder_event_observer_xrl_target_birth()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: static_routes_finder_event_observer_xrl_target_birth <target_class:txt> <target_instance:txt>"
        exit 1
    fi

    XRL="finder://static_routes/finder_event_observer/0.1/xrl_target_birth?target_class:txt=$1&target_instance:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_finder_event_observer_xrl_target_death()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: static_routes_finder_event_observer_xrl_target_death <target_class:txt> <target_instance:txt>"
        exit 1
    fi

    XRL="finder://static_routes/finder_event_observer/0.1/xrl_target_death?target_class:txt=$1&target_instance:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_policy_backend_configure()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: static_routes_policy_backend_configure <filter:u32> <conf:txt>"
        exit 1
    fi

    XRL="finder://static_routes/policy_backend/0.1/configure?filter:u32=$1&conf:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_policy_backend_reset()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: static_routes_policy_backend_reset <filter:u32>"
        exit 1
    fi

    XRL="finder://static_routes/policy_backend/0.1/reset?filter:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_policy_backend_push_routes()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_policy_backend_push_routes"
        exit 1
    fi

    XRL="finder://static_routes/policy_backend/0.1/push_routes"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_enable_static_routes()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: static_routes_static_routes_enable_static_routes <enable:bool>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/enable_static_routes?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_start_static_routes()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_static_routes_start_static_routes"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/start_static_routes"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_stop_static_routes()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: static_routes_static_routes_stop_static_routes"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/stop_static_routes"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_route4()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_add_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_route6()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_add_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_route4()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_replace_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_route6()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_replace_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_route4()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: static_routes_static_routes_delete_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_route6()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: static_routes_static_routes_delete_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_backup_route4()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_add_backup_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_backup_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_backup_route6()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_add_backup_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_backup_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_backup_route4()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_replace_backup_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_backup_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_backup_route6()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: static_routes_static_routes_replace_backup_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_backup_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&metric:u32=$5"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_backup_route4()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: static_routes_static_routes_delete_backup_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_backup_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_backup_route6()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: static_routes_static_routes_delete_backup_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_backup_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_interface_route4()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_add_interface_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_interface_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_interface_route6()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_add_interface_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_interface_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_interface_route4()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_replace_interface_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_interface_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_interface_route6()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_replace_interface_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_interface_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_interface_route4()
{
    if [ $# -ne 6 ] ; then
        echo "Usage: static_routes_static_routes_delete_interface_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_interface_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&ifname:txt=$5&vifname:txt=$6"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_interface_route6()
{
    if [ $# -ne 6 ] ; then
        echo "Usage: static_routes_static_routes_delete_interface_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_interface_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&ifname:txt=$5&vifname:txt=$6"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_backup_interface_route4()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_add_backup_interface_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_backup_interface_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_add_backup_interface_route6()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_add_backup_interface_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/add_backup_interface_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_backup_interface_route4()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_replace_backup_interface_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_backup_interface_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_replace_backup_interface_route6()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: static_routes_static_routes_replace_backup_interface_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt> <metric:u32>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/replace_backup_interface_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&ifname:txt=$5&vifname:txt=$6&metric:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_backup_interface_route4()
{
    if [ $# -ne 6 ] ; then
        echo "Usage: static_routes_static_routes_delete_backup_interface_route4 <unicast:bool> <multicast:bool> <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_backup_interface_route4?unicast:bool=$1&multicast:bool=$2&network:ipv4net=$3&nexthop:ipv4=$4&ifname:txt=$5&vifname:txt=$6"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_delete_backup_interface_route6()
{
    if [ $# -ne 6 ] ; then
        echo "Usage: static_routes_static_routes_delete_backup_interface_route6 <unicast:bool> <multicast:bool> <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/delete_backup_interface_route6?unicast:bool=$1&multicast:bool=$2&network:ipv6net=$3&nexthop:ipv6=$4&ifname:txt=$5&vifname:txt=$6"
    call_xrl_wrapper -p all "${XRL}"
}

static_routes_static_routes_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: static_routes_static_routes_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://static_routes/static_routes/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

