/****************************************************************************
*  Copyright (C) 1998 by Leo Khramov
*  email:     leo@unix1.jinr.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/

//This file contains routines for history fields.
#include "xh.h"
#include "history.h"

#define HMEM_MAX        100
static char *hmem[HMEM_MAX];

#define HIST_MAX        100

static History *hist=NULL;

void init_history()
{
  int i;
  for(i=0;i<HMEM_MAX;i++)
    hmem[i]=NULL;
}


History *hist_gethistory(char *hist_id)
{
  History *h=hist;
  while(h)
  {
    if(strcmp(hist_id,h->id)==0)
      break;
    h=h->neibour;
  }
  if(h!=NULL)
    return h->next;
  return NULL;
}

void hist_add_to_top(char *hist_id, char *string)
{
  History *h=hist;
  History *o=NULL,*po=NULL;
  int coun;
  if(string[0]==0)
    return;
  while(h)
  {
    if(strcmp(hist_id,h->id)==0)
      break;
    h=h->neibour;
  }
  if(h==NULL)
  {
    o=new History(hist_id,"     ");
    o->neibour=hist;
    hist=o;
    h=o;
    o=new History(hist_id,string);
    o->prev=NULL;
    o->next=h->next;
    if(o->next)
      o->next->prev=o;
    h->next=o;
  } else
  {
    o=h->next;
    coun=1;
    while(o)
    {
      if(strcmp(string,o->string)==0)
	break;
      po=o;
      o=o->next;
      coun++;
    }
    if(o==NULL)
    {
      if(coun>=HIST_MAX && po && po->prev)
      {
	po->prev->next=NULL;
	delete po;
      }
      o=new History(hist_id,string);
      o->prev=NULL;
      o->next=h->next;
      if(o->next)
	o->next->prev=o;
      h->next=o;
    } else
    {
      if(h->next!=o)
      {
	if(o->prev)
	  o->prev->next=o->next;
	if(o->next)
	  o->next->prev=o->prev;
	o->prev=o->next=NULL;
	o->next=h->next;
	if(o->next)
	  o->next->prev=o;
	h->next=o;
      }
    }
  }
        
  if(o && o->next==o)
    o->next=NULL;
        
}        

void hist_addstring(char *hist_id, char *string)
{
  History *h=hist;
  History *o=NULL,*po=NULL;
  int coun;
  //        fprintf(stderr,"[%s]:%s\n",hist_id,string);
  if(string[0]==0)
    return;
  while(h)
  {
    if(strcmp(hist_id,h->id)==0)
      break;
    h=h->neibour;
  }
  if(h==NULL)
  {
    o=new History(hist_id,"     ");
    o->neibour=hist;
    hist=o;
    h=o;
    o=new History(hist_id,string);
    o->prev=NULL;
    o->next=h->next;
    if(o->next)
      o->next->prev=o;
    h->next=o;
  } else
  {
    o=h->next;
    coun=1;
    while(o)
    {
      if(strcmp(string,o->string)==0)
	break;
      po=o;
      o=o->next;
      coun++;
    }
    if(o==NULL)
    {
      if(coun>=HIST_MAX && po && po->prev)
      {
	po->prev->next=NULL;
	delete po;
      }
      o=new History(hist_id,string);
      o->prev=NULL;
      o->next=h->next;
      if(o->next)
	o->next->prev=o;
      h->next=o;
    }
  }

  if(o && o->next==o)
    o->next=NULL;

}

void hist_loadall(char *fname, int progr)
{
  FILE *fp=fopen(fname,"r");
  char buf1[100],buf2[L_MAXPATH],buf[L_MAXPATH],*pbuf=buf2;
  int i,pcoun=9;
  if(fp==NULL)
  {
    if(progr)
      fprintf(stderr,"No history\n");
    return;
  }
  while(fgets(buf,L_MAXPATH-1,fp))
  {
    if(buf[0]=='#')
      continue;
    i=1;
    pbuf=buf2;
    while(buf[i]!=']')
      buf1[i-1]=buf[i++];
    buf1[i-1]=0;
    i+=2;
    while(buf[i]!=0 && buf[i]!='\r' && buf[i]!='\n')
      *pbuf++=buf[i++];
    *pbuf=0;
    hist_addstring(buf1,buf2);
    if(pcoun>=9 && progr)
    {
      fprintf(stderr,".");
      pcoun=0;
    } else pcoun++;
  }
  if(progr)
    fprintf(stderr,"OK\n");
  fclose(fp);
}

void hist_saveall(char *fname)
{
  FILE *fp=fopen(fname,"w");
  History *h=hist,*o;
  if(fp==NULL)
  {
    perror("hist_saveall[fopen]");
    return;
  }
  fprintf(fp,"#LHF - History file.\n");
  fprintf(fp,"#Attention! Do NOT edit this file, it was generated automatically and\n"
	  "#will be overwritten!\n#Thanks.\n");
  while(h)
  {
    o=h->next;
    while(o->next)        //Find out last record
      o=o->next;
    while(o)
    {
      fprintf(fp,"[%s]:%s\n",o->id,o->string);
      o=o->prev;                        //Go in reverse order
    }
    h=h->neibour;
  }
  fclose(fp);
}
