/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * awards_enum.c
 */

#include <gtk/gtk.h>
#include <string.h>

#include "awards_enum.h"

guint cont_to_enum (gchar *str)
{
	if (strlen (str) < 2) return 99;
	switch (str[0])
	{
		case 'N': return CONTINENT_NA;
		case 'E': return CONTINENT_EU;
		case 'S': return CONTINENT_SA;
		case 'O': return CONTINENT_OC;
		case 'A':
		{
			switch (str[1])
			{
				case 'S': return CONTINENT_AS;
				case 'F': return CONTINENT_AF;
			}
		}
	}
	return 99;
}

gchar *enum_to_cont (guint cont)
{
	switch (cont)
	{
		case CONTINENT_NA: return g_strdup("NA");
		case CONTINENT_SA: return g_strdup("SA");
		case CONTINENT_OC: return g_strdup("OC");
		case CONTINENT_AS: return g_strdup("AS");
		case CONTINENT_EU: return g_strdup("EU");
		case CONTINENT_AF: return g_strdup("AF");
	}
	return NULL;
}

guint state_to_enum (gchar *str)
{
	if (strlen (str) < 2) return 99;
	switch (str[0])
	{
		case 'A':
		{
			switch (str[1])
			{
				case 'L': return STATE_AL;
				case 'K': return STATE_AK;
				case 'Z': return STATE_AZ;
			}
		}
		case 'C':
		{
			switch (str[1])
			{
				case 'A': return STATE_CA;
				case 'O': return STATE_CO;
				case 'T': return STATE_CT;
			}
		}
		case 'D':
		{
			return STATE_DE;
		}
		case 'F':
		{
			return STATE_FL;
		}
		case 'G':
		{
			return STATE_GA;
		}
		case 'H':
		{
			return STATE_HI;
		}
		case 'I':
		{
			switch (str[1])
			{
				case 'L': return STATE_IL;
				case 'N': return STATE_IN;
				case 'A': return STATE_IA;
			}
		}
		case 'K':
		{
			switch (str[1])
			{
				case 'S': return STATE_KS;
				case 'Y': return STATE_KY;
			}
		}
		case 'L':
		{
			return STATE_LA;
		}
		case 'M':
		{
			switch (str[1])
			{
				case 'E': return STATE_ME;
				case 'D': return STATE_MD;
				case 'A': return STATE_MA;
				case 'I': return STATE_MI;
				case 'N': return STATE_MN;
				case 'S': return STATE_MS;
				case 'O': return STATE_MO;
				case 'T': return STATE_MT;
			}
		}
		case 'N':
		{
			switch (str[1])
			{
				case 'E': return STATE_NE;
				case 'V': return STATE_NV;
				case 'H': return STATE_NH;
				case 'J': return STATE_NJ;
				case 'M': return STATE_NM;
				case 'Y': return STATE_NY;
				case 'C': return STATE_NC;
				case 'D': return STATE_ND;
			}
		}
		case 'O':
		{
			switch (str[1])
			{
				case 'H': return STATE_OH;
				case 'K': return STATE_OK;
				case 'R': return STATE_OR;
			}
		}
		case 'P':
		{
			return STATE_PA;
		}
		case 'R':
		{
			return STATE_RI;
		}
		case 'S':
		{
			switch (str[1])
			{
				case 'C': return STATE_SC;
				case 'D': return STATE_SD;
			}
		}
		case 'T':
		{
			switch (str[1])
			{
				case 'N': return STATE_TN;
				case 'X': return STATE_TX;
			}
		}
		case 'U':
		{
			return STATE_UT;
		}
		case 'V':
		{
			return STATE_VT;
		}
		case 'W':
		{
			switch (str[1])
			{
				case 'A': return STATE_WA;
				case 'V': return STATE_WV;
				case 'I': return STATE_WI;
				case 'Y': return STATE_WY;
			}
		}
	}
	return 99;
}
