//Menu Creation

#include "menu.h"

//MENU CREATION AND COMMANDS

//launch browser
void launch_browser() {

	char command[156]="exec ";
	strcat(command, bpath);
	xchat_command( ph, command );
	g_free(command);

}

//launch email
void launch_email() {

	char command[156]="exec ";
	strcat(command, epath);
	xchat_command( ph, command );
	g_free(command);

}

//launch media player
void launch_player() {

	char command[156]="exec ";
	strcat(command, ppath);
	xchat_command( ph, command );
	g_free(command);

}

//restore function
void tray_restore() {
	status=1;
	xchat_command( ph, "gui show" );
	select_event_tab(TRUE);
}

//minimize function
void tray_minimize() {
	status=0;
	xchat_command( ph, "gui hide" );
}

//exit from the tray function
void tray_exit() {

	clean_up();
	onExit=0;
	xchat_command( ph, "timer 1 killall" );
}

void select_event_tab(gboolean stop) {

	xchat_set_context(ph, flash_ctx);
	xchat_command( ph, "gui focus" );
	if (stop) flash_stop();
}

#ifndef _WIN32_
//catch mouse clicks on icon
gboolean tray_clicked (GtkWidget *event_box, GdkEventButton *event, gpointer data)
{

	//mouse wheel or middle click + left double click
	if ( (event->button == 1 && event->type == GDK_2BUTTON_PRESS) ||event->button == 2) {
        	if (status == 0) tray_restore();
	        else tray_minimize();
	}

	//single click gives focus only
	if (event->button == 1) select_event_tab(FALSE);

	//mouse right click
	if (event->button == 3) {
		return tray_menu (event_box, event, data);
	}

	return FALSE;
}
#endif

GdkPixbuf* loadmenuicons(char* filename) 
{
	GdkPixbuf* tempbuffer=NULL;
	char temp[200];
	if (filename) 
	{
		if (imagepath) sprintf(temp,"%s/Menu/%s", imagepath ,filename);
		else sprintf(temp,"%s/Menu/%s", xchat_get_info(ph, "xchatdir"),filename);
		tempbuffer= gdk_pixbuf_new_from_file(temp,NULL);
		return tempbuffer;
	}
	else return NULL;

}


//create menu linked with the tray icon
#ifndef _WIN32_
	gboolean tray_menu (GtkWidget *widget, GdkEventButton *event, gpointer data) {
#else
	gboolean tray_menu() {
#endif
	 GtkWidget *menuImage,*item;
	 static GdkPixbuf *buffer1;
	 static GdkPixbuf *buffer2;
	 static GdkPixbuf *buffer3;
	 static GdkPixbuf *buffer4;
	 static GdkPixbuf *buffer5;
	 static GdkPixbuf *buffer6;
	 static GdkPixbuf *buffer7;
	 static GdkPixbuf *buffer8;
	 static GdkPixbuf *buffer9;
	 static GdkPixbuf *buffer10;
	 static GdkPixbuf *stop_flash;

	if (!buffer1 || !buffer2 || !buffer3|| !buffer4|| !buffer5|| !buffer6|| !buffer7|| !buffer8|| !buffer9|| !buffer10|| !stop_flash)
	{
		/* only decode the images once */
		buffer1 = loadmenuicons("settings.png");
		buffer2 = loadmenuicons("browser.png");
		buffer3 = loadmenuicons("player.png");
		buffer4 = loadmenuicons("email.png");
		buffer5 = loadmenuicons("max.png");
		buffer6 = loadmenuicons("min.png");
		buffer7 = loadmenuicons("quit.png");
		buffer8 = loadmenuicons("backaway.png");
		buffer9 = loadmenuicons("goaway.png");
		buffer10 = loadmenuicons("help.png");
		stop_flash = loadmenuicons("stop.png");
	}

	status_menu = gtk_menu_new();

	//help item
	item = gtk_image_menu_item_new_with_label ("Help & Contact");
	menuImage = gtk_image_new_from_pixbuf (buffer10);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (help_page),NULL);

	//break
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	//setting item
	item = gtk_image_menu_item_new_with_label ("SysTray Settings");
	menuImage = gtk_image_new_from_pixbuf (buffer1);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (set_tray),NULL);

	//break
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	//Browser item
	item = gtk_image_menu_item_new_with_label ("Web Browser");
	menuImage = gtk_image_new_from_pixbuf (buffer2);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (launch_browser),NULL);

	//multimedia player item
	item = gtk_image_menu_item_new_with_label ("Multimedia");
	menuImage = gtk_image_new_from_pixbuf (buffer3);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (launch_player),NULL);

	//email item
	item = gtk_image_menu_item_new_with_label ("Email");
	menuImage = gtk_image_new_from_pixbuf (buffer4);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (launch_email),NULL);

	//break
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	//Go Away item
	item = gtk_image_menu_item_new_with_label ("Go Away");
	menuImage = gtk_image_new_from_pixbuf (buffer9);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (select_away),NULL);

	//Back from way
	item = gtk_image_menu_item_new_with_label ("Come Back");
	menuImage = gtk_image_new_from_pixbuf (buffer8);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (back_away),NULL);

	//break
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	//restore item
	item = gtk_image_menu_item_new_with_label ("Restore");
	menuImage = gtk_image_new_from_pixbuf (buffer5);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (tray_restore),NULL);

	//minimize item
	item = gtk_image_menu_item_new_with_label ("Minimize");
	menuImage = gtk_image_new_from_pixbuf (buffer6);
 	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (tray_minimize),NULL);

	//break
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	//stop flashing item
	item = gtk_image_menu_item_new_with_label ("Stop Flashing");
	menuImage = gtk_image_new_from_pixbuf (stop_flash);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (flash_stop),NULL);

	//break
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	//exit item
	item = gtk_image_menu_item_new_with_label ("Exit");
	menuImage = gtk_image_new_from_pixbuf (buffer7);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), menuImage);
	g_signal_connect (G_OBJECT (item), "activate",G_CALLBACK (tray_exit),NULL);


	g_signal_connect (G_OBJECT (status_menu), "selection-done",
			  G_CALLBACK (gtk_widget_destroy), G_OBJECT (status_menu));

	//finalization
	gtk_widget_show_all (status_menu);

#ifndef _WIN32_
	gtk_menu_popup (GTK_MENU(status_menu), NULL, NULL,NULL, NULL,event->button, event->time);
#else
	gtk_menu_popup (GTK_MENU(status_menu), NULL, NULL,NULL, NULL,0,gtk_get_current_event_time());
#endif
	return TRUE;
}

