//////////////////////////////////////////////////////////////////////////////
// Name:        TrigoKbd.cpp
// Purpose:     
// Author:      Alex Thuering
// Created:     2005/09/08
// RCS-ID:      $Id: TrigoKbd.cpp,v 1.6 2007/09/13 06:37:08 etisserant Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "TrigoKbd.h"

#include "calculette.h"
#include <wxSVG/ElementTransform.h>

BEGIN_EVENT_TABLE(TrigoKbd, SVGUIWindow)
  EVT_BUTTON (SVGUIID("boutoncos"), TrigoKbd::OnBoutonCosClick)
  EVT_BUTTON (SVGUIID("boutonsin"), TrigoKbd::OnBoutonSinClick)
  EVT_BUTTON (SVGUIID("boutontan"), TrigoKbd::OnBoutonTanClick)
  EVT_BUTTON (SVGUIID("boutonplus"), TrigoKbd::OnBoutonPlusClick)
  EVT_BUTTON (SVGUIID("boutonmoins"), TrigoKbd::OnBoutonMoinsClick)
  EVT_COMMAND_SCROLL_THUMBTRACK(SVGUIID("cercle_trigo"), TrigoKbd::OnCercleTrigoChanged)
END_EVENT_TABLE()

const double pi = 3.1415926;

TrigoKbd::TrigoKbd(wxWindow* parent):
 SVGUIWindow(parent)
{
	LoadFiles(wxT("TrigoKbd.svg"),wxT("TrigoKbd.def"));
	RefreshTrigoValues();
	SetFitToFrame(true);
	RefreshScale();
	Update();
}

void TrigoKbd::RefreshTrigoValues()
{
	double angle = 0;
	SVGUIRotatingCtrl* rotatingctrl = (SVGUIRotatingCtrl*)GetElementById(wxT("cercle_trigo"));
	if (rotatingctrl)
		angle = rotatingctrl->GetAngle();
	SVGUITextCtrl* costext = (SVGUITextCtrl*)GetElementById(wxT("costext"));
	if (costext)
		costext->SetValue(wxString::Format(wxT("%.2f"), cos(angle*pi/180.0)));
	SVGUITextCtrl* sintext = (SVGUITextCtrl*)GetElementById(wxT("sintext"));
	if (sintext)
		sintext->SetValue(wxString::Format(wxT("%.2f"), sin(angle*pi/180.0)));
	SVGUITextCtrl* tantext = (SVGUITextCtrl*)GetElementById(wxT("tantext"));
	if (tantext)
		tantext->SetValue(wxString::Format(wxT("%.2f"), tan(angle*pi/180.0)));
	SVGUITextCtrl* angletext = (SVGUITextCtrl*)GetElementById(wxT("angletext"));
	if (angletext)
		angletext->SetValue(wxString::Format(wxT("%.2f"), angle));
}

void TrigoKbd::OnBoutonCosClick(wxCommandEvent& event)
{
	SVGUITextCtrl* costext = (SVGUITextCtrl*)GetElementById(wxT("costext"));
	if (costext)
	{
		wxString value = costext->GetValue();
		((Calculette*)wxWindow::GetParent())->SetNombreValue(value);
	}
}

void TrigoKbd::OnBoutonSinClick(wxCommandEvent& event)
{
	SVGUITextCtrl* sintext = (SVGUITextCtrl*)GetElementById(wxT("sintext"));
	if (sintext)
	{
		wxString value = sintext->GetValue();
		((Calculette*)wxWindow::GetParent())->SetNombreValue(value);
	}
}

void TrigoKbd::OnBoutonTanClick(wxCommandEvent& event)
{
	SVGUITextCtrl* tantext = (SVGUITextCtrl*)GetElementById(wxT("tantext"));
	if (tantext)
	{
		wxString value = tantext->GetValue();
		((Calculette*)wxWindow::GetParent())->SetNombreValue(value);
	}
}

void TrigoKbd::OnBoutonPlusClick(wxCommandEvent& event)
{
	SVGUIRotatingCtrl* rotatingctrl = (SVGUIRotatingCtrl*)GetElementById(wxT("cercle_trigo"));
	if (rotatingctrl)
		rotatingctrl->Rotate(10);
	RefreshTrigoValues();
}

void TrigoKbd::OnBoutonMoinsClick(wxCommandEvent& event)
{
	SVGUIRotatingCtrl* rotatingctrl = (SVGUIRotatingCtrl*)GetElementById(wxT("cercle_trigo"));
	if (rotatingctrl)
		rotatingctrl->Rotate(-10);
	RefreshTrigoValues();
}

void TrigoKbd::OnCercleTrigoChanged(wxScrollEvent& event)
{
	RefreshTrigoValues();
}
