from xmlclass import *
#from DEFController import *
import os, sys
import wx
from wxPython.wx import *
from wxPython.grid import *


DEFClasses, DEFTypes = GenerateClassesFromXSD(os.path.join(os.path.dirname(__file__), "def_xsd.xsd"))

if "Container" in DEFClasses:
    cls = DEFClasses["Container"]
    

    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "children" : self.GetChildren(),
                   "type": "Container"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)
    
    
    
    def GetChildren(self):
        content = self.getContent()
        children = []
        for child in content:
            children.append(child["value"].GetElementInfos())
        return children
    setattr(cls, "GetChildren", GetChildren)
    
    
    
    def GetContainerObj(self):
        infos = {"name":"Container",
                 "id": self.getId(), 
                 "background_id":self.getBackground_id(), 
                 "type": "Container"}
        infos["values"] = []
        
        children = self.getContent()
        for child in children:
            child_infos = child["value"]
            infos["values"].append(child_infos)
                
        return infos
    setattr(cls, "GetContainerObj", GetContainerObj)
    
    
    
    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        return True
        
    setattr(cls, "SetAttrValue", SetAttrValue)
    
    
    def AddElement(self,attr,name,id):
        new_cls = DEFClasses[attr]()
        new_cls.setName(name)
        new_cls.setId(id)
        self.appendContent(attr,new_cls)
    setattr(cls, "AddElement", AddElement)
    
    def PasteElement(self,cut_cls):
        self.appendContent("",cut_cls)
    setattr(cls, "PasteElement", PasteElement)
    
    def SetRootAttributes(self):
        self.setName("root")
        self.setId(1)
    setattr(cls, "SetRootAttributes", SetRootAttributes)
        
        
    
#---------------------------------------------
    
    
if "Button" in DEFClasses:
    cls = DEFClasses["Button"]
    
    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "type": "Button"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)

    
    
    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        elif attr == "selected_id":
            self.setSelected_id(value)
        elif attr == "unselected_id":
            self.setUnselected_id(value)
        return True
        
    setattr(cls, "SetAttrValue", SetAttrValue)
    
#--------------------------------------------
    
    
if "TextCtrl" in DEFClasses:
    cls = DEFClasses["TextCtrl"]
    
    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "type": "TextCtrl"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)

    
    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        elif attr == "show_background":
            if value == "True":
                self.setShow_background(True)
            elif value == "False":
                self.setShow_background(False)
        elif attr == "text_id":
            self.setText_id(value)
        elif attr == "cursor_id":
            self.setCursor_id(value)
        elif attr == "align":
            if self.getAlign() == None:
                self.addAlign()            
            self.getAlign().setValue(value)
        return True
        
    setattr(cls, "SetAttrValue", SetAttrValue)
    
#----------------------------------------------
    
    
if "ScrollBar" in DEFClasses:
    cls = DEFClasses["ScrollBar"]
    
    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "type": "ScrollBar"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)

    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        elif attr == "show_background":
            self.setShow_background(value)
        elif attr == "uparrow_id":
            self.setUparrow_id(value)
        elif attr == "downarrow_id":
            self.setDownarrow_id(value)
        elif attr == "thumb_middle_id":
            self.setThumb_middle_id(value)
        elif attr == "thumb_back_id":
            self.setThumb_back_id(value)
        elif attr == "orientation":
            self.getOrientation().setValue(value)
        return True
            
    setattr(cls, "SetAttrValue", SetAttrValue)
    

#---------------------------------------------

if "NoteBook" in DEFClasses:
    cls = DEFClasses["NoteBook"]
    
    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "type": "NoteBook"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)

    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        elif attr == "content_id":
            self.setContent_id(value)
        elif attr == "page0_id":
            self.setPage0_id(value)
        elif attr == "page0_content":
            self.setPage0_content(value)
        elif attr == "page1_id":
            self.setPage1_id(value)
        elif attr == "page1_content":
            self.setPage1_content(value)
        return True
    setattr(cls, "SetAttrValue", SetAttrValue)
    
    
    
#---------------------------------------------


if "RotatingCtrl" in DEFClasses:
    cls = DEFClasses["RotatingCtrl"]
    
    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "type": "RotatingCtrl"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)
    
    
    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        elif attr == "rotating_id":
            self.setRotating_id(value)
        elif attr == "x_center":
            if value == "":
                self.setX_center("-1")
            else:
                self.setX_center(value)
        elif attr == "y_center":
            if value == "":
                self.setY_center("-1")
            else:
                self.setY_center(value)
        elif attr == "min_angle":
            if value == "":
                self.setMin_angle("0")
            else:
                self.setMin_angle(value)
        elif attr == "max_angle":
            if value == "":
                self.setMax_angle("360")
            else:
                self.setMax_angle(value)
        return True
        
    setattr(cls, "SetAttrValue", SetAttrValue)
    
#----------------------------------------------

if "Transform" in DEFClasses:
    cls = DEFClasses["Transform"]
    
    def GetElementInfos(self):
        infos =  { "id": self.getId(),
                   "attr" : self.getElementAttributes(),
                   "type": "Transform"}
        return infos
    setattr(cls, "GetElementInfos", GetElementInfos)

    
    
    def SetAttrValue(self,attr,value,require_value):
        if (require_value == True) and value == "":
            return False
        
        if attr == "id":
            self.setId(value)
        elif attr == "name":
            self.setName(value)
        elif attr == "background_id":
            self.setBackground_id(value)
        elif attr == "moving_id":
            self.setSelected_id(value)
        return True
        
    setattr(cls, "SetAttrValue", SetAttrValue)
    
#----------------------------------------------
    