target=plain abs count digit1 digit2 minmaxconst distconst sign gcd1 gcd2 gcd3

#include "header.inc"
#include "confparm.inc"
\text{outtype=int}	% int, double, unsigned int
\text{printftype=%d}	% corresponding to outtype
\text{inttype=all}	% generated integer: all or pos
\text{zeros=yes}	% include zeros in list
\integer{limit=20}	% integer size limit: power of 2
\integer{sizelim1=3}	% smallest list
\integer{sizelim2=1000}	% biggest list
\text{size=10x70}	% textarea size
			% sizes of testing lists
\integer{decal=randint(0..4)}
\text{ns=wims(values x for x in 
	 3,5+\decal,6+\decal,7+\decal,8+\decal,9+\decal,10+\decal,
	 randint(10..20),randint(20..50),randint(50..100),
	 randint(100..200),randint(700..1000))}
\integer{ncnt=items(\ns)}

#if #TARGET (plain)
 \title{. Simple sum}
 \text{wt=sum}
 \text{formula=x}
 \text{summand=the sum of <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (abs)
 \title{Sum of absolute values}
 \text{wt=sum}
 \text{formula=abs(x)}
 \text{summand=the sum randitem(
	of the absolute values of <tt>\ll[][\ii]</tt>,
	of <tt>|\ll[][\ii]|</tt>,
	of the absolute values <tt>|\ll[][\ii]|</tt>
 )}
#endif

#if #TARGET (count)
 \title{. Simple count}
 \text{wt=count}
 \text{formula=1}
 \text{summand=the number of items <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (digit1)
 \title{Sum of last digit}
 \text{wt=sum}
 \text{formula=abs(x)%10}
 \text{summand=the sum of the last digit of <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (digit2)
 \title{Sum of a digit}
 \text{wt=sum}
 \integer{place=random(1,2,3)}
 \text{Place=item(\place,tens, hundreds, thousands)}
 \integer{div=item(\place,10,100,1000)}
 \text{formula=floor(abs(x)/\div)%10}
 \text{summand=the sum of the digits of \Place of <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (minmaxconst)
 \title{Sum min-max with a constant}
 \integer{const=random(-10000..10000)}
 \text{wt=sum}
 \text{minmax=random(min,max)}
 \text{formula=\minmax(x,\const)}
\text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=the sum of <tt>\minmax(\ind)</tt>}
#endif

#if #TARGET (distconst)
 \title{Sum of distances with a constant}
 \integer{const=random(-1000..1000)}
 \text{wt=sum}
 \text{formula=abs(x-(\const))}
 \text{ind=random(1,2)=1?\const and <tt>\ll[][\ii]</tt>:<tt>\ll[][\ii]</tt> and \const}
 \text{summand=the sum of the distance between \ind}
 \text{hint=<b>ATTENTION</b> The distance between two numbers is never negative!}
#endif

#if #TARGET (sign)
 \title{Sum of signs}
 \text{wt=sum}
 \text{formula=sign(x)}
 \text{summand=the sum of the signs of <tt>\ll[][\ii]</tt>}
 \text{hint=The sign of a number x is equal to 1 if x is positive, to -1 if x is
       negative, and to 0 if x=0}
#endif

#if #TARGET (gcd1)
 \title{Sum of gcd I}
 \text{inttype=pos}
 \text{adj=positive}
 \text{zeros=no}
 \text{wt=sum}
 \text{primes=2,3,5,7,11,13,17,19,23,29,31,37,41,43,47}
 \text{const=randitem(\primes)}
 \text{formula=gcd(x,\const)}
 \text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=the sum of <tt>gcd(\ind)</tt>}
#endif

#if #TARGET (gcd2)
 \title{Sum of gcd II}
 \text{inttype=pos}
 \text{adj=positive}
 \text{zeros=no}
 \text{wt=sum}
 \text{primes=2,3,5,7,11,13,17,19,23,29,31,37,41,43,47}
 \text{p1=randitem(\primes)}
 \text{p2=randitem(\primes)}
 \integer{const=\p1*\p2}
 \text{formula=gcd(x,\const)}
 \text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=the sum of <tt>gcd(\ind)</tt>}
#endif

#if #TARGET (gcd3)
 \title{Sum of gcd III}
 \text{inttype=pos}
 \text{adj=positive}
 \text{zeros=no}
 \text{wt=sum}
 \text{primes=2,3,5,7,11,13,17,19,23,29,31,37,41,43,47}
 \text{p1=randitem(\primes)}
 \text{p2=randitem(\primes)}
 \text{p3=randitem(\primes)}
 \integer{const=\p1*\p2*\p3}
 \text{formula=gcd(x,\const)}
 \text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=the sum of <tt>gcd(\ind)</tt>}
#endif

\text{sum=}
\text{listsc=}
\for{n in \ns}{
 #include "list.inc"
 \text{listsc=wims(append item { \list } to \listsc)}
 \text{slib=slib(\selmeth \n,\wt,\formula,\list)}
 \text{condition=wims(line 2 of \slib)}
 \text{sum=\sum wims(line 3 of \slib)}
}

#include "src.inc"
#include "main.inc"

