// This may look like C code, but it is really -*- C++ -*-
// <copyright> 
//  
//  Copyright (c) 1993 
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 

// <file> 
// 
// Name:        assert.h
// 
// Purpose:     assertions
// 
// Created:     30 Nov 93   Joerg Faschingbauer
// 
// Modified:    10 Jan 94   Michael Pichler 
// 
// Description: if ASSERT is defined, hgassert(expr, msg) checks whether
//              expr is true (non null); if not message msg and file name
//              and line no are written to stderr, and abort() is called;
//              if ASSERT is not defined, expr is not evaluated
// 
// </file> 


#ifndef hg_hyperg_assert_h
#define hg_hyperg_assert_h


#ifdef ASSERT

#include <iostream.h>
#include <stdlib.h>

#include "hgunistd.h"

#define hgassert(expr, msg)  \
{ if (!(expr))  \
  { cerr << "Hyper-G assertion failed: " << msg << "; file: " << __FILE__ << "; line: " << __LINE__ << endl;  \
    abort();  \
    pause();  \
  }  \
}

#else

#define hgassert(expr, msg)

#endif



#endif
