//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        language.C
//
// Purpose:     implementation of class HgLanguage
//
// Created:     12 Jan 94    Michael Pichler
//
// Modified:    16 Mar 94    Michael Pichler
//
// $Id: language.C,v 1.11 1996/11/28 09:14:02 jschipf Exp $
//
//</file>


#include "language.h"

#include <string.h>
#ifdef AIX
#  include <strings.h>
#endif
#ifdef WIN32
#  include <strings.h>
#endif

#if (defined(AIX) && HG_OSMaj == 3) || defined(UnixWare) || (defined(SCO) && HG_OSMaj ==3)
/* for architectures do not have strcasecmp */
#include <ctype.h>
int strcasecmp (const char* str1, const char* str2)
{
  int diff;  // compare until finding difference or both strings finished

  while ((diff = tolower (*str1) - tolower (*str2)) == 0)
  {
    if (!*str1 && !*str2)
      return 0;  // equal
    str1++;
    str2++;
  }

  return diff;
}
#endif



// static members

const char* HgLanguage::langstr_ [HgLanguage::NumLanguages] =  // language strings
{
  "en", // English
  "ge", // German
  "st", // Styrian
  "fr", // French
  "it", // Italian
  "sp", // Spanish
  "kr", // Korean
  "jp", // Japanese
  "hu"  // Hungarian
};


// string table for translateLanguage

static const char* langstrings [HgLanguage::NumLanguages][HgLanguage::NumLanguages] =
{
  {"English",  "Englisch",   "Englisch",     "Anglais", "Inglese",   "Ingls",   "", "p", "Angol"},
  {"German",   "Deutsch",    "Deitsch",      "Allemand","Tedesco",   "Alemn",   "", "޲", "Nmet"},
  {"Styrian",  "Steirisch",  "Stoasteirisch","Styrie",  "Stiriano",  "Styresco", "Ƽƾ", "ر޲", "Stjer"},
  {"French",   "Franzsisch","Franzesisch",  "Francais","Francese",  "Francs",  "Ҿ", "ݽ", "Francia"},
  {"Italian",  "Italienisch","Italienisch",  "Italie",  "Italiano",  "Italiano", "Żƾ", "ر", "Olasz"},
  {"Spanish",  "Spanisch",   "Schpanisch",   "Espagne", "Spagnolo",  "Espaol",  "ξ", "߲݌", "Spanyol"},
  {"Korean",   "Koreanisch", "Koreanisch",   "Coren",  "Korean",    "Korean",   "ѱ", "؍", "Korean"},
  {"Japanese", "Japanisch",  "Japanisch",    "Japonais","Giapponese", "Japons",  "Ϻ", "{", "Japanese"},
  {"Hungarian","Ungarisch",  "Ungarisch",    "Hongrois","Hungarian", "Hungarian","밡ƾ", "Hungarian", "Magyar"}
};



HgLanguage::Language HgLanguage::getLanguage(  // translate language string to enum
  const char* str,                             //   language string
  Language def                                 //   default return value (if wrong string)
)
{
  if (!str)  // nil pointer
    return def;

  // ok, if (str [2] == '\0' || str [2] == ':') ... "xx" (null-terminated) or "xx:"
  if (str [2] && str [2] != ':')  // "syntax error"
    return def;

  for (unsigned i = 0;  i < NumLanguages;  i++)
  {
    const char* lgstr = langstr_ [i];

    if (*str == *lgstr && str [1] == lgstr [1])
      return (Language) i;
  }

  return def;
}



HgLanguage::Language HgLanguage::nameToEnum(   // convert language name to enum
  const char* str,                             //   language name in english
  Language def                                 //   default return value (if wrong string)
)
{
  if (!str)  // nil pointer
    return def;

  for (unsigned i = 0;  i < NumLanguages;  i++)
  {
    if (!strcasecmp (str, langstrings [i][English]))
      return (Language) i;
  }

  return def;
}



const char* HgLanguage::translateLanguage(     // get a language name in any language
  Language langname,                           //   language name to be translated
  Language langdest                            //   destination language
)                                              // e.g.: translateLanguage(Styrian,German)="Steirisch"
{
  if ((unsigned) langname < NumLanguages && (unsigned) langdest < NumLanguages)
    return (langstrings [langname][langdest]);
  else
    return 0;  // range error
}
