// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        fieldfilter.C
// 
// Purpose:     
// 
// Created:     26 Sep 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: fieldfilter.C,v 1.2 1996/10/30 10:08:22 jfasch Exp $
// 
// $Log: fieldfilter.C,v $
// Revision 1.2  1996/10/30 10:08:22  jfasch
// mainly debug output
//
// Revision 1.1  1996/10/15 15:45:43  jfasch
// verbose and assert movings
//
// 
// </file> 
#include "fieldfilter.h"

#include <hyperg/utils/strfield.h>

#include <strstream.h>
#include <ctype.h>

// --------------------------------------------------------------------
const char* FieldFilter :: version1 = "$Id: fieldfilter.C,v 1.2 1996/10/30 10:08:22 jfasch Exp $" ;

// --------------------------------------------------------------------
Fieldsimplement (FieldFilterListBase, FieldFilterPtr) ;

Verbose FieldFilterList :: verbose ;

bool FieldFilterList :: doIt (const RString& in, RString& out) {
   if (! count()) {
      // null filter
      DEBUGNL ("FieldFilterList::doIt(): no filters") ;
      out = in ;
   }
   else 
      for (int i=0 ; i<count() ; i++) {
         if (operator[](i)) {
            DEBUGNL ("FieldFilterList::doIt(): "
                     "filter #"<<i<<" is a "<<operator[](i).ptr()->description()) ;
            if (!operator[](i).ptr()->doIt (in, out)) {
               DEBUGNL ("FieldFilterList::doIt(): filter #"<<i<<" failed") ;
               return false ;
            }
         }
         else {
            DEBUGNL ("FieldFilterList::doIt(): filter #"<<i<<" is null") ;
         }
      }

   return true ;
}

// --------------------------------------------------------------------
bool SGMLToISOFilter :: doIt (const RString& in, RString& out) {
   out = in ;
   out.sgml2Iso() ;
   return true ;
}

// --------------------------------------------------------------------
bool ASCIILowerFilter :: doIt (const RString& in, RString& out) {
   RStringField strings ;
   int idx = 0 ;
   static const RString white (" \t\n") ;
   RString word ;
   while (in.gWord (idx, white, word)) {
      int i ;
      for (i=0 ; i<word.length() && isascii(word[i]) ; i++) ;
      if (i == word.length())
         word.toLower() ;
      strings.append (word) ;
   }
   ostrstream os ;
   if (strings.count()) {
      os << strings[0].string() ;
      for (int i=1 ; i<strings.count() ; i++)
         os << ' ' << strings[i].string() ;
      os << ends ;
   }
   int cnt = os.pcount() ;
   char* s = os.str() ;
   out = RString (s, cnt) ;
   delete s ;
   return true ;
}

// --------------------------------------------------------------------
bool SGMLISOToLowerASCIIFilter :: doIt (const RString& in, RString& out) {
   out = in ;
   out.sgmlIso2LowerAscii() ;
   return true ;
}

