/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.render.Renderer;

public class Page {
    private int height;
    private int width;
    private BodyAreaContainer body;
    private AreaContainer before;
    private AreaContainer after;
    private AreaContainer start;
    private AreaContainer end;
    private AreaTree areaTree;
    protected int pageNumber = 0;
    protected Vector linkSets = new Vector();
    private Vector idList = new Vector();
    private Vector footnotes = null;

    Page(AreaTree areaTree, int n, int n2) {
        this.areaTree = areaTree;
        this.height = n;
        this.width = n2;
    }

    void addAfter(AreaContainer areaContainer) {
        this.after = areaContainer;
        areaContainer.setPage(this);
    }

    void addBefore(AreaContainer areaContainer) {
        this.before = areaContainer;
        areaContainer.setPage(this);
    }

    public void addBody(BodyAreaContainer bodyAreaContainer) {
        this.body = bodyAreaContainer;
        bodyAreaContainer.setPage(this);
        bodyAreaContainer.getMainReferenceArea().setPage(this);
        bodyAreaContainer.getBeforeFloatReferenceArea().setPage(this);
        bodyAreaContainer.getFootnoteReferenceArea().setPage(this);
    }

    void addEnd(AreaContainer areaContainer) {
        this.end = areaContainer;
        areaContainer.setPage(this);
    }

    public void addLinkSet(LinkSet linkSet) {
        this.linkSets.addElement(linkSet);
    }

    public void addPendingFootnote(FootnoteBody footnoteBody) {
        if (this.footnotes == null) {
            this.footnotes = new Vector();
        }
        this.footnotes.addElement(footnoteBody);
    }

    void addStart(AreaContainer areaContainer) {
        this.start = areaContainer;
        areaContainer.setPage(this);
    }

    public void addToIDList(String string) {
        this.idList.addElement(string);
    }

    public AreaContainer getAfter() {
        return this.after;
    }

    public AreaContainer getBefore() {
        return this.before;
    }

    public BodyAreaContainer getBody() {
        return this.body;
    }

    public FontInfo getFontInfo() {
        return this.areaTree.getFontInfo();
    }

    public int getHeight() {
        return this.height;
    }

    public Vector getIDList() {
        return this.idList;
    }

    public Vector getLinkSets() {
        return this.linkSets;
    }

    public int getNumber() {
        return this.pageNumber;
    }

    public Vector getPendingFootnotes() {
        return this.footnotes;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean hasLinks() {
        return this.linkSets.isEmpty() ^ true;
    }

    public void render(Renderer renderer) {
        renderer.renderPage(this);
    }

    public void setNumber(int n) {
        this.pageNumber = n;
    }

    public void setPendingFootnotes(Vector vector) {
        this.footnotes = vector;
        if (this.footnotes != null) {
            Enumeration enumeration = this.footnotes.elements();
            while (enumeration.hasMoreElements()) {
                FootnoteBody footnoteBody = (FootnoteBody)enumeration.nextElement();
                Footnote.layoutFootnote(this, footnoteBody, null);
            }
            this.footnotes = null;
        }
    }
}

