/*
  Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
  All rights reserved.

  Redistribution and use in source and binary forms,
  with or without modification, are permitted provided that the
  following conditions are met:
   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the Sony Computer Entertainment Inc nor the names
     of its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#define _VECTORMATH_AOS_TEST

#include "vectormath_aos.h"
#include "test.h"

int iteration = 0;

void
Matrix3_methods_test()
{
    VmathMatrix3 a_Matrix3, b_Matrix3;
    VmathMatrix4 a_Matrix4, b_Matrix4;
    VmathTransform3 a_Transform3, b_Transform3;
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3, tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7;
    VmathQuat tmpQ_0;
    VmathVector3 tmpV3_8, tmpV3_9, tmpV3_10, tmpV3_11, tmpV3_12, tmpV3_13, tmpV3_14, tmpV3_15, tmpV3_16, tmpV3_17, tmpV3_18, tmpV3_19, tmpV3_20, tmpV3_21;
    float rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &c_Vector3, pad );
    vmathV4GetXYZ( &c_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &d_Vector3, pad );
    vmathV4GetXYZ( &d_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &c_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &c_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathV3MakeFromP3( &tmpV3_4, &c_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_4, pad );
    vmathV4GetXYZ( &tmpV3_5, &tmpV4 );
    vmathP3MakeFromV3( &c_Point3, &tmpV3_5 );
    vmathV3MakeFromP3( &tmpV3_6, &d_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_6, pad );
    vmathV4GetXYZ( &tmpV3_7, &tmpV4 );
    vmathP3MakeFromV3( &d_Point3, &tmpV3_7 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3Prints( &c_Point3, "set Point3 with floats" );
    vmathP3Prints( &d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQPrints( &c_Quat, "set Quat with floats" );
    vmathQPrints( &d_Quat, "set Quat with floats" );
    vmathM3MakeFromCols( &a_Matrix3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathM3MakeFromCols( &b_Matrix3, &d_Vector3, &a_Vector3, &b_Vector3 );
    vmathM3Prints( &a_Matrix3, "set Matrix3 columns" );
    vmathM3Prints( &b_Matrix3, "set Matrix3 columns" );
    vmathM4MakeFromCols( &a_Matrix4, &a_Vector4, &b_Vector4, &c_Vector4, &d_Vector4 );
    vmathM4MakeFromCols( &b_Matrix4, &d_Vector4, &a_Vector4, &b_Vector4, &c_Vector4 );
    vmathM4Prints( &a_Matrix4, "set Matrix4 columns" );
    vmathM4Prints( &b_Matrix4, "set Matrix4 columns" );
    vmathT3MakeFromCols( &a_Transform3, &a_Vector3, &b_Vector3, &c_Vector3, &d_Vector3 );
    vmathT3MakeFromCols( &b_Transform3, &d_Vector3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathT3Prints( &a_Transform3, "set Transform3 columns" );
    vmathT3Prints( &b_Transform3, "set Transform3 columns" );
    vmathQNormalize( &tmpQ_0, &a_Quat );
    vmathM3MakeFromQ( &a_Matrix3, &tmpQ_0 );
    vmathM3Prints( &a_Matrix3, "construct Matrix3 with Quat" );
    vmathQMakeFromM3( &a_Quat, &a_Matrix3 );
    vmathQPrints( &a_Quat, "construct Quat with Matrix3" );
    vmathM3Copy( &a_Matrix3, &b_Matrix3 );
    vmathM3Prints( &a_Matrix3, "assign to Matrix3 from Matrix3" );
    vmathM3MakeFromScalar( &a_Matrix3, randfloat() );
    vmathM3Prints( &a_Matrix3, "set Matrix3 with float" );
    vmathM3MakeFromScalar( &a_Matrix3, randfloat() );
    vmathM3Prints( &a_Matrix3, "set Matrix3 with float" );
    vmathM3MakeFromScalar( &a_Matrix3, 0.0f );
    vmathM3Prints( &a_Matrix3, "set elements to zero" );
    vmathM3MakeIdentity( &a_Matrix3 );
    vmathM3Prints( &a_Matrix3, "set to identity" );
    vmathM3MakeRotationX( &a_Matrix3, randfloat() );
    vmathM3Prints( &a_Matrix3, "set to rotationX" );
    vmathM3MakeRotationY( &a_Matrix3, randfloat() );
    vmathM3Prints( &a_Matrix3, "set to rotationY" );
    vmathM3MakeRotationZ( &a_Matrix3, randfloat() );
    vmathM3Prints( &a_Matrix3, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &tmpV3_8, rndflt3, rndflt2, rndflt1 );
    vmathM3MakeRotationZYX( &a_Matrix3, &tmpV3_8 );
    vmathM3Prints( &a_Matrix3, "set to rotation from Z,Y,X angles" );
    vmathV3Normalize( &tmpV3_9, &a_Vector3 );
    vmathM3MakeRotationAxis( &a_Matrix3, randfloat(), &tmpV3_9 );
    vmathM3Prints( &a_Matrix3, "set to rotation from axis angle" );
    vmathM3SetCol0( &a_Matrix3, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set col 0" );
    vmathM3SetCol1( &a_Matrix3, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set col 1" );
    vmathM3SetCol2( &a_Matrix3, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set col 2" );
    vmathM3GetCol0( &tmpV3_10, &a_Matrix3 );
    vmathV3Prints( &tmpV3_10, "Matrix3 get col 0" );
    vmathM3GetCol1( &tmpV3_11, &a_Matrix3 );
    vmathV3Prints( &tmpV3_11, "Matrix3 get col 1" );
    vmathM3GetCol2( &tmpV3_12, &a_Matrix3 );
    vmathV3Prints( &tmpV3_12, "Matrix3 get col 2" );
    vmathM3SetCol( &a_Matrix3, 0, &b_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set col 0" );
    vmathM3SetCol( &a_Matrix3, 1, &b_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set col 1" );
    vmathM3SetCol( &a_Matrix3, 2, &b_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set col 2" );
    vmathM3GetCol( &tmpV3_13, &a_Matrix3, 0 );
    vmathV3Prints( &tmpV3_13, "Matrix3 get col 0" );
    vmathM3GetCol( &tmpV3_14, &a_Matrix3, 1 );
    vmathV3Prints( &tmpV3_14, "Matrix3 get col 1" );
    vmathM3GetCol( &tmpV3_15, &a_Matrix3, 2 );
    vmathV3Prints( &tmpV3_15, "Matrix3 get col 2" );
    vmathM3SetRow( &a_Matrix3, 0, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set row 0" );
    vmathM3SetRow( &a_Matrix3, 1, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set row 1" );
    vmathM3SetRow( &a_Matrix3, 2, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "Matrix3 set row 2" );
    vmathM3GetRow( &tmpV3_16, &a_Matrix3, 0 );
    vmathV3Prints( &tmpV3_16, "Matrix3 get row 0" );
    vmathM3GetRow( &tmpV3_17, &a_Matrix3, 1 );
    vmathV3Prints( &tmpV3_17, "Matrix3 get row 1" );
    vmathM3GetRow( &tmpV3_18, &a_Matrix3, 2 );
    vmathV3Prints( &tmpV3_18, "Matrix3 get row 2" );
    vmathM3SetCol( &a_Matrix3, 0, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "set " );
    vmathM3SetCol( &a_Matrix3, 1, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "set " );
    vmathM3SetCol( &a_Matrix3, 2, &a_Vector3 );
    vmathM3Prints( &a_Matrix3, "set " );
    vmathM3GetCol( &tmpV3_19, &a_Matrix3, 0 );
    vmathV3Prints( &tmpV3_19, "get " );
    vmathM3GetCol( &tmpV3_20, &a_Matrix3, 1 );
    vmathV3Prints( &tmpV3_20, "get " );
    vmathM3GetCol( &tmpV3_21, &a_Matrix3, 2 );
    vmathV3Prints( &tmpV3_21, "get " );
    vmathM3SetElem( &a_Matrix3, 0, 0, randfloat() );
    vmathM3SetElem( &a_Matrix3, 0, 1, randfloat() );
    vmathM3SetElem( &a_Matrix3, 0, 2, randfloat() );
    vmathM3SetElem( &a_Matrix3, 1, 0, randfloat() );
    vmathM3SetElem( &a_Matrix3, 1, 1, randfloat() );
    vmathM3SetElem( &a_Matrix3, 1, 2, randfloat() );
    vmathM3SetElem( &a_Matrix3, 2, 0, randfloat() );
    vmathM3SetElem( &a_Matrix3, 2, 1, randfloat() );
    vmathM3SetElem( &a_Matrix3, 2, 2, randfloat() );
    vmathM3Prints( &a_Matrix3, "Matrix3 set elements" );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 0, 0 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 0, 1 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 0, 2 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 1, 0 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 1, 1 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 1, 2 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 2, 0 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 2, 1 )) );
    printf("%f\n", getfloat(vmathM3GetElem( &a_Matrix3, 2, 2 )) );
}

void
Matrix4_methods_test()
{
    VmathMatrix3 a_Matrix3, b_Matrix3;
    VmathMatrix4 a_Matrix4, b_Matrix4;
    VmathTransform3 a_Transform3, b_Transform3;
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3, tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7, tmpV3_8, tmpV3_9;
    VmathVector4 tmpV4_0, tmpV4_1, tmpV4_2, tmpV4_3, tmpV4_4, tmpV4_5, tmpV4_6, tmpV4_7, tmpV4_8, tmpV4_9, tmpV4_10, tmpV4_11, tmpV4_12, tmpV4_13, tmpV4_14, tmpV4_15;
    float rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &c_Vector3, pad );
    vmathV4GetXYZ( &c_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &d_Vector3, pad );
    vmathV4GetXYZ( &d_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &c_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &c_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathV3MakeFromP3( &tmpV3_4, &c_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_4, pad );
    vmathV4GetXYZ( &tmpV3_5, &tmpV4 );
    vmathP3MakeFromV3( &c_Point3, &tmpV3_5 );
    vmathV3MakeFromP3( &tmpV3_6, &d_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_6, pad );
    vmathV4GetXYZ( &tmpV3_7, &tmpV4 );
    vmathP3MakeFromV3( &d_Point3, &tmpV3_7 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3Prints( &c_Point3, "set Point3 with floats" );
    vmathP3Prints( &d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQPrints( &c_Quat, "set Quat with floats" );
    vmathQPrints( &d_Quat, "set Quat with floats" );
    vmathM3MakeFromCols( &a_Matrix3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathM3MakeFromCols( &b_Matrix3, &d_Vector3, &a_Vector3, &b_Vector3 );
    vmathM3Prints( &a_Matrix3, "set Matrix3 columns" );
    vmathM3Prints( &b_Matrix3, "set Matrix3 columns" );
    vmathM4MakeFromCols( &a_Matrix4, &a_Vector4, &b_Vector4, &c_Vector4, &d_Vector4 );
    vmathM4MakeFromCols( &b_Matrix4, &d_Vector4, &a_Vector4, &b_Vector4, &c_Vector4 );
    vmathM4Prints( &a_Matrix4, "set Matrix4 columns" );
    vmathM4Prints( &b_Matrix4, "set Matrix4 columns" );
    vmathT3MakeFromCols( &a_Transform3, &a_Vector3, &b_Vector3, &c_Vector3, &d_Vector3 );
    vmathT3MakeFromCols( &b_Transform3, &d_Vector3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathT3Prints( &a_Transform3, "set Transform3 columns" );
    vmathT3Prints( &b_Transform3, "set Transform3 columns" );
    vmathM4MakeFromT3( &a_Matrix4, &a_Transform3 );
    vmathM4Prints( &a_Matrix4, "construct Matrix4 with Transform3" );
    vmathM4MakeFromM3V3( &a_Matrix4, &a_Matrix3, &a_Vector3 );
    vmathM4Prints( &a_Matrix4, "construct Matrix4 with Matrix3 and Vector3" );
    vmathM4MakeFromQV3( &a_Matrix4, &a_Quat, &a_Vector3 );
    vmathM4Prints( &a_Matrix4, "construct Matrix4 with Quat and Vector3" );
    vmathM4Copy( &a_Matrix4, &b_Matrix4 );
    vmathM4Prints( &a_Matrix4, "assign to Matrix4 from Matrix4" );
    vmathM4MakeFromScalar( &a_Matrix4, randfloat() );
    vmathM4Prints( &a_Matrix4, "set Matrix4 with float" );
    vmathM4MakeFromScalar( &a_Matrix4, randfloat() );
    vmathM4Prints( &a_Matrix4, "set Matrix4 with float" );
    vmathM4MakeFromScalar( &a_Matrix4, 0.0f );
    vmathM4Prints( &a_Matrix4, "set elements to zero" );
    vmathM4MakeIdentity( &a_Matrix4 );
    vmathM4Prints( &a_Matrix4, "set to identity" );
    vmathM4MakeRotationX( &a_Matrix4, randfloat() );
    vmathM4Prints( &a_Matrix4, "set to rotationX" );
    vmathM4MakeRotationY( &a_Matrix4, randfloat() );
    vmathM4Prints( &a_Matrix4, "set to rotationY" );
    vmathM4MakeRotationZ( &a_Matrix4, randfloat() );
    vmathM4Prints( &a_Matrix4, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &tmpV3_8, rndflt3, rndflt2, rndflt1 );
    vmathM4MakeRotationZYX( &a_Matrix4, &tmpV3_8 );
    vmathM4Prints( &a_Matrix4, "set to rotation from Z,Y,X angles" );
    vmathV3Normalize( &tmpV3_9, &a_Vector3 );
    vmathM4MakeRotationAxis( &a_Matrix4, randfloat(), &tmpV3_9 );
    vmathM4Prints( &a_Matrix4, "set to rotation from axis angle" );
    vmathM4MakeTranslation( &a_Matrix4, &a_Vector3 );
    vmathM4Prints( &a_Matrix4, "set to translation" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathM4MakePerspective( &a_Matrix4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathM4Prints( &a_Matrix4, "set to perspective matrix" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathM4MakeFrustum( &a_Matrix4, rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6 );
    vmathM4Prints( &a_Matrix4, "set to frustum matrix" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathM4MakeOrthographic( &a_Matrix4, rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6 );
    vmathM4Prints( &a_Matrix4, "set to orthographic matrix" );
    vmathM4MakeLookAt( &a_Matrix4, &a_Point3, &b_Point3, &a_Vector3 );
    vmathM4Prints( &a_Matrix4, "set to look-at matrix" );
    vmathM4SetCol0( &a_Matrix4, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 0" );
    vmathM4SetCol1( &a_Matrix4, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 1" );
    vmathM4SetCol2( &a_Matrix4, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 2" );
    vmathM4SetCol3( &a_Matrix4, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 3" );
    vmathM4GetCol0( &tmpV4_0, &a_Matrix4 );
    vmathV4Prints( &tmpV4_0, "Matrix4 get col 0" );
    vmathM4GetCol1( &tmpV4_1, &a_Matrix4 );
    vmathV4Prints( &tmpV4_1, "Matrix4 get col 1" );
    vmathM4GetCol2( &tmpV4_2, &a_Matrix4 );
    vmathV4Prints( &tmpV4_2, "Matrix4 get col 2" );
    vmathM4GetCol3( &tmpV4_3, &a_Matrix4 );
    vmathV4Prints( &tmpV4_3, "Matrix4 get col 3" );
    vmathM4SetCol( &a_Matrix4, 0, &b_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 0" );
    vmathM4SetCol( &a_Matrix4, 1, &b_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 1" );
    vmathM4SetCol( &a_Matrix4, 2, &b_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 2" );
    vmathM4SetCol( &a_Matrix4, 3, &b_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set col 3" );
    vmathM4GetCol( &tmpV4_4, &a_Matrix4, 0 );
    vmathV4Prints( &tmpV4_4, "Matrix4 get col 0" );
    vmathM4GetCol( &tmpV4_5, &a_Matrix4, 1 );
    vmathV4Prints( &tmpV4_5, "Matrix4 get col 1" );
    vmathM4GetCol( &tmpV4_6, &a_Matrix4, 2 );
    vmathV4Prints( &tmpV4_6, "Matrix4 get col 2" );
    vmathM4GetCol( &tmpV4_7, &a_Matrix4, 3 );
    vmathV4Prints( &tmpV4_7, "Matrix4 get col 3" );
    vmathM4SetRow( &a_Matrix4, 0, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set row 0" );
    vmathM4SetRow( &a_Matrix4, 1, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set row 1" );
    vmathM4SetRow( &a_Matrix4, 2, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set row 2" );
    vmathM4SetRow( &a_Matrix4, 3, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "Matrix4 set row 3" );
    vmathM4GetRow( &tmpV4_8, &a_Matrix4, 0 );
    vmathV4Prints( &tmpV4_8, "Matrix4 get row 0" );
    vmathM4GetRow( &tmpV4_9, &a_Matrix4, 1 );
    vmathV4Prints( &tmpV4_9, "Matrix4 get row 1" );
    vmathM4GetRow( &tmpV4_10, &a_Matrix4, 2 );
    vmathV4Prints( &tmpV4_10, "Matrix4 get row 2" );
    vmathM4GetRow( &tmpV4_11, &a_Matrix4, 3 );
    vmathV4Prints( &tmpV4_11, "Matrix4 get row 3" );
    vmathM4SetCol( &a_Matrix4, 0, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "set " );
    vmathM4SetCol( &a_Matrix4, 1, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "set " );
    vmathM4SetCol( &a_Matrix4, 2, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "set " );
    vmathM4SetCol( &a_Matrix4, 3, &a_Vector4 );
    vmathM4Prints( &a_Matrix4, "set " );
    vmathM4GetCol( &tmpV4_12, &a_Matrix4, 0 );
    vmathV4Prints( &tmpV4_12, "get " );
    vmathM4GetCol( &tmpV4_13, &a_Matrix4, 1 );
    vmathV4Prints( &tmpV4_13, "get " );
    vmathM4GetCol( &tmpV4_14, &a_Matrix4, 2 );
    vmathV4Prints( &tmpV4_14, "get " );
    vmathM4GetCol( &tmpV4_15, &a_Matrix4, 3 );
    vmathV4Prints( &tmpV4_15, "get " );
    vmathM4SetElem( &a_Matrix4, 0, 0, randfloat() );
    vmathM4SetElem( &a_Matrix4, 0, 1, randfloat() );
    vmathM4SetElem( &a_Matrix4, 0, 2, randfloat() );
    vmathM4SetElem( &a_Matrix4, 0, 3, randfloat() );
    vmathM4SetElem( &a_Matrix4, 1, 0, randfloat() );
    vmathM4SetElem( &a_Matrix4, 1, 1, randfloat() );
    vmathM4SetElem( &a_Matrix4, 1, 2, randfloat() );
    vmathM4SetElem( &a_Matrix4, 1, 3, randfloat() );
    vmathM4SetElem( &a_Matrix4, 2, 0, randfloat() );
    vmathM4SetElem( &a_Matrix4, 2, 1, randfloat() );
    vmathM4SetElem( &a_Matrix4, 2, 2, randfloat() );
    vmathM4SetElem( &a_Matrix4, 2, 3, randfloat() );
    vmathM4SetElem( &a_Matrix4, 3, 0, randfloat() );
    vmathM4SetElem( &a_Matrix4, 3, 1, randfloat() );
    vmathM4SetElem( &a_Matrix4, 3, 2, randfloat() );
    vmathM4SetElem( &a_Matrix4, 3, 3, randfloat() );
    vmathM4Prints( &a_Matrix4, "Matrix4 set elements" );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 0, 0 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 0, 1 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 0, 2 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 0, 3 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 1, 0 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 1, 1 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 1, 2 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 1, 3 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 2, 0 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 2, 1 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 2, 2 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 2, 3 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 3, 0 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 3, 1 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 3, 2 )) );
    printf("%f\n", getfloat(vmathM4GetElem( &a_Matrix4, 3, 3 )) );
}

void
Transform3_methods_test()
{
    VmathMatrix3 a_Matrix3, b_Matrix3;
    VmathMatrix4 a_Matrix4, b_Matrix4;
    VmathTransform3 a_Transform3, b_Transform3;
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3, tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7, tmpV3_8, tmpV3_9, tmpV3_10, tmpV3_11, tmpV3_12, tmpV3_13, tmpV3_14, tmpV3_15, tmpV3_16, tmpV3_17;
    VmathVector4 tmpV4_0, tmpV4_1, tmpV4_2;
    VmathVector3 tmpV3_18, tmpV3_19, tmpV3_20, tmpV3_21;
    float rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &c_Vector3, pad );
    vmathV4GetXYZ( &c_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &d_Vector3, pad );
    vmathV4GetXYZ( &d_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &c_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &c_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathV3MakeFromP3( &tmpV3_4, &c_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_4, pad );
    vmathV4GetXYZ( &tmpV3_5, &tmpV4 );
    vmathP3MakeFromV3( &c_Point3, &tmpV3_5 );
    vmathV3MakeFromP3( &tmpV3_6, &d_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_6, pad );
    vmathV4GetXYZ( &tmpV3_7, &tmpV4 );
    vmathP3MakeFromV3( &d_Point3, &tmpV3_7 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3Prints( &c_Point3, "set Point3 with floats" );
    vmathP3Prints( &d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQPrints( &c_Quat, "set Quat with floats" );
    vmathQPrints( &d_Quat, "set Quat with floats" );
    vmathM3MakeFromCols( &a_Matrix3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathM3MakeFromCols( &b_Matrix3, &d_Vector3, &a_Vector3, &b_Vector3 );
    vmathM3Prints( &a_Matrix3, "set Matrix3 columns" );
    vmathM3Prints( &b_Matrix3, "set Matrix3 columns" );
    vmathM4MakeFromCols( &a_Matrix4, &a_Vector4, &b_Vector4, &c_Vector4, &d_Vector4 );
    vmathM4MakeFromCols( &b_Matrix4, &d_Vector4, &a_Vector4, &b_Vector4, &c_Vector4 );
    vmathM4Prints( &a_Matrix4, "set Matrix4 columns" );
    vmathM4Prints( &b_Matrix4, "set Matrix4 columns" );
    vmathT3MakeFromCols( &a_Transform3, &a_Vector3, &b_Vector3, &c_Vector3, &d_Vector3 );
    vmathT3MakeFromCols( &b_Transform3, &d_Vector3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathT3Prints( &a_Transform3, "set Transform3 columns" );
    vmathT3Prints( &b_Transform3, "set Transform3 columns" );
    vmathT3MakeFromM3V3( &a_Transform3, &a_Matrix3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "construct Transform3 with Matrix3 and Vector3" );
    vmathT3MakeFromQV3( &a_Transform3, &a_Quat, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "construct Transform3 with Quat and Vector3" );
    vmathT3Copy( &a_Transform3, &b_Transform3 );
    vmathT3Prints( &a_Transform3, "assign to Transform3 from Transform3" );
    vmathT3MakeFromScalar( &a_Transform3, randfloat() );
    vmathT3Prints( &a_Transform3, "set Transform3 with float" );
    vmathT3MakeFromScalar( &a_Transform3, randfloat() );
    vmathT3Prints( &a_Transform3, "set Transform3 with float" );
    vmathT3MakeFromScalar( &a_Transform3, 0.0f );
    vmathT3Prints( &a_Transform3, "set elements to zero" );
    vmathT3MakeIdentity( &a_Transform3 );
    vmathT3Prints( &a_Transform3, "set to identity" );
    vmathT3MakeRotationX( &a_Transform3, randfloat() );
    vmathT3Prints( &a_Transform3, "set to rotationX" );
    vmathT3MakeRotationY( &a_Transform3, randfloat() );
    vmathT3Prints( &a_Transform3, "set to rotationY" );
    vmathT3MakeRotationZ( &a_Transform3, randfloat() );
    vmathT3Prints( &a_Transform3, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &tmpV3_8, rndflt3, rndflt2, rndflt1 );
    vmathT3MakeRotationZYX( &a_Transform3, &tmpV3_8 );
    vmathT3Prints( &a_Transform3, "set to rotation from Z,Y,X angles" );
    vmathV3Normalize( &tmpV3_9, &a_Vector3 );
    vmathT3MakeRotationAxis( &a_Transform3, randfloat(), &tmpV3_9 );
    vmathT3Prints( &a_Transform3, "set to rotation from axis angle" );
    vmathT3MakeTranslation( &a_Transform3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "set to translation" );
    vmathT3SetCol0( &a_Transform3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 0" );
    vmathT3SetCol1( &a_Transform3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 1" );
    vmathT3SetCol2( &a_Transform3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 2" );
    vmathT3SetCol3( &a_Transform3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 3" );
    vmathT3GetCol0( &tmpV3_10, &a_Transform3 );
    vmathV3Prints( &tmpV3_10, "Transform3 get col 0" );
    vmathT3GetCol1( &tmpV3_11, &a_Transform3 );
    vmathV3Prints( &tmpV3_11, "Transform3 get col 1" );
    vmathT3GetCol2( &tmpV3_12, &a_Transform3 );
    vmathV3Prints( &tmpV3_12, "Transform3 get col 2" );
    vmathT3GetCol3( &tmpV3_13, &a_Transform3 );
    vmathV3Prints( &tmpV3_13, "Transform3 get col 3" );
    vmathT3SetCol( &a_Transform3, 0, &b_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 0" );
    vmathT3SetCol( &a_Transform3, 1, &b_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 1" );
    vmathT3SetCol( &a_Transform3, 2, &b_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 2" );
    vmathT3SetCol( &a_Transform3, 3, &b_Vector3 );
    vmathT3Prints( &a_Transform3, "Transform3 set col 3" );
    vmathT3GetCol( &tmpV3_14, &a_Transform3, 0 );
    vmathV3Prints( &tmpV3_14, "Transform3 get col 0" );
    vmathT3GetCol( &tmpV3_15, &a_Transform3, 1 );
    vmathV3Prints( &tmpV3_15, "Transform3 get col 1" );
    vmathT3GetCol( &tmpV3_16, &a_Transform3, 2 );
    vmathV3Prints( &tmpV3_16, "Transform3 get col 2" );
    vmathT3GetCol( &tmpV3_17, &a_Transform3, 3 );
    vmathV3Prints( &tmpV3_17, "Transform3 get col 3" );
    vmathT3SetRow( &a_Transform3, 0, &a_Vector4 );
    vmathT3Prints( &a_Transform3, "Transform3 set row 0" );
    vmathT3SetRow( &a_Transform3, 1, &a_Vector4 );
    vmathT3Prints( &a_Transform3, "Transform3 set row 1" );
    vmathT3SetRow( &a_Transform3, 2, &a_Vector4 );
    vmathT3Prints( &a_Transform3, "Transform3 set row 2" );
    vmathT3GetRow( &tmpV4_0, &a_Transform3, 0 );
    vmathV4Prints( &tmpV4_0, "Transform3 get row 0" );
    vmathT3GetRow( &tmpV4_1, &a_Transform3, 1 );
    vmathV4Prints( &tmpV4_1, "Transform3 get row 1" );
    vmathT3GetRow( &tmpV4_2, &a_Transform3, 2 );
    vmathV4Prints( &tmpV4_2, "Transform3 get row 2" );
    vmathT3SetCol( &a_Transform3, 0, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "set " );
    vmathT3SetCol( &a_Transform3, 1, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "set " );
    vmathT3SetCol( &a_Transform3, 2, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "set " );
    vmathT3SetCol( &a_Transform3, 3, &a_Vector3 );
    vmathT3Prints( &a_Transform3, "set " );
    vmathT3GetCol( &tmpV3_18, &a_Transform3, 0 );
    vmathV3Prints( &tmpV3_18, "get " );
    vmathT3GetCol( &tmpV3_19, &a_Transform3, 1 );
    vmathV3Prints( &tmpV3_19, "get " );
    vmathT3GetCol( &tmpV3_20, &a_Transform3, 2 );
    vmathV3Prints( &tmpV3_20, "get " );
    vmathT3GetCol( &tmpV3_21, &a_Transform3, 3 );
    vmathV3Prints( &tmpV3_21, "get " );
    vmathT3SetElem( &a_Transform3, 0, 0, randfloat() );
    vmathT3SetElem( &a_Transform3, 0, 1, randfloat() );
    vmathT3SetElem( &a_Transform3, 0, 2, randfloat() );
    vmathT3SetElem( &a_Transform3, 1, 0, randfloat() );
    vmathT3SetElem( &a_Transform3, 1, 1, randfloat() );
    vmathT3SetElem( &a_Transform3, 1, 2, randfloat() );
    vmathT3SetElem( &a_Transform3, 2, 0, randfloat() );
    vmathT3SetElem( &a_Transform3, 2, 1, randfloat() );
    vmathT3SetElem( &a_Transform3, 2, 2, randfloat() );
    vmathT3SetElem( &a_Transform3, 3, 0, randfloat() );
    vmathT3SetElem( &a_Transform3, 3, 1, randfloat() );
    vmathT3SetElem( &a_Transform3, 3, 2, randfloat() );
    vmathT3Prints( &a_Transform3, "Transform3 set elements" );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 0, 0 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 0, 1 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 0, 2 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 1, 0 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 1, 1 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 1, 2 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 2, 0 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 2, 1 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 2, 2 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 3, 0 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 3, 1 )) );
    printf("%f\n", getfloat(vmathT3GetElem( &a_Transform3, 3, 2 )) );
}

int main()
{
    int i;
    printf("\n __begin__ \n");
    for ( i = 0; i < 2; i++ ) {
        Matrix3_methods_test();
        Matrix4_methods_test();
        Transform3_methods_test();
    }
    printf("\n __end__ \n");
    return 0;
}
