/**********************************************************************
*
*    wp17.c
*    ======
*
*    This file is part of the VARKON WindowPac Library.
*    URL: http://www.varkon.com
*
*    This file includes:
*
*    wplstv();  Interactive Last view
*    wpperp();  Interactive PERP_VIEW
*    wpcent();  Interactive CEN_VIEW
*    wpscle();  Interactive SCL_VIEW
*    wpacvi();  ACT_VIEW in MBS
*    wpupvi();  Uppdate view after SCL_VIEW or CEN_VIEW
*    wpuppr();  Uppdate view after PERP_VIEW
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    (C)Microform AB 1984-1999, Johan Kjellander, johan@microform.se
*
***********************************************************************/

#include "../../DB/include/DB.h"
#include "../../IG/include/IG.h"
#include "../../GP/include/GP.h"
#include "../../GE/include/GE.h"
#include "../include/WP.h"
#include <string.h>
#include <math.h>

extern VY          vytab[];

static int vyindx(char vynamn[]);
static void drwarr(WPGWIN *gwinpt, GC arr_gc, int ix1, int iy1,
                   int ix2, int iy2);

/*!******************************************************/

        short wplstv(
        WPGWIN *gwinpt)

/*      X11-funktion fr fregende vy.
 *
 *      In: gwinpt = Pekare till fnstret som innehller vyn.
 *
 *      Ut: Inget.
 *
 *      FV:      0 = OK.
 *
 *      (C)microform ab 5/1/95 J. Kjellander
 *
 ******************************************************!*/

  {
   WPVY tmpvy;

/*
***Om det finns en fregende vy lter vi den och nuvarande vy
***byta plats annar gr vi ingenting.
*/
   if ( gwinpt->old_vy.valid )
     {
     V3MOME(&gwinpt->vy,&tmpvy,sizeof(WPVY));
     V3MOME(&gwinpt->old_vy,&gwinpt->vy,sizeof(WPVY));
     V3MOME(&tmpvy,&gwinpt->old_vy,sizeof(WPVY));
/*
***Om det r V3:s huvudfnster skall ven grapac underrttas.
*/
     if ( gwinpt->id.w_id == GWIN_MAIN )
       wpupgp(gwinpt);
/*
***Uppdatera fnsterramen.
*/
     wpupwb(gwinpt);
/*
***Uppdatera fnstret p skrmen.
*/
     wprepa((wpw_id)gwinpt->id.w_id);
     }

   return(0);
  }

/********************************************************/
/*!******************************************************/

        short wpperp(
        WPGWIN *gwinpt,
        int     x,
        int     y)

/*      Varkon-funktion fr instllning av perspektiv
 *      i viss vy med X-Windows.
 *
 *      In: gwinpt = Pekare till fnstret som innehller vyn.
 *          x,y    = Aktiverande knapps/ikons rootposition.
 *
 *      Ut: Inget.
 *
 *      FV:      0 = OK.
 *          REJECT = Operationen avbruten.
 *
 *      (C)microform ab 5/1/95 J. Kjellander
 *
 ******************************************************!*/

  {
   char     rubrik[81],persp[81],dist[81],okey[81],reject[81],help[81],
            on[81],off[81],valstr[81];
   int      main_x,main_y;
   short    main_dx,main_dy,alt_x,alt_y,alth,altlen,ly,lm;
   v2int    iwin_id,dum_id,onoff_id,but_id,help_id,okey_id,reject_id,
            dist_id,value_id;
   bool     diston;
   double   dsval;

   WPWIN   *winptr;
   WPIWIN  *iwinpt;
   WPBUTT  *buttpt;
   WPEDIT  *editpt;

/*
***Texter fr rubrik mm.
*/
   if ( !wpgrst("varkon.persp.title",rubrik) )
     strcpy(rubrik,"Perspektiv f|r vy : ");

   if ( !wpgrst("varkon.persp.persp",persp) )
     strcpy(persp,"Sant perspektiv");

   if ( !wpgrst("varkon.persp.dist",dist) )
     strcpy(dist,"Avstnd");

   if ( !wpgrst("varkon.input.on",on) )
     strcpy(on,"P");

   if ( !wpgrst("varkon.input.off",off) )
     strcpy(off,"Av");

   if ( !wpgrst("varkon.input.okey",okey) )
     strcpy(okey,"Okej");

   if ( !wpgrst("varkon.input.reject",reject) )
     strcpy(reject,"Avbryt");

   if ( !wpgrst("varkon.input.help",help) )
     strcpy(help,"Hjlp");
/*
***Lngsta texten avgr fnstrets bredd.
*/
   altlen = 0;

   if ( wpstrl(rubrik) + wpstrl(gwinpt->vy.vynamn) > altlen )
     altlen = wpstrl(rubrik) + wpstrl(gwinpt->vy.vynamn);
   if ( wpstrl(persp) + wpstrl(on) > altlen )
     altlen = wpstrl(persp) + wpstrl(on);
   if ( wpstrl(dist) + wpstrl("1234567890123") > altlen )
     altlen = wpstrl(dist) + wpstrl("1234567890123");
   if ( wpstrl(okey) + wpstrl(reject) + wpstrl(help) > altlen )
     altlen = wpstrl(okey) + wpstrl(reject) + wpstrl(help);
/*
***Berkna luft yttre, knapparnas hjd, luft mellan och
***huvudfnstrets hjd.
*/
   ly   = (short)(0.8*wpstrh());
   alth = (short)(1.6*wpstrh()); 
   lm   = (short)(1.4*wpstrh());

   main_dx = (short)(ly + altlen + 2*lm + ly);
   main_dy = (short)(ly + 2*(alth + ly) +  ly + 2*wpstrh() + ly);  
/*
***Skapa sjlva perspektivfnstret som ett WPIWIN.
*/
   strcat(rubrik,gwinpt->vy.vynamn);
   wpposw(x,y,main_dx+10,main_dy+25,&main_x,&main_y);
   wpwciw((short)main_x,(short)main_y,main_dx,main_dy,rubrik,&iwin_id);
/*
***Ramls button fr persp.
*/
   alt_x  = ly;
   alt_y  = ly;
   altlen = wpstrl(persp);
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                   (short)0,persp,persp,"",WP_BGND,WP_FGND,&dum_id);
/*
***Toggle-button fr ON/OFF.
*/
   alt_x = alt_x + wpstrl(persp) + lm;
   if ( wpstrl(on) > wpstrl(off) ) altlen = (short)(wpstrl(on)  + 15);
   else                            altlen = (short)(wpstrl(off) + 15);

   dsval = gwinpt->vy.vydist;
   if ( dsval == 0.0 ) diston = FALSE;
   else                diston = TRUE;

   if ( diston == FALSE )
     wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                     (short)1,off,on,"",WP_BGND,WP_FGND,&onoff_id);
/*
***Om perspektiv redan r satt skall avstndet visas.
*/
   else
     {
     wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                     (short)1,on,off,"",WP_BGND,WP_FGND,&onoff_id);
     alt_x  = ly;
     alt_y  = ly + alth + ly;
     altlen = wpstrl(dist);
     wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                     (short)0,dist,dist,"",WP_BGND,WP_FGND,&dist_id);

     alt_x  = (short)(ly + altlen + 10);
     altlen = wpstrl("1234567890123");
     sprintf(valstr,"%g",dsval);
     wpmced((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)1,
                             valstr,15,&value_id);
     }
/*
***Okey, avbryt och hjlp.
*/
   alt_x  = (short)(ly);
   alt_y  = (short)(ly + 2*(alth + ly) + ly);
   alth   = (short)(2*wpstrh());
   altlen = (short)(wpstrl(okey) + 15);
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                   (short)2,okey,okey,"",WP_BGND,WP_FGND,&okey_id);

   alt_x  = (short)(alt_x + altlen + lm);
   altlen = (short)(wpstrl(reject) + 15);
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                   (short)2,reject,reject,"",WP_BGND,WP_FGND,&reject_id);

   altlen = (short)(wpstrl(help) + 15);
   alt_x  = (short)(main_dx - altlen - lm);
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                   (short)2,help,help,"",WP_BGND,WP_FGND,&help_id);
/*
***Klart fr visning.
*/
   wpwshw(iwin_id);
/*
***Vnta p action.
*/
loop:
   wpwwtw(iwin_id,SLEVEL_V3_INP,&but_id);
/*
***Ok.
*/
   if ( but_id == okey_id )
     {
     if ( diston == TRUE )
       {
       wpgted(iwin_id,value_id,valstr);
       if ( sscanf(valstr,"%lf",&dsval) != 1 )
         {
         XBell(xdisp,100);
         goto loop;
         }
       }
     else dsval = 0.0;

     V3MOME(&gwinpt->vy,&gwinpt->old_vy,sizeof(WPVY));
     gwinpt->vy.vydist = dsval;
     }
/*
***Avbryt.
*/
   else if ( but_id == reject_id )
     {
     wpwdel(iwin_id);
     return(REJECT);
     }
/*
***Hjlp.
*/
   else if ( but_id == help_id )
     {
     ighelp();
     goto loop;
     }
/*
***Onoff.
*/
   else if ( but_id == onoff_id )
     {
/*
***Om perspektiv r p stnger vi av det och suddar.
*/
     if ( diston == TRUE )
       {
       wpgted(iwin_id,value_id,valstr);
       if ( sscanf(valstr,"%lf",&dsval) != 1 )
         {
         XBell(xdisp,100);
         goto loop;
         }
       wpwdls(iwin_id,dist_id);
       wpwdls(iwin_id,value_id);
       diston = FALSE;
       }
/*
***Om perspektiv r av stter vi p det och
***skapar tv nya subfnster.
*/
     else
       {
       alt_x  = ly;
       alt_y  = ly + alth + ly;
       altlen = wpstrl(dist);
       wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,
                       (short)0,dist,dist,"",WP_BGND,WP_FGND,&dist_id);

       alt_x  = (short)(ly + altlen + 10);
       altlen = wpstrl("1234567890123");
       sprintf(valstr,"%g",dsval);
       wpmced((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)1,
                               valstr,15,&value_id);

       winptr = wpwgwp((wpw_id)iwin_id);
       iwinpt = (WPIWIN *)winptr->ptr;
       buttpt = (WPBUTT *)iwinpt->wintab[dist_id].ptr;
       editpt = (WPEDIT *)iwinpt->wintab[value_id].ptr;
       wpfoed(editpt,TRUE);
       wpxpbu(buttpt);
       wpxped(editpt);
       XFlush(xdisp);
       diston = TRUE;
       }
     goto loop;
     }
/*
***Hndelse frn edit-fnstret bryr vi oss inte om.
*/
   else if ( but_id == value_id ) goto loop;
/*
***Nu r det dags att lgga av.
*/
   wpwdel(iwin_id);
/*
***Om det r V3:s huvudfnster skall ven grapac underrttas.
*/
   if ( gwinpt->id.w_id == GWIN_MAIN ) wpupgp(gwinpt);
/*
***Uppdatera skrmen.
*/
   wprepa((wpw_id)gwinpt->id.w_id);

   return(0);
  }

/********************************************************/
/*!******************************************************/

        short wpcent(
        WPGWIN *gwinpt)

/*      Varkon-funktion fr panorering med X-Windows.
 *
 *      In: gwinpt = Pekare till fnstret som skall panoreras.
 *
 *      Ut: Inget.
 *
 *      FV:      0 = OK.
 *          REJECT = Operationen avbruten.
 *
 *      (C)microform ab 4/1/95 J. Kjellander
 *
 ******************************************************!*/

  {
    short     status=0;
    int       x1=0,y1=0,curx2,cury2,lastx2=0,lasty2=0;
    double    mdx,mdy;
    Window    root,child;
    int       root_x,root_y,win_x,win_y;
    unsigned  int mask;
    XEvent    xev;           
    GC        Arr_GC;
    XGCValues values;

/*
***Eventmask och cursor fr gummiband.
*/
   igptma(310,IG_MESS);
   XSelectInput(xdisp,gwinpt->id.x_id,GWEM_RUB);
   wpscur(gwinpt->id.w_id,TRUE,xgcur1);
/*
***GC fr pilspetsen.
*/
   Arr_GC = XCreateGC(xdisp,gwinpt->id.x_id,0,&values);
   XSetLineAttributes(xdisp,Arr_GC,2,LineSolid,CapButt,JoinBevel);
   XSetFunction(xdisp,Arr_GC,GXxor);
   XSetBackground(xdisp,Arr_GC,wpgcol(0));
   XSetForeground(xdisp,Arr_GC,wpgcol(3));
/*
***Nr vi brjar har musknappen nnu inte tryckts ned.
*/
   while ( 1 )
     {
     XMaskEvent(xdisp,ButtonPressMask |
                      ButtonReleaseMask |
                      PointerMotionMask,&xev);

     switch (xev.type)
       {
/*
***Detta r frsta gngen som musknappen trycks ned.
***Kolla att det r i rtt fnster.
*/
       case ButtonPress:
       wpscur(gwinpt->id.w_id,TRUE,xgcur2);
       igrsma();

       if ( xev.xany.window != gwinpt->id.x_id )
         {
         status = REJECT;
         goto exit;
         }
/*
***Knapp 2 och 3 betyder avbrott.
*/
       if ( xev.xbutton.button == 2 )
         {
         status = GOMAIN;
         goto exit;
         }
       if ( xev.xbutton.button == 3 )
         {
         status = REJECT;
         goto exit;
         }

       igptma(133,IG_MESS);
       x1 = curx2 = lastx2 = xev.xkey.x;
       y1 = cury2 = lasty2 = xev.xkey.y;
       XDrawArc(xdisp,gwinpt->id.x_id,Arr_GC,
                                 x1-10,y1-10,20,20,0,360*64);
       drwarr(gwinpt,Arr_GC,x1,y1,x1,y1);
       break;
/*
***Nu flyttar sig musen.
*/
       case MotionNotify:
       curx2 = xev.xmotion.x;
       cury2 = xev.xmotion.y;
       if ( curx2 != lastx2  || cury2 != lasty2 )
         {
         drwarr(gwinpt,Arr_GC,x1,y1,lastx2,lasty2);
         if ( curx2 != x1  || cury2 != y1 )
           drwarr(gwinpt,Arr_GC,x1,y1,curx2,cury2);
         lastx2 = curx2;
         lasty2 = cury2;
         }
/*
***Fr att f ett nytt Motion-event mste vi anropa XQueryPointer().
*/
       XQueryPointer(xdisp,gwinpt->id.x_id,&root,&child,&root_x,&root_y,
                     &win_x,&win_y,&mask);
       break;
/*
***Nr knappen slpps igen r det slut.
*/
       case ButtonRelease:
       igrsma();
       if ( lastx2 != x1  || lasty2 != y1 )
         drwarr(gwinpt,Arr_GC,x1,y1,lastx2,lasty2);
       curx2 = xev.xkey.x;
       cury2 = xev.xkey.y;
       XDrawArc(xdisp,gwinpt->id.x_id,Arr_GC,
                                 x1-10,y1-10,20,20,0,360*64);
/*
***Varkons y-axel r motsatt X11.
*/
       y1    = gwinpt->geo.dy - y1;
       cury2 = gwinpt->geo.dy - cury2;
       goto update;
       }
     }
/*
***Hur mycket skall vi flytta ?
*/
update:
   V3MOME(&gwinpt->vy,&gwinpt->old_vy,sizeof(WPVY));

   mdx = ((double)(curx2 - x1)/(double)gwinpt->geo.dx) *
         (gwinpt->vy.modwin.xmax - gwinpt->vy.modwin.xmin);
   mdy = ((double)(cury2 - y1)/(double)gwinpt->geo.dy) *
         (gwinpt->vy.modwin.ymax - gwinpt->vy.modwin.ymin);

   gwinpt->vy.modwin.xmin -= mdx;
   gwinpt->vy.modwin.xmax -= mdx;
   gwinpt->vy.modwin.ymin -= mdy;
   gwinpt->vy.modwin.ymax -= mdy;

   wpnrgw(gwinpt);
/*
***Om det r V3:s huvudfnster skall ven grapac underrttas.
*/
   if ( gwinpt->id.w_id == GWIN_MAIN ) wpupgp(gwinpt);
/*
***Uppdatera skrmen.
*/
   wprepa((wpw_id)gwinpt->id.w_id);
/*
***Utgng. terstll eventmask och cursor.
*/
exit:
   XSelectInput(xdisp,gwinpt->id.x_id,GWEM_NORM);
   wpscur(gwinpt->id.w_id,FALSE,(Cursor)0);
   XFreeGC(xdisp,Arr_GC);

   return(status);
  }

/********************************************************/
/*!******************************************************/

        short wpscle(
        WPGWIN *gwinpt,
        int     x,
        int     y)

/*      Varkon-funktion fr skala med X-Windows.
 *
 *      In: gwinpt = Pekare till fnstret som skall skalas.
 *          x,y    = Aktiverande knapps/ikons rootposition.
 *
 *      Ut: Inget.
 *
 *      FV:      0 = OK.
 *          REJECT = Operationen avbruten.
 *
 *      Felkod: IG3042 = Kan ej minska skalan mera.
 *
 *      (C)microform ab 4/1/95 J. Kjellander
 *
 ******************************************************!*/

  {
   char     rubrik[81],dubbla[81],half[81],reject[81],help[81],
            scale[81];
   int      main_x,main_y;
   short    main_dx,main_dy,alt_x,alt_y,alth,altlen,ly,lm;
   v2int    iwin_id,scale_id,one_id,but_id,help_id,
            dubbla_id,half_id,reject_id;
   double   skala,xmin,xmax,ymin,ymax,mdx,mdy;

/*
***Texter fr rubrik, dubbla, halva, avbryt och hjlp.
*/
   if ( !wpgrst("varkon.scale.title",rubrik) )  strcpy(rubrik,"Skala");
   if ( !wpgrst("varkon.scale.double",dubbla) ) strcpy(dubbla,"Dubbla");
   if ( !wpgrst("varkon.scale.half",half) )     strcpy(half,"Halva");
   if ( !wpgrst("varkon.input.reject",reject) ) strcpy(reject,"Avbryt");
   if ( !wpgrst("varkon.input.help",help) )     strcpy(help,"Hj{lp");
/*
***Fr att nu kunna bestmma storleken p sjlva
***skala-fnstret utgr vi frn  2 kolumner med
***knappar dr knapparnas lngd bestms av den lngsta
***alternativtexten.
*/
   altlen = 0;

   if ( wpstrl("1.0")      > altlen ) altlen = (short)wpstrl("1.0");
   if ( wpstrl(dubbla)     > altlen ) altlen = (short)wpstrl(dubbla);
   if ( wpstrl(half)       > altlen ) altlen = (short)wpstrl(half);
   if ( wpstrl(reject)     > altlen ) altlen = (short)wpstrl(reject);
   if ( wpstrl(help)       > altlen ) altlen = (short)wpstrl(help);
   if ( wpstrl("12345678") > altlen ) altlen = (short)wpstrl("12345678");

   altlen *= 1.3;
/*
***Berkna luft yttre, knapparnas hjd, luft mellan och
***huvudfnstrets hjd.
*/
   ly   = (short)(0.8*wpstrh());
   alth = (short)(1.6*wpstrh()); 
   lm   = (short)(1.4*wpstrh());

   main_dx = (short)(ly + altlen + lm + altlen + ly);
   main_dy = (short)(ly + 2*(alth + ly) +  ly + 2*wpstrh() + ly);  
/*
***Skapa sjlva alternativfnstret som ett WPIWIN.
*/
   wpposw(x,y,main_dx+10,main_dy+25,&main_x,&main_y);
   wpwciw((short)main_x,(short)main_y,main_dx,main_dy,rubrik,&iwin_id);
/*
***Edit-knapp fr godtycklig skala.
***Berkna nuvarande skala.
*/
   mdx   =  gwinpt->geo.psiz_x *
           (gwinpt->vy.scrwin.xmax - gwinpt->vy.scrwin.xmin);
   mdy   =  gwinpt->geo.psiz_y *
           (gwinpt->vy.scrwin.ymax - gwinpt->vy.scrwin.ymin);

   skala = mdx/(gwinpt->vy.modwin.xmax - gwinpt->vy.modwin.xmin);
   sprintf(scale,"%g",skala);

   alt_x  = ly;
   alt_y  = ly;
   wpmced((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)1,
                           scale,15,&scale_id);
/*
***Button fr skala = 1.0.
*/
   alt_x  = ly + altlen + lm;
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)1,
                           "1.0","1.0","",WP_BGND,WP_FGND,&one_id);
/*
***Dubbla och halva.
*/
   alt_x  = ly;
   alt_y  = ly + alth + ly;
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)1,
                           dubbla,dubbla,"",WP_BGND,WP_FGND,&dubbla_id);

   alt_x  = ly + altlen + lm;
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)1,
                          half,half,"",WP_BGND,WP_FGND,&half_id);
/*
***Avbryt och hjlp.
*/
   alt_x  = (short)(ly);
   alt_y  = (short)(ly + 2*(alth + ly) + ly);
   alth   = (short)(2*wpstrh());
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)2,
                           reject,reject,"",WP_BGND,WP_FGND,&reject_id);

   alt_x  = ly + altlen + lm;
   wpmcbu((wpw_id)iwin_id,alt_x,alt_y,altlen,alth,(short)2,
                           help,help,"",WP_BGND,WP_FGND,&help_id);
/*
***Klart fr visning.
*/
   wpwshw(iwin_id);
/*
***Vnta p action. Service-niv fr key-event saknar
***intresse i sammanhanget.
*/
loop:
   wpwwtw(iwin_id,SLEVEL_V3_INP,&but_id);
/*
***Avbryt.
*/
   if ( but_id == reject_id )
     {
     wpwdel(iwin_id);
     return(REJECT);
     }
/*
***Hjlp.
*/
   else if ( but_id == help_id )
     {
     ighelp();
     goto loop;
     }
/*
***Inmatad skala.
*/
   else if ( but_id == scale_id )
     {
     wpgted(iwin_id,but_id,scale);
     if ( sscanf(scale,"%lf",&skala) != 1 )
       {
       XBell(xdisp,100);
       goto loop;
       }
     }
/*
***Skala = 1.0
*/
   else if ( but_id == one_id ) skala = 1.0;
/*
***Dubbla.
*/
   else if ( but_id == dubbla_id ) skala *= 2.0;
/*
***Halva.
*/
   else if ( but_id == half_id ) skala /= 2.0;
/*
***Dags att sluta.
*/
   wpwdel(iwin_id);
/*
***Vi har nu en ny skalfaktor och kan berkna ett nytt modellfnster.
*/
   xmin =  gwinpt->vy.modwin.xmin + 
          (gwinpt->vy.modwin.xmax - gwinpt->vy.modwin.xmin)/2.0 -
                     mdx/2.0/skala;
   xmax =  gwinpt->vy.modwin.xmin +
          (gwinpt->vy.modwin.xmax - gwinpt->vy.modwin.xmin)/2.0 + 
                     mdx/2.0/skala;
   ymin =  gwinpt->vy.modwin.ymin +
          (gwinpt->vy.modwin.ymax - gwinpt->vy.modwin.ymin)/2.0 -
                     mdy/2.0/skala;
   ymax =  gwinpt->vy.modwin.ymin +
          (gwinpt->vy.modwin.ymax - gwinpt->vy.modwin.ymin)/2.0 +
                     mdy/2.0/skala;
/*
***Uppdatera WPGWIN-posten.
*/
   V3MOME(&gwinpt->vy,&gwinpt->old_vy,sizeof(WPVY));

   gwinpt->vy.modwin.xmin = xmin;
   gwinpt->vy.modwin.xmax = xmax;
   gwinpt->vy.modwin.ymin = ymin;
   gwinpt->vy.modwin.ymax = ymax;
   wpnrgw(gwinpt);
/*
***Om det r V3:s huvudfnster skall ven grapac underrttas.
*/
   if ( gwinpt->id.w_id == GWIN_MAIN ) wpupgp(gwinpt);
/*
***Uppdatera skrmen.
*/
   wprepa((wpw_id)gwinpt->id.w_id);

   return(0);
  }

/********************************************************/
/*!******************************************************/

        short wpacvi(
        char   name[],
        v2int  win_id)

/*      Interface-rutin fr ACT_VIEW. Aktiverar en vy ur
 *      vytab i ett visst grafiskt fnster.
 *
 *      In: name   => Vyns namn.
 *          win_id => ID fr grafiskt fnster.
 *
 *      Ut: Inget.
 *
 *      Felkoder: WP1332 = Vyn %s finns ej.
 *                WP1342 = Fnstret %s finns ej.
 *                WP1352 = Fnstret %s r ej ett WPGWIN.
 *                WP1412 = Vyn %s r korrupt.
 *
 *      (C)microform ab 21/12/94 J. Kjellander
 *
 ******************************************************!*/

  {
   int     i,j;
   char    errbuf[81];
   VY      newvy;
   DBVector   por,pu1,pu2;
   DBTmat  vymat;
   WPWIN  *winptr;
   WPGWIN *gwinpt;

/*
***Var i vytab finns vyn?
*/
   if ( (i=vyindx(name)) == -1 ) return(erpush("WP1332",name));
/*
***Finns fnstret i wpwtab?
*/
   if ( (winptr=wpwgwp((wpw_id)win_id)) == NULL )
     {
     sprintf(errbuf,"%d",win_id);
     return(erpush("WP1342",errbuf));
     }
/*
***r det ett WPGWIN ? Om s, fixa C-pekare till fnstret.
*/
   if ( winptr->typ != TYP_GWIN )
     {
     sprintf(errbuf,"%d",win_id);
     return(erpush("WP1352",errbuf));
     }
   else gwinpt = (WPGWIN *)winptr->ptr;
/*
***Allt r OK.  Om detta r huvudfnstret uppdaterar vi vytab
***med den gamla vyn:s modellfnster och perspektivavstnd
***(om den finns i vytab).
*/
   if ( win_id == GWIN_MAIN  &&  (j=vyindx(gwinpt->vy.vynamn)) >= 0 )
     {
     vytab[j].vywin[0] = gwinpt->vy.modwin.xmin;
     vytab[j].vywin[1] = gwinpt->vy.modwin.ymin;
     vytab[j].vywin[2] = gwinpt->vy.modwin.xmax;
     vytab[j].vywin[3] = gwinpt->vy.modwin.ymax;
     vytab[j].vydist   = gwinpt->vy.vydist;
     }
/*
***Nu uppdaterar vi WPGWIN-posten med data
***frn vytab. Om vy:n r av typen betraktelseposition
***mste matris berknas. Observera att detta gller
***ven i 2D tex. fr offsetkurvor.
*/
   strcpy(gwinpt->vy.vynamn,vytab[i].vynamn);
   gwinpt->vy.vy_3D  = vytab[i].vy3d;
   gwinpt->vy.vydist = vytab[i].vydist;
/*
***Lite felkontroller innan vi stter upp modellfnstret.
*/
   if ( vytab[i].vywin[2] <= vytab[i].vywin[0] )
     return(erpush("WP1412",name));
   if ( vytab[i].vywin[3] <= vytab[i].vywin[1] )
     return(erpush("WP1412",name));

   gwinpt->vy.modwin.xmin = vytab[i].vywin[0];
   gwinpt->vy.modwin.xmax = vytab[i].vywin[2];
   gwinpt->vy.modwin.ymin = vytab[i].vywin[1];
   gwinpt->vy.modwin.ymax = vytab[i].vywin[3];
/*
***Vyn definieras av en betraktelseposition. Vymatris
***berknas hr med samma metod som i grapac/gp1/gpstvi().
***Berkna med hjlp av vyvektorn tv nya vektorer som
***spnner upp X/Y-planet i den nskade vyn.
*/
   if ( vytab[i].vytypp )
     {
     pu1.y_gm = 0.0;
     if ( (vytab[i].vyrikt.x_vy*vytab[i].vyrikt.x_vy +
           vytab[i].vyrikt.z_vy*vytab[i].vyrikt.z_vy) < 0.001 )
       {
       pu1.x_gm = 0.0; pu1.z_gm = 1.0; pu2.x_gm = 1.0;
       pu2.y_gm = 0.0; pu2.z_gm = 0.0;
       }
     else
       {
       pu1.x_gm = vytab[i].vyrikt.z_vy;
       pu1.z_gm = 0.0;
       if ( vytab[i].vyrikt.x_vy != 0.0 ) pu1.z_gm = -vytab[i].vyrikt.x_vy;
       if ( (vytab[i].vyrikt.y_vy*vytab[i].vyrikt.y_vy) < 0.001 )
         {
         pu2.x_gm = 0.0; pu2.y_gm = 1.0; pu2.z_gm = 0.0;
         }
       else
         {
         pu2.x_gm = vytab[i].vyrikt.z_vy*pu1.y_gm +
                    vytab[i].vyrikt.y_vy*pu1.z_gm;
         pu2.y_gm = vytab[i].vyrikt.z_vy*pu1.x_gm -
                    vytab[i].vyrikt.x_vy*pu1.z_gm;
         pu2.z_gm = vytab[i].vyrikt.x_vy*pu1.y_gm -
                    vytab[i].vyrikt.y_vy*pu1.x_gm;
         }
       }
/*
***Bilda transformationsmatris.
*/
     por.x_gm = 0.0; por.y_gm = 0.0; por.z_gm = 0.0;
     GEmktf_3p(&por,&pu1,&pu2,&vymat);

     gwinpt->vy.vymat.k11 = vymat.g11;
     gwinpt->vy.vymat.k12 = vymat.g12;
     gwinpt->vy.vymat.k13 = vymat.g13;
     gwinpt->vy.vymat.k21 = vymat.g21;
     gwinpt->vy.vymat.k22 = vymat.g22;
     gwinpt->vy.vymat.k23 = vymat.g23;
     gwinpt->vy.vymat.k31 = vymat.g31;
     gwinpt->vy.vymat.k32 = vymat.g32;
     gwinpt->vy.vymat.k33 = vymat.g33;
     }
/*
***Det r en matris-vy, d blir det enklare.
*/
   else
     {
     gwinpt->vy.vymat.k11 = vytab[i].vymatr.v11;
     gwinpt->vy.vymat.k12 = vytab[i].vymatr.v12;
     gwinpt->vy.vymat.k13 = vytab[i].vymatr.v13;
     gwinpt->vy.vymat.k21 = vytab[i].vymatr.v21;
     gwinpt->vy.vymat.k22 = vytab[i].vymatr.v22;
     gwinpt->vy.vymat.k23 = vytab[i].vymatr.v23;
     gwinpt->vy.vymat.k31 = vytab[i].vymatr.v31;
     gwinpt->vy.vymat.k32 = vytab[i].vymatr.v32;
     gwinpt->vy.vymat.k33 = vytab[i].vymatr.v33;
     }
/*
***Normalisera.
*/
   wpnrgw(gwinpt);
/*
***Om det r huvudfnstret som skall f den aktuella vyn
***mste ven grapac f veta om det. D stter vi inte upp
***det modellfnster som finns i vytab utan det som fnstret
***sjlv ftt efter normalisering s att actvy  snt fr
***rtt vrden.
*/
   if ( win_id == GWIN_MAIN )
     {
     V3MOME(&vytab[i],&newvy,sizeof(VY));

     newvy.vywin[0] = gwinpt->vy.modwin.xmin;
     newvy.vywin[1] = gwinpt->vy.modwin.ymin;
     newvy.vywin[2] = gwinpt->vy.modwin.xmax;
     newvy.vywin[3] = gwinpt->vy.modwin.ymax;

     gpswin(&newvy);
     gpstvi(&newvy);
     }
/*
***Uppdatera fnsterramen.
*/
   wpupwb(gwinpt);

   return(0);
  }

/********************************************************/
/*!******************************************************/

        short wpupvi(
        char *name,
        VY   *newwin)

/*      Anropas av SCL_VIEW() och CEN_VIEW().
 *      Uppdaterar alla fnster som har den aktuella vyn
 *      med ett nytt modellfnster.
 *
 *      In: name   = Vyns namn.
 *          newwin = Nytt modellfnster.
 *
 *      Ut: Inget.
 *
 *      Felkoder: WP1332 = Vyn %s finns ej.
 *
 *      (C)microform ab 1996-11-03 J. Kjellander
 *
 ******************************************************!*/

  {
   int     i;
   WPWIN  *winptr;
   WPGWIN *gwinpt;


/*
***Loopa igenom alla WPGWIN-fnster.
*/
   for ( i=0; i<WTABSIZ; ++i )
     {
     if ( (winptr=wpwgwp((wpw_id)i)) != NULL  &&
           winptr->typ == TYP_GWIN )
       {
/*
***Ett grafiskt fnster har hittats. r vyn "name" aktiv
***i detta fnster ?
*/
       gwinpt = (WPGWIN *)winptr->ptr;
/*
***Om s r fallet uppdaterar vi dess modellfnster.
*/
       if ( strcmp(gwinpt->vy.vynamn,name ) == 0 )
         {
         gwinpt->vy.modwin.xmin = newwin->vywin[0];
         gwinpt->vy.modwin.xmax = newwin->vywin[2];
         gwinpt->vy.modwin.ymin = newwin->vywin[1];
         gwinpt->vy.modwin.ymax = newwin->vywin[3];
         wpnrgw(gwinpt);
         }
       }
     }

   return(0);
  }

/********************************************************/
/*!******************************************************/

        short wpuppr(
        char  *name,
        double dist)

/*      Anropas av PERP_VIEW().
 *      Uppdaterar alla fnster som har den aktuella vyn
 *      med ett nytt perpektivasvstnd.
 *
 *      In: name   = Vyns namn.
 *          dist   = Nytt perspektivavstnd.
 *
 *      Ut: Inget.
 *
 *      Felkoder: WP1332 = Vyn %s finns ej.
 *
 *      (C)microform ab 1999-02-02 J. Kjellander
 *
 ******************************************************!*/

  {
   int     i;
   WPWIN  *winptr;
   WPGWIN *gwinpt;

/*
***Loopa igenom alla WPGWIN-fnster och uppdatera dom med rtt namn.
*/
   for ( i=0; i<WTABSIZ; ++i )
     {
     if ( (winptr=wpwgwp((wpw_id)i)) != NULL  &&  winptr->typ == TYP_GWIN )
       {
       gwinpt = (WPGWIN *)winptr->ptr;
       if ( strcmp(gwinpt->vy.vynamn,name ) == 0 ) gwinpt->vy.vydist = dist;
       }
     }

   return(0);
  }

/********************************************************/
/*!******************************************************/

 static int vyindx(
        char vynamn[])

/*
 *      In: Vynamn.
 *
 *      Ut: Inget.
 *
 *      FV:  Noll eller strre => Vyns plats i vytab.
 *           -1 => Vyn finns ej.
 *
 *      (C)microform ab 21/12/94 J. Kjellander
 *
 ******************************************************!*/

  {
   int i;
/*
***Vyer med namnet "" (tom strng) fr ej finnas i vytab.
*/
   if ( vynamn[0] == '\0' ) return(-1);
/*
***Sk igenom hela vytab.
*/
   for ( i=0; i<GPMAXV; ++i)
     if ( strcmp(vynamn,vytab[i].vynamn) == 0 ) return(i);
  
   return(-1);
  }

/********************************************************/
/*!******************************************************/

  static void drwarr(
         WPGWIN *gwinpt,
         GC      arr_gc,
         int     ix1,
         int     iy1,
         int     ix2,
         int     iy2)

/*      Ritar/suddar gummibands-pil.
 *
 *      In:  gwinpt = C-pekare till grafiskt fnster.
 *           arr_gc = GC fr pilspets.
 *           ix1    = X-koordinat 1.
 *           iy1    = Y-koordinat 1.
 *           ix2    = X-koordinat 2.
 *           iy2    = Y-koordinat 2.
 *
 *      Ut:  Inget.
 *
 *      (C)microform ab 4/1/95 J. Kjellander
 *
 ******************************************************!*/

  {
   int    dx,dy;
   double alfa,cosalf,sinalf;

/*
***Berkna vinkeln mellan gummibandslinjen och positiva
***X-axeln.
*/
   dx = ix2 - ix1;
   dy = iy2 - iy1;

   if ( dx == 0  &&  dy > 0 ) alfa = PI05;
   else if ( dx == 0 ) alfa = -PI05;
   else
     {
     if ( dx > 0 )
       {
       if ( dy >= 0 ) alfa =  ATAN((double)dy/(double)dx);
       else           alfa = -ATAN((double)-dy/(double)dx);
       }
     else
       {
       if ( dy >= 0 ) alfa = PI - ATAN((double)dy/(double)-dx);
       else           alfa = ATAN((double)-dy/(double)-dx) - PI;
       }
     }
/*
***Rita sjlva pilen.
*/
    XDrawLine(xdisp,gwinpt->id.x_id,gwinpt->rub_gc,
                                     ix1,iy1,ix2,iy2);
/*
***Pilspetsen
*/
    cosalf = cos(alfa);
    sinalf = sin(alfa);

    dx = (int)(-25.0*cosalf + 10.0*sinalf);
    dy = (int)(-10.0*cosalf - 25.0*sinalf);

    XDrawLine(xdisp,gwinpt->id.x_id,arr_gc,
                                     ix2,iy2,ix2+dx,iy2+dy);

    dx = (int)(-25.0*cosalf - 10.0*sinalf);
    dy = (int)( 10.0*cosalf - 25.0*sinalf);

    XDrawLine(xdisp,gwinpt->id.x_id,arr_gc,
                                     ix2,iy2,ix2+dx,iy2+dy);

    XFlush(xdisp);
  }

/********************************************************/
