/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

void do_not_optimize_here(void *p)
{
    /* stop GCC optimization - avoid bugs in it */
}

#ifdef LEAK_DEBUG
long mem_amount = 0;
long last_mem_amount = -1;
#ifdef LEAK_DEBUG_LIST
struct list_head memory_list = { &memory_list, &memory_list };
#endif
#endif

static inline void force_dump(void)
{
    fprintf(stderr, "\n\033[1m%s\033[0m\n", "Forcing core dump");
    fflush(stderr);
    raise(SIGSEGV);
}

void check_memory_leaks()
{
#ifdef LEAK_DEBUG
    if (mem_amount) {
        fprintf(stderr, "\n\033[1mMemory leak by %ld bytes\033[0m\n", mem_amount);
#ifdef LEAK_DEBUG_LIST
        fprintf(stderr, "\nList of blocks: ");
        {
            int r = 0;
            struct alloc_header *ah;
            foreach (ah, memory_list) {
                fprintf(stderr, "%s%p:%d @ %s:%d", r ? ", ": "", (char *)ah + L_D_S, ah->size, ah->file, ah->line), r = 1;
                if (ah->comment) fprintf(stderr, ":\"%s\"", ah->comment);
            }
            fprintf(stderr, "\n");
        }
#endif
        force_dump();
    }
#endif
}

void er(int b, char *m, va_list l)
{
    if (b) fprintf(stderr, "%c", (char)7);
    vfprintf(stderr, m, l);
    fprintf(stderr, "\n");
    sleep(1);
}

void error(char *m, ...)
{
    va_list l;
    va_start(l, m);
    er(1, m, l);
}

int errline;
char *errfile;

char errbuf[4096];

void int_error(char *m, ...)
{
    va_list l;
    va_start(l, m);
    sprintf(errbuf, "\033[1mINTERNAL ERROR\033[0m at %s:%d: ", errfile, errline);
    strcat(errbuf, m);
    er(1, errbuf, l);
    force_dump();
}

void debug_msg(char *m, ...)
{
    va_list l;
    va_start(l, m);
    sprintf(errbuf, "DEBUG MESSAGE at %s:%d: ", errfile, errline);
    strcat(errbuf, m);
    er(0, errbuf, l);
}

int debug_type=0;
char *debug_filename=NULL;
FILE *debug_file=NULL;

void init_debug(){
    switch (debug_type){
        case 1:
            debug_file=fopen(debug_filename, "at");
            break;
        case 2:
            debug_file=stderr;
            break;    
    }
}

void free_debug(){
    if (!debug_file) return;
    if (debug_file!=stderr) fclose(debug_file);
}

void dbg(char *m, ...)
{
    va_list l;

    if (!debug_file) return;
    va_start(l, m);
    vfprintf(debug_file, m, l);
    va_end(l);
    fsync(fileno(debug_file));
}

void dbg_bcast(char *m, ...)
{
    va_list l;
    gchar *c;

    if (!cfg || !cfg->trace_bcast) return;
    va_start(l, m);
    c=g_strdup_vprintf(m, l);
    va_end(l);
    
    dbg("%s",c);
    log_adds(c);

    g_free(c);
}

void dbg_sock(char *m, ...)
{
    va_list l;
    gchar *c;

    if (!cfg || !cfg->trace_sock) return;
    va_start(l, m);
    c=g_strdup_vprintf(m, l);
    va_end(l);
    
    dbg("%s",c);
    log_adds(c);

    g_free(c);
}

void dbg_recv(char *m, ...)
{
    va_list l;
    gchar *c;

    if (!cfg || !cfg->trace_recv) return;
    va_start(l, m);
    c=g_strdup_vprintf(m, l);
    va_end(l);
    
    dbg("%s",c);
    log_adds(c);

    g_free(c);
}

void dbg_send(char *m, ...)
{
    va_list l;
    gchar *c;

    if (!cfg || !cfg->trace_send) return;
    va_start(l, m);
    c=g_strdup_vprintf(m, l);
    va_end(l);
    
    dbg("%s",c);
    log_adds(c);

    g_free(c);
}

void dbg_qsos(char *m, ...)
{
    va_list l;
    gchar *c;

    if (!cfg || !cfg->trace_qsos) return;
    va_start(l, m);
    c=g_strdup_vprintf(m, l);
    va_end(l);
    
    dbg("%s\n",c);
#if 0    
    log_adds(c);
#else
    if (ctest && ctest->logfile){
        fprintf(ctest->logfile, "%s\n", c);
    }
#endif

    g_free(c);
}




void print_str_hash(gpointer key, gpointer value, gpointer data){
    dbg("\tkey='%s' \tvalue='%s'\n", key, value);
}

void dbg_str_hash(GHashTable *hash){
    g_hash_table_foreach(hash, print_str_hash, NULL);
}

#ifdef LEAK_DEBUG

void *debug_mem_alloc(char *file, int line, size_t size)
{
    void *p;
#ifdef LEAK_DEBUG
    struct alloc_header *ah;
#endif
    if (!size) return DUMMY;
#ifdef LEAK_DEBUG
    mem_amount += size;
    size += L_D_S;
#endif
    if (!(p = xmalloc(size))) {
        error("ERROR: out of memory (malloc returned NULL)\n");
        return NULL;
    }
#ifdef LEAK_DEBUG
    ah = p;
    p = (char *)p + L_D_S;
    ah->size = size - L_D_S;
#ifdef LEAK_DEBUG_LIST
    ah->file = file;
    ah->line = line;
    ah->comment = NULL;
    add_to_list(memory_list, ah);
#endif
#endif
    return p;
}

void debug_mem_free(char *file, int line, void *p)
{
#ifdef LEAK_DEBUG
    struct alloc_header *ah;
#endif
    if (p == DUMMY) return;
    if (!p) {
        errfile = file, errline = line, int_error("mem_free(NULL)");
        return;
    }
#ifdef LEAK_DEBUG
    p = (char *)p - L_D_S;
    ah = p;
#ifdef LEAK_DEBUG_LIST
    del_from_list(ah);
    if (ah->comment) free(ah->comment);
#endif
    mem_amount -= ah->size;
#endif
    xfree(p);
}

void *debug_mem_realloc(char *file, int line, void *p, size_t size)
{
#ifdef LEAK_DEBUG
    struct alloc_header *ah;
#endif
    if (p == DUMMY) return debug_mem_alloc(file, line, size);
    if (!p) {
        errfile = file, errline = line, int_error("mem_realloc(NULL, %d)", size);
        return NULL;
    }
    if (!size) {
        debug_mem_free(file, line, p);
        return DUMMY;
    }
    if (!(p = xrealloc((char *)p - L_D_S, size + L_D_S))) {
        error("ERROR: out of memory (realloc returned NULL)\n");
        return NULL;
    }
#ifdef LEAK_DEBUG
    ah = p;
    mem_amount += size - ah->size;
    ah->size = size;
#ifdef LEAK_DEBUG_LIST
    ah->prev->next = ah;
    ah->next->prev = ah;
#endif
#endif
    return (char *)p + L_D_S;
}

void set_mem_comment(void *p, char *c, int l)
{
#ifdef LEAK_DEBUG_LIST
    struct alloc_header *ah = (struct alloc_header *)((char *)p - L_D_S);
    if (ah->comment) free(ah->comment);
    if ((ah->comment = malloc(l + 1))) memcpy(ah->comment, c, l), ah->comment[l] = 0;
#endif
}

#endif


void sock_debug(int sock, char *m, ...){

    va_list l;
    FILE *f;

    return;
    
    f = fopen("tucnak.sockdbg", "at");
    if (!f) return;

    va_start(l, m);
    fprintf(f, "%5d: socket %3d ", getpid(), sock);
    vfprintf(f, m, l);
    fprintf(f,"\n");
    va_end(l);
    fclose(f);
}

