<?cs include "header.cs" ?>
<?cs include "macros.cs" ?>

<div id="ctxtnav" class="nav">
 <h2>Wiki ナビゲーション</h2>
 <ul><?cs
  if:wiki.action == "diff" ?>
   <li class="first"><?cs
     if:len(chrome.links.prev) ?> &larr;
      <a class="prev" href="<?cs var:chrome.links.prev.0.href ?>" title="<?cs
       var:chrome.links.prev.0.title ?>">前の更新</a><?cs
     else ?>
      <span class="missing">&larr; 前の更新</span><?cs
     /if ?>
   </li>
   <li><a href="<?cs var:wiki.history_href ?>">ページ履歴</a></li>
   <li class="last"><?cs
     if:len(chrome.links.next) ?>
      <a class="next" href="<?cs var:chrome.links.next.0.href ?>" title="<?cs
       var:chrome.links.next.0.title ?>">後の更新</a> &rarr; <?cs
     else ?>
      <span class="missing">後の更新 &rarr;</span><?cs
     /if ?>
   </li><?cs
  elif:wiki.action == "history" ?>
   <li class="last"><a href="<?cs var:wiki.current_href ?>">最新のバージョンを見る</a></li><?cs
  else ?>
   <li><a href="<?cs var:trac.href.wiki ?>">スタートページ</a></li>
   <li><a href="<?cs var:trac.href.wiki ?>/TitleIndex">ページ一覧</a></li>
   <li><a href="<?cs var:trac.href.wiki ?>/RecentChanges">最近更新されたページ</a></li>
   <li class="last"><a href="<?cs var:wiki.last_change_href ?>">このページの最終更新</a></li><?cs
  /if ?>
 </ul>
 <hr />
</div>

<div id="content" class="wiki">

 <?cs if wiki.action == "delete" ?><?cs
  if:wiki.version - wiki.old_version > 1 ?><?cs
   set:first_version = wiki.old_version + 1 ?><?cs
   set:version_range = "のバージョン "+first_version+" から "+wiki.version+"" ?><?cs
   set:delete_what = "指定した範囲のバージョン" ?><?cs
  elif:wiki.version ?><?cs
   set:version_range = "のバージョン "+wiki.version+" " ?><?cs
   set:delete_what = "このバージョン" ?><?cs
  else ?><?cs
   set:version_range = "" ?><?cs
   set:delete_what = "ページ" ?><?cs
  /if ?>
  <h1><a href="<?cs
    var:wiki.current_href ?>"><?cs var:wiki.page_name ?> </a><?cs var:version_range ?> を削除</h1>
  <form action="<?cs var:wiki.current_href ?>" method="post">
   <input type="hidden" name="action" value="delete" />
   <p><strong><?cs
    if:!?wiki.version ?><?cs
    /if ?>このページ<?cs var:version_range ?>を完全に削除しますか?</strong><br /><?cs
   if:wiki.only_version ?>
    このページには1つのバージョンしかありませんのでページを完全に削除します!
    <?cs
   /if ?><?cs
   if:?wiki.version ?>
    <input type="hidden" name="version" value="<?cs var:wiki.version ?>" /><?cs
   /if ?><?cs
   if:wiki.old_version ?>
    <input type="hidden" name="old_version" value="<?cs var:wiki.old_version ?>" /><?cs
   /if ?>
   削除すると元に戻すことができません。</p>
   <div class="buttons">
    <input type="submit" name="cancel" value="取り消し" />
    <input type="submit" value="<?cs var:delete_what ?> を削除" />
   </div>
  </form>

 <?cs elif:wiki.action == "diff" ?>
  <h1><a href="<?cs var:wiki.current_href ?>"><?cs var:wiki.page_name ?></a>:<?cs
    if:wiki.old_version ?>
     <a href="<?cs var:wiki.current_href ?>?version=<?cs var:wiki.old_version?>"> バージョン <?cs var:wiki.old_version?></a> と<?cs
    else ?><?cs
    /if ?>
    <a href="<?cs var:wiki.current_href ?>?version=<?cs var:wiki.version?>"> バージョン <?cs var:wiki.version?></a>
    における更新</h1>
  <form method="post" id="prefs" action="<?cs var:wiki.current_href ?>">
   <div>
    <input type="hidden" name="action" value="diff" />
    <input type="hidden" name="version" value="<?cs var:wiki.version ?>" />
    <input type="hidden" name="old_version" value="<?cs var:wiki.old_version ?>" />
    <label>変更箇所を見る <select name="style">
     <option value="inline"<?cs
       if:diff.style == 'inline' ?> selected="selected"<?cs
       /if ?>>インライン</option>
     <option value="sidebyside"<?cs
       if:diff.style == 'sidebyside' ?> selected="selected"<?cs
       /if ?>>並べて表示</option>
    </select></label>
    <div class="field">
     差分発生行の前後 <input type="text" name="contextlines" id="contextlines" size="2"
       maxlength="3" value="<?cs var:diff.options.contextlines ?>" />
     <label for="contextlines"> 行を表示</label>
    </div>
    <fieldset id="ignore">
     <legend>無視リスト:</legend>
     <div class="field">
      <input type="checkbox" id="blanklines" name="ignoreblanklines"<?cs
        if:diff.options.ignoreblanklines ?> checked="checked"<?cs /if ?> />
      <label for="blanklines">空行</label>
     </div>
     <div class="field">
      <input type="checkbox" id="case" name="ignorecase"<?cs
        if:diff.options.ignorecase ?> checked="checked"<?cs /if ?> />
      <label for="case">大文字小文字の変更</label>
     </div>
     <div class="field">
      <input type="checkbox" id="whitespace" name="ignorewhitespace"<?cs
        if:diff.options.ignorewhitespace ?> checked="checked"<?cs /if ?> />
      <label for="whitespace">空白文字の変更</label>
     </div>
    </fieldset>
    <div class="buttons">
     <input type="submit" name="update" value="更新" />
    </div>
   </div>
  </form>
  <dl id="overview">
   <dt class="property author">更新者:</dt>
   <dd class="author"><?cs
    if:wiki.num_changes > 1 ?><em class="multi">(複数のバージョン間の更新)</em><?cs
    else ?><?cs var:wiki.author ?> <span class="ipnr">(IPアドレス: <?cs
     var:wiki.ipnr ?>)</span><?cs
    /if ?></dd>
   <dt class="property time">更新日時:</dt>
   <dd class="time"><?cs
    if:wiki.num_changes > 1 ?><em class="multi">(複数のバージョン間の更新)</em><?cs
    elif:wiki.time ?><?cs var:wiki.time ?> (<?cs var:wiki.time_delta ?>前)<?cs
    else ?>--<?cs
    /if ?></dd>
   <dt class="property message">コメント:</dt>
   <dd class="message"><?cs
    if:wiki.num_changes > 1 ?><em class="multi">(複数のバージョン間の更新)</em><?cs
    else ?><?cs var:wiki.comment ?><?cs /if ?></dd>
  </dl>
  <div class="diff">
   <div id="legend">
    <h3>凡例:</h3>
    <dl>
     <dt class="unmod"></dt><dd>変更無し</dd>
     <dt class="add"></dt><dd>追加</dd>
     <dt class="rem"></dt><dd>削除</dd>
     <dt class="mod"></dt><dd>更新</dd>
    </dl>
   </div>
   <ul class="entries">
    <li class="entry">
     <h2><?cs var:wiki.page_name ?></h2><?cs
      if:diff.style == 'sidebyside' ?>
      <table class="sidebyside" summary="Differences">
       <colgroup class="l"><col class="lineno" /><col class="content" /></colgroup>
       <colgroup class="r"><col class="lineno" /><col class="content" /></colgroup>
       <thead><tr>
        <th colspan="2">バージョン <?cs var:wiki.old_version ?></th>
        <th colspan="2">バージョン <?cs var:wiki.version ?></th>
       </tr></thead><?cs
       each:change = wiki.diff ?><?cs
        call:diff_display(change, diff.style) ?><?cs
       /each ?>
      </table><?cs
     else ?>
      <table class="inline" summary="Differences">
       <colgroup><col class="lineno" /><col class="lineno" /><col class="content" /></colgroup>
       <thead><tr>
        <th title="バージョン <?cs var:wiki.old_version ?>">v<?cs
          alt:wiki.old_version ?>0<?cs /alt ?></th>
        <th title="バージョン <?cs var:wiki.version ?>">v<?cs
          var:wiki.version ?></th>
        <th>&nbsp;</th>
       </tr></thead><?cs
       each:change = wiki.diff ?><?cs
        call:diff_display(change, diff.style) ?><?cs
       /each ?>
      </table><?cs
     /if ?>
    </li>
   </ul><?cs
   if:trac.acl.WIKI_DELETE &&
    (len(wiki.diff) == 0 || wiki.version == wiki.latest_version) ?>
    <form method="get" action="<?cs var:wiki.current_href ?>">
     <input type="hidden" name="action" value="delete" />
     <input type="hidden" name="version" value="<?cs var:wiki.version ?>" />
     <input type="hidden" name="old_version" value="<?cs var:wiki.old_version ?>" />
     <input type="submit" name="delete_version" value="<?cs
     if:wiki.version - wiki.old_version > 1 ?> バージョン <?cs
      var:wiki.old_version+1 ?> から <?cs
     /if ?>バージョン <?cs var:wiki.version ?> を削除" />
    </form><?cs
   /if ?>
  </div>

 <?cs elif wiki.action == "history" ?>
  <h1><a href="<?cs var:wiki.current_href ?>"><?cs
    var:wiki.page_name ?></a> の更新履歴</h1>
  <?cs if:len(wiki.history) ?><form class="printableform" method="get" action="">
   <input type="hidden" name="action" value="diff" />
   <div class="buttons">
    <input type="submit" value="diff を表示" />
   </div>
   <table id="wikihist" class="listing" summary="Change history">
    <thead><tr>
     <th class="diff"></th>
     <th class="version">バージョン</th>
     <th class="date">更新日時</th>
     <th class="author">更新者</th>
     <th class="comment">コメント</th>
    </tr></thead>
    <tbody><?cs each:item = wiki.history ?>
     <tr class="<?cs if:name(item) % #2 ?>even<?cs else ?>odd<?cs /if ?>">
      <td class="diff"><input type="radio" name="old_version" value="<?cs
        var:item.version ?>"<?cs
        if:name(item) == 1 ?> checked="checked"<?cs
        /if ?> /> <input type="radio" name="version" value="<?cs
        var:item.version ?>"<?cs
        if:name(item) == 0 ?> checked="checked"<?cs
        /if ?> /></td>
      <td class="version"><a href="<?cs
        var:item.url ?>" title="このバージョンを表示する"><?cs
        var:item.version ?></a></td>
      <td class="date"><?cs var:item.time ?></td>
      <td class="author" title="IPアドレス: <?cs var:item.ipaddr ?>"><?cs
        var:item.author ?></td>
      <td class="comment"><?cs var:item.comment ?></td>
     </tr>
    <?cs /each ?></tbody>
   </table><?cs
   if:len(wiki.history) > #10 ?>
    <div class="buttons">
     <input type="submit" value="diff を表示" />
    </div><?cs
   /if ?>
  </form><?cs /if ?>

 <?cs else ?>
  <?cs if wiki.action == "edit" || wiki.action == "preview" || wiki.action == "collision" ?>
   <h1>"<?cs var:wiki.page_name ?>" を編集中です</h1><?cs
    if wiki.action == "preview" ?>
     <table id="info" summary="Revision info"><tbody><tr>
       <th scope="col">
        更新後のバージョン <?cs var:$wiki.version+1 ?> のプレビュー (更新者:<?cs var:wiki.author ?>)
       </th></tr><tr>
       <td class="message"><?cs var:wiki.comment_html ?></td>
      </tr>
     </tbody></table>
     <fieldset id="preview">
      <legend>プレビュー (<a href="#edit">編集領域に移動</a>)</legend>
        <div class="wikipage"><?cs var:wiki.page_html ?></div>
     </fieldset><?cs
     elif wiki.action =="collision"?>
     <div class="system-message">
       このページを編集中に、他のユーザがこのページを更新しました。
       今回の更新は保存できません。
     </div><?cs
    /if ?>
   <form id="edit" action="<?cs var:wiki.current_href ?>" method="post">
    <fieldset class="iefix">
     <input type="hidden" name="action" value="edit" />
     <input type="hidden" name="version" value="<?cs var:wiki.version ?>" />
     <input type="hidden" id="scroll_bar_pos" name="scroll_bar_pos" value="<?cs
       var:wiki.scroll_bar_pos ?>" />
     <div id="rows">
      <label for="editrows">編集領域の高さを変更:</label>
      <select size="1" name="editrows" id="editrows" tabindex="43"
        onchange="resizeTextArea('text', this.options[selectedIndex].value)"><?cs
       loop:rows = 8, 42, 4 ?>
        <option value="<?cs var:rows ?>"<?cs
          if:rows == wiki.edit_rows ?> selected="selected"<?cs /if ?>><?cs
          var:rows ?></option><?cs
       /loop ?>
      </select>
     </div>
     <p><textarea id="text" class="wikitext" name="text" cols="80" rows="<?cs
       var:wiki.edit_rows ?>">
<?cs var:wiki.page_source ?></textarea></p>
     <script type="text/javascript">
       var scrollBarPos = document.getElementById("scroll_bar_pos");
       var text = document.getElementById("text");
       addEvent(window, "load", function() {
         if (scrollBarPos.value) text.scrollTop = scrollBarPos.value;
       });
       addEvent(text, "blur", function() { scrollBarPos.value = text.scrollTop });
     </script>
    </fieldset>
    <div id="help">
     <b>Note:</b> Wikiページ編集のヘルプは <a href="<?cs var:$trac.href.wiki
?>/WikiFormatting">WikiFormatting</a> および <a href="<?cs var:$trac.href.wiki
?>/TracWiki">TracWiki</a> を参照してください。
    </div>
    <fieldset id="changeinfo">
     <legend>更新情報</legend>
     <?cs if:trac.authname == "anonymous" ?>
      <div class="field">
       <label>メールアドレスまたはユーザ名:<br />
       <input id="author" type="text" name="author" size="30" value="<?cs
         var:wiki.author ?>" /></label>
      </div>
     <?cs /if ?>
     <div class="field">
      <label>この更新についてのコメント (非必須):<br />
      <input id="comment" type="text" name="comment" size="60" value="<?cs
        var:wiki.comment?>" /></label>
     </div><br />
     <?cs if trac.acl.WIKI_ADMIN ?>
      <div class="options">
       <label><input type="checkbox" name="readonly" id="readonly" <?cs
         if wiki.readonly == "1"?>checked="checked"<?cs /if ?> />
       このページを読み込み専用にする</label>
      </div>
     <?cs /if ?>
    </fieldset>
    <div class="buttons"><?cs
     if wiki.action == "collision" ?>
      <input type="submit" name="preview" value="プレビュー" disabled="disabled" />&nbsp;
      <input type="submit" name="save" value="保存" disabled="disabled" />&nbsp;
     <?cs else ?>
      <input type="submit" name="preview" value="プレビュー" accesskey="r" />&nbsp;
      <input type="submit" name="save" value="保存" />&nbsp;
     <?cs /if ?>
     <input type="submit" name="cancel" value="取り消し" />
    </div>
    <script type="text/javascript" src="<?cs
      var:htdocs_location ?>js/wikitoolbar.js"></script>
   </form>
  <?cs /if ?>
  <?cs if wiki.action == "view" ?>
   <?cs if:wiki.comment_html ?>
    <table id="info" summary="Revision info"><tbody><tr>
      <th scope="col">
       バージョン <?cs var:wiki.version ?> (更新者: <?cs var:wiki.author ?>, 更新時期: <?cs var:wiki.age ?> 前)
      </th></tr><tr>
      <td class="message"><?cs var:wiki.comment_html ?></td>
     </tr>
    </tbody></table>
   <?cs /if ?>
   <div class="wikipage">
    <div id="searchable"><?cs var:wiki.page_html ?></div>
   </div>
   <?cs if:len(wiki.attachments) ?>
    <h3 id="tkt-changes-hdr">添付ファイル</h3>
    <ul class="tkt-chg-list"><?cs
     each:attachment = wiki.attachments ?><li class="tkt-chg-change"><a href="<?cs
      var:attachment.href ?>"><?cs
      var:attachment.filename ?></a> (<?cs var:attachment.size ?>) - <?cs
      if:attachment.description ?><q><?cs var:attachment.description ?></q><?cs
      /if ?> <?cs var:attachment.author ?> によって <?cs
      var:attachment.time ?> に登録されました。</li><?cs
     /each ?>
    </ul>
  <?cs /if ?>
  <?cs if wiki.action == "view" && (trac.acl.WIKI_MODIFY || trac.acl.WIKI_DELETE)
      && (wiki.readonly == "0" || trac.acl.WIKI_ADMIN) ?>
   <div class="buttons"><?cs
    if:trac.acl.WIKI_MODIFY ?>
     <form method="get" action="<?cs var:wiki.current_href ?>"><div>
      <input type="hidden" name="action" value="edit" />
      <input type="submit" value="このページを<?cs if:wiki.exists ?>編集<?cs
        else ?>作成<?cs /if ?>" accesskey="e" />
     </div></form><?cs
     if:wiki.exists ?>
      <form method="get" action="<?cs var:wiki.attach_href ?>"><div>
       <input type="hidden" name="action" value="new" />
       <input type="submit" value="このページにファイルを添付" />
      </div></form><?cs
     /if ?><?cs
    /if ?><?cs
    if:wiki.exists && trac.acl.WIKI_DELETE ?>
     <form method="get" action="<?cs var:wiki.current_href ?>"><div id="delete">
      <input type="hidden" name="action" value="delete" />
      <input type="hidden" name="version" value="<?cs var:wiki.version ?>" /><?cs
      if:wiki.version == wiki.latest_version ?>
       <input type="submit" name="delete_version" value="このバージョンを削除" /><?cs
      /if ?>
      <input type="submit" value="このページを削除" />
     </div></form>
    <?cs /if ?>
   </div>
  <?cs /if ?>
  <script type="text/javascript">
   addHeadingLinks(document.getElementById("searchable"), "このセクションにリンクする");
  </script>
 <?cs /if ?>
 <?cs /if ?>
</div>

<?cs include "footer.cs" ?>
