#include "tra.h"

/* Darwin/OS X does not have pread and pwrite
 * This solution is not completely general, but will do for now
 */
Lock plk;

ulong
pread(int fd, void *buf, ulong n, ulong off)
{
	ulong rv;

	lock(&plk);
	if(lseek(fd, off, 0) != off)
		return -1;
	rv = read(fd, buf, n);
	unlock(&plk);

	return rv;
}

ulong
pwrite(int fd, void *buf, ulong n, ulong off)
{
	ulong rv;

	lock(&plk);
	if(lseek(fd, off, 0) != off)
		return -1;
	rv = write(fd, buf, n);
	unlock(&plk);

	return rv;
}
