/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef INTERNMAT_SEEN
#define INTERNMAT_SEEN

static const double internmat[67][67] = 
{
    {79.2191, 71.1151, 59.4571, 48.6214, 35.0276, 23.2547, 12.4957,  3.2850,  1.4925,  0.8890, 
      0.5721,  0.6345,  0.2959,  0.0812,  0.1529,  0.0417, -0.0967, -0.0834, -0.2441, -0.2389, 
     -0.2433, -0.1048, -0.1083, -0.0301, -0.2070, -0.1652, -0.0922, -0.0831, -0.1101,  0.0158, 
     -0.1108, -0.3811, -0.5813, -0.5736, -0.5507, -0.1059, -0.1705,  0.0025,  0.0493,  0.0050, 
      0.0181, -0.0090, -0.0084, -0.1149, -0.4191, -0.2075, -0.1022, -0.0633, -0.0430,  0.1267, 
     -0.0610, -0.0383,  0.0438,  0.0684, -0.0874, -0.2115, -0.2362, -0.1175,  0.1850,  0.1712, 
     -0.0225,  0.0559,  0.2786,  0.4187,  0.2768,  0.6965,  2.9242},

    {71.1151, 67.9487, 57.7892, 47.8564, 34.7322, 22.8289, 12.0978,  3.2568,  1.3758,  0.9204, 
      0.5543,  0.6369,  0.2931,  0.0689,  0.1124,  0.0321, -0.1249, -0.1005, -0.2363, -0.2244, 
     -0.2526, -0.1296, -0.1166, -0.0449, -0.2292, -0.1729, -0.1235, -0.1143, -0.1596, -0.0383, 
     -0.1104, -0.3373, -0.5058, -0.5594, -0.5784, -0.1570, -0.1968, -0.0303,  0.0200, -0.0268, 
     -0.0084, -0.0359, -0.0608, -0.1079, -0.3362, -0.1938, -0.1255, -0.0738, -0.0303,  0.1095, 
     -0.0584, -0.0331,  0.0716,  0.1012, -0.0574, -0.1756, -0.1814, -0.0814,  0.1919,  0.2233, 
      0.0388,  0.0881,  0.3006,  0.4461,  0.3445,  0.6895,  2.0968},

    {59.4571, 57.7892, 52.3552, 43.9720, 32.6649, 21.6816, 11.5427,  3.2326,  1.3264,  0.8858, 
      0.5210,  0.5191,  0.2232,  0.0310,  0.0499, -0.0023, -0.1305, -0.0915, -0.2010, -0.1905, 
     -0.2308, -0.1442, -0.1316, -0.0835, -0.2172, -0.1533, -0.1205, -0.1253, -0.1419, -0.0855, 
     -0.1478, -0.3585, -0.4442, -0.4520, -0.4458, -0.1376, -0.1603, -0.0336,  0.0227, -0.0345, 
     -0.0149, -0.0236, -0.0548, -0.0483, -0.3522, -0.1701, -0.1193, -0.0667, -0.0310,  0.0780, 
     -0.0507, -0.0355,  0.0556,  0.0872, -0.0493, -0.1657, -0.1424, -0.0619,  0.1879,  0.2565, 
      0.0784,  0.0963,  0.3236,  0.4393,  0.3120,  0.6361,  1.1163},

    {48.6214, 47.8564, 43.9720, 40.2352, 30.7105, 20.8689, 11.2152,  3.2036,  1.3567,  1.0015, 
      0.6363,  0.6164,  0.2804,  0.0951,  0.0682,  0.0497, -0.0956, -0.0793, -0.1979, -0.2158, 
     -0.2813, -0.1500, -0.1511, -0.1600, -0.2362, -0.1509, -0.1264, -0.1562, -0.2283, -0.2249, 
     -0.3308, -0.5694, -0.6545, -0.5749, -0.4824, -0.1947, -0.1672, -0.0102,  0.0371, -0.0416, 
     -0.0325, -0.0398, -0.0753, -0.0645, -0.1293, -0.1563, -0.1058, -0.0579, -0.0072,  0.1146, 
     -0.0214,  0.0123,  0.1039,  0.1430, -0.0274, -0.1716, -0.1556, -0.0686,  0.2052,  0.2969, 
      0.0996,  0.1188,  0.3756,  0.4682,  0.2842,  0.6217,  0.5801},

    {35.0276, 34.7322, 32.6649, 30.7105, 25.9918, 17.9661,  9.5073,  2.5402,  1.0804,  0.8612, 
      0.5943,  0.5671,  0.2594,  0.1137,  0.0719,  0.0418, -0.0805, -0.0780, -0.1747, -0.2031, 
     -0.2852, -0.1576, -0.1427, -0.1415, -0.1816, -0.0940, -0.0840, -0.1075, -0.1911, -0.2126, 
     -0.3719, -0.6285, -0.6760, -0.5435, -0.4409, -0.1425, -0.1067,  0.0275,  0.0664, -0.0076, 
     -0.0015, -0.0094, -0.0576, -0.0526, -0.1089, -0.1137, -0.0314, -0.0009,  0.0382,  0.1229, 
      0.0098,  0.0404,  0.1183,  0.1471, -0.0085, -0.1404, -0.1363, -0.0502,  0.1825,  0.2423, 
      0.0864,  0.1292,  0.3279,  0.3160,  0.1905,  0.4815,  0.2387},

    {23.2547, 22.8289, 21.6816, 20.8689, 17.9661, 14.7236,  8.0114,  1.9656,  0.8859,  0.6234, 
      0.4581,  0.4476,  0.2030,  0.0978,  0.0519,  0.0394,  0.0016, -0.0413, -0.1279, -0.1670, 
     -0.2414, -0.1282, -0.1144, -0.1273, -0.1335, -0.0618, -0.0444, -0.0905, -0.1475, -0.2602, 
     -0.3922, -0.6654, -0.6233, -0.4169, -0.3290, -0.1698, -0.0903,  0.0346,  0.0591, -0.0075, 
     -0.0148, -0.0151, -0.0762, -0.0858, -0.0286, -0.1340, -0.0335, -0.0108,  0.0155,  0.0939, 
      0.0101,  0.0483,  0.1173,  0.1347,  0.0135, -0.0988, -0.1103, -0.0389,  0.1285,  0.2213, 
      0.1216,  0.1408,  0.3129,  0.3359,  0.2473,  0.4354,  0.8689},

    {12.4957, 12.0978, 11.5427, 11.2152,  9.5073,  8.0114,  5.7138,  1.3597,  0.6543,  0.3559, 
      0.2448,  0.2724,  0.1155,  0.0657,  0.0471,  0.0776,  0.0599,  0.0306, -0.0246, -0.0739, 
     -0.0985, -0.0244, -0.0506, -0.1128, -0.0834, -0.0383, -0.0488, -0.0736, -0.0977, -0.1397, 
     -0.1996, -0.3345, -0.3486, -0.2145, -0.1061, -0.1304, -0.0909, -0.0121, -0.0086, -0.0479, 
     -0.0509, -0.0347, -0.0719, -0.0730,  0.0266, -0.0880, -0.0538, -0.0569, -0.0419,  0.0265, 
     -0.0070,  0.0324,  0.0768,  0.0997,  0.0367, -0.0172, -0.0375, -0.0129,  0.0441,  0.0956, 
      0.0576,  0.0421,  0.1070,  0.1040,  0.0580,  0.1661,  0.4481},

    { 3.2850,  3.2568,  3.2326,  3.2036,  2.5402,  1.9656,  1.3597,  0.8293,  0.3744,  0.1882, 
      0.0907,  0.0608,  0.0271,  0.0004, -0.0141,  0.0075, -0.0045, -0.0041, -0.0123, -0.0254, 
     -0.0229, -0.0128, -0.0278, -0.0399, -0.0354, -0.0302, -0.0468, -0.0513, -0.0359, -0.0521, 
     -0.0412, -0.0690, -0.0580, -0.0572, -0.0487, -0.0840, -0.0607, -0.0252, -0.0194, -0.0297, 
     -0.0253, -0.0182, -0.0185, -0.0140, -0.0375, -0.0235, -0.0249, -0.0359, -0.0251, -0.0071, 
     -0.0113,  0.0009,  0.0183,  0.0271,  0.0085, -0.0101, -0.0139, -0.0081,  0.0216,  0.0509, 
      0.0291,  0.0150,  0.0512,  0.0922,  0.0440,  0.0656,  0.0211},

    { 1.4925,  1.3758,  1.3264,  1.3567,  1.0804,  0.8859,  0.6543,  0.3744,  0.2617,  0.1054, 
      0.0605,  0.0450,  0.0241,  0.0072, -0.0038,  0.0039,  0.0054,  0.0032, -0.0059, -0.0166, 
     -0.0156, -0.0062, -0.0135, -0.0243, -0.0176, -0.0143, -0.0238, -0.0240, -0.0239, -0.0301, 
     -0.0340, -0.0507, -0.0573, -0.0488, -0.0357, -0.0369, -0.0300, -0.0097, -0.0075, -0.0135, 
     -0.0119, -0.0078, -0.0096, -0.0085, -0.0156, -0.0090, -0.0040, -0.0127, -0.0094, -0.0016, 
     -0.0039,  0.0028,  0.0094,  0.0135,  0.0049, -0.0055, -0.0118, -0.0074,  0.0051,  0.0199, 
      0.0121,  0.0048,  0.0219,  0.0477,  0.0269,  0.0260,  0.0175},

    { 0.8890,  0.9204,  0.8858,  1.0015,  0.8612,  0.6234,  0.3559,  0.1882,  0.1054,  0.1545, 
      0.0675,  0.0481,  0.0169,  0.0060, -0.0092,  0.0018, -0.0039, -0.0044, -0.0089, -0.0123, 
     -0.0156, -0.0097, -0.0109, -0.0199, -0.0105, -0.0074, -0.0116, -0.0157, -0.0276, -0.0383, 
     -0.0272, -0.0442, -0.0408, -0.0478, -0.0627, -0.0233, -0.0092,  0.0017,  0.0021, -0.0034, 
     -0.0054, -0.0085, -0.0098, -0.0109, -0.0127, -0.0065, -0.0026, -0.0043, -0.0025,  0.0056, 
      0.0017,  0.0065,  0.0129,  0.0118,  0.0014, -0.0049, -0.0063, -0.0013,  0.0165,  0.0222, 
      0.0104,  0.0121,  0.0307,  0.0354,  0.0172,  0.0261, -0.0113},

    { 0.5721,  0.5543,  0.5210,  0.6363,  0.5943,  0.4581,  0.2448,  0.0907,  0.0605,  0.0675, 
      0.1016,  0.0589,  0.0262,  0.0115, -0.0000,  0.0037,  0.0018, -0.0015, -0.0083, -0.0114, 
     -0.0162, -0.0089, -0.0076, -0.0133, -0.0056, -0.0012, -0.0012, -0.0040, -0.0123, -0.0300, 
     -0.0331, -0.0546, -0.0563, -0.0479, -0.0485, -0.0068,  0.0029,  0.0089,  0.0083,  0.0018, 
     -0.0000, -0.0028, -0.0063, -0.0087, -0.0003, -0.0032,  0.0036,  0.0028,  0.0031,  0.0077, 
      0.0031,  0.0061,  0.0098,  0.0083, -0.0008, -0.0076, -0.0097, -0.0047,  0.0066,  0.0088, 
      0.0031,  0.0061,  0.0165,  0.0210,  0.0053,  0.0088,  0.0076},

    { 0.6345,  0.6369,  0.5191,  0.6164,  0.5671,  0.4476,  0.2724,  0.0608,  0.0450,  0.0481, 
      0.0589,  0.1517,  0.0483,  0.0221,  0.0091,  0.0058,  0.0061,  0.0030, -0.0068, -0.0109, 
     -0.0174, -0.0078, -0.0052, -0.0087, -0.0088, -0.0017,  0.0010, -0.0055, -0.0210, -0.0388, 
     -0.0425, -0.0685, -0.0746, -0.0530, -0.0468, -0.0145, -0.0044,  0.0028,  0.0041, -0.0004, 
     -0.0020, -0.0046, -0.0119, -0.0186,  0.0177, -0.0087,  0.0014,  0.0034,  0.0063,  0.0096, 
      0.0022,  0.0071,  0.0112,  0.0120,  0.0030, -0.0045, -0.0092, -0.0046,  0.0047,  0.0081, 
      0.0036,  0.0045,  0.0138,  0.0200, -0.0016, -0.0041,  0.0502},

    { 0.2959,  0.2931,  0.2232,  0.2804,  0.2594,  0.2030,  0.1155,  0.0271,  0.0241,  0.0169, 
      0.0262,  0.0483,  0.0891,  0.0268,  0.0195,  0.0125,  0.0066,  0.0054, -0.0032, -0.0092, 
     -0.0125, -0.0048, -0.0038, -0.0061, -0.0025,  0.0011,  0.0059,  0.0026, -0.0092, -0.0159, 
     -0.0344, -0.0512, -0.0641, -0.0502, -0.0380, -0.0068, -0.0063,  0.0054,  0.0068,  0.0031, 
      0.0014, -0.0016, -0.0065, -0.0089, -0.0020, -0.0032,  0.0043,  0.0061,  0.0085,  0.0129, 
      0.0055,  0.0111,  0.0120,  0.0158,  0.0080,  0.0008, -0.0078, -0.0039,  0.0012, -0.0020, 
     -0.0029,  0.0016,  0.0029,  0.0068, -0.0002,  0.0027,  0.0360},

    { 0.0812,  0.0689,  0.0310,  0.0951,  0.1137,  0.0978,  0.0657,  0.0004,  0.0072,  0.0060, 
      0.0115,  0.0221,  0.0268,  0.0620,  0.0217,  0.0136,  0.0076,  0.0057, -0.0017, -0.0077, 
     -0.0109, -0.0034, -0.0028, -0.0055, -0.0015,  0.0015,  0.0040,  0.0011, -0.0096, -0.0127, 
     -0.0255, -0.0370, -0.0469, -0.0343, -0.0214, -0.0053, -0.0036,  0.0051,  0.0070,  0.0034, 
      0.0013, -0.0009, -0.0047, -0.0055, -0.0012, -0.0005,  0.0033,  0.0044,  0.0069,  0.0124, 
      0.0060,  0.0113,  0.0118,  0.0131,  0.0067,  0.0011, -0.0052, -0.0020,  0.0001, -0.0021, 
     -0.0011,  0.0023,  0.0032,  0.0025,  0.0013,  0.0045,  0.0223},

    { 0.1529,  0.1124,  0.0499,  0.0682,  0.0719,  0.0519,  0.0471, -0.0141, -0.0038, -0.0092, 
     -0.0000,  0.0091,  0.0195,  0.0217,  0.0696,  0.0153,  0.0073,  0.0057, -0.0011, -0.0072, 
     -0.0091, -0.0020, -0.0032, -0.0059, -0.0019,  0.0009,  0.0044,  0.0045, -0.0021, -0.0025, 
     -0.0154, -0.0238, -0.0347, -0.0244, -0.0106,  0.0011, -0.0005,  0.0045,  0.0062,  0.0020, 
      0.0001, -0.0012, -0.0029, -0.0039,  0.0010,  0.0016,  0.0014,  0.0025,  0.0045,  0.0106, 
      0.0036,  0.0077,  0.0062,  0.0096,  0.0055,  0.0005, -0.0048, -0.0031, -0.0014, -0.0035, 
     -0.0030, -0.0007, -0.0006, -0.0016, -0.0029,  0.0033,  0.0422},

    { 0.0417,  0.0321, -0.0023,  0.0497,  0.0418,  0.0394,  0.0776,  0.0075,  0.0039,  0.0018, 
      0.0037,  0.0058,  0.0125,  0.0136,  0.0153,  0.0653,  0.0140,  0.0093,  0.0028, -0.0033, 
     -0.0044,  0.0007, -0.0021, -0.0092, -0.0043, -0.0015, -0.0021, -0.0010, -0.0081, -0.0061, 
     -0.0128, -0.0160, -0.0272, -0.0188, -0.0066, -0.0032, -0.0025,  0.0025,  0.0020, -0.0010, 
     -0.0029, -0.0027, -0.0049,  0.0011, -0.0014, -0.0023, -0.0018, -0.0006,  0.0011,  0.0068, 
      0.0048,  0.0102,  0.0094,  0.0122,  0.0085,  0.0054, -0.0002,  0.0012, -0.0013, -0.0035, 
     -0.0014, -0.0013, -0.0040, -0.0051, -0.0072, -0.0109, -0.0196},

    {-0.0967, -0.1249, -0.1305, -0.0956, -0.0805,  0.0016,  0.0599, -0.0045,  0.0054, -0.0039, 
      0.0018,  0.0061,  0.0066,  0.0076,  0.0073,  0.0140,  0.0754,  0.0191,  0.0126,  0.0019, 
      0.0037,  0.0050, -0.0003, -0.0085, -0.0013,  0.0015,  0.0055,  0.0030, -0.0018,  0.0054, 
      0.0009,  0.0029, -0.0112, -0.0155, -0.0105, -0.0011, -0.0011,  0.0012, -0.0007, -0.0019, 
     -0.0032,  0.0002, -0.0051, -0.0005, -0.0042, -0.0071, -0.0045, -0.0027, -0.0024,  0.0001, 
      0.0017,  0.0053,  0.0036,  0.0039,  0.0071,  0.0082,  0.0031, -0.0020, -0.0090, -0.0080, 
     -0.0052, -0.0108, -0.0154, -0.0105, -0.0129, -0.0197, -0.0710},

    {-0.0834, -0.1005, -0.0915, -0.0793, -0.0780, -0.0413,  0.0306, -0.0041,  0.0032, -0.0044, 
     -0.0015,  0.0030,  0.0054,  0.0057,  0.0057,  0.0093,  0.0191,  0.0556,  0.0122,  0.0045, 
      0.0059,  0.0064,  0.0021, -0.0052, -0.0011,  0.0008,  0.0006,  0.0014,  0.0014,  0.0076, 
      0.0039,  0.0064, -0.0071, -0.0093, -0.0036, -0.0011, -0.0018, -0.0004, -0.0032, -0.0033, 
     -0.0041, -0.0007, -0.0029,  0.0010, -0.0059, -0.0077, -0.0066, -0.0055, -0.0040, -0.0013, 
      0.0012,  0.0046,  0.0041,  0.0069,  0.0083,  0.0088,  0.0040,  0.0010, -0.0050, -0.0075, 
     -0.0052, -0.0084, -0.0138, -0.0123, -0.0125, -0.0231, -0.0579},

    {-0.2441, -0.2363, -0.2010, -0.1979, -0.1747, -0.1279, -0.0246, -0.0123, -0.0059, -0.0089, 
     -0.0083, -0.0068, -0.0032, -0.0017, -0.0011,  0.0028,  0.0126,  0.0122,  0.0528,  0.0092, 
      0.0121,  0.0085,  0.0035, -0.0033, -0.0001,  0.0002, -0.0013,  0.0003,  0.0045,  0.0123, 
      0.0146,  0.0232,  0.0149,  0.0070,  0.0070,  0.0007, -0.0005, -0.0030, -0.0060, -0.0048, 
     -0.0051, -0.0010, -0.0009,  0.0012, -0.0029, -0.0064, -0.0078, -0.0076, -0.0066, -0.0059, 
     -0.0007,  0.0008,  0.0002,  0.0027,  0.0065,  0.0100,  0.0079,  0.0032, -0.0057, -0.0083, 
     -0.0050, -0.0095, -0.0174, -0.0165, -0.0156, -0.0269, -0.0795},

    {-0.2389, -0.2244, -0.1905, -0.2158, -0.2031, -0.1670, -0.0739, -0.0254, -0.0166, -0.0123, 
     -0.0114, -0.0109, -0.0092, -0.0077, -0.0072, -0.0033,  0.0019,  0.0045,  0.0092,  0.0507, 
      0.0137,  0.0074,  0.0052,  0.0025,  0.0021,  0.0009, -0.0020, -0.0000,  0.0056,  0.0110, 
      0.0187,  0.0292,  0.0284,  0.0201,  0.0163,  0.0046,  0.0030, -0.0024, -0.0058, -0.0035, 
     -0.0031, -0.0003,  0.0017,  0.0023, -0.0017, -0.0038, -0.0059, -0.0061, -0.0058, -0.0067, 
     -0.0014, -0.0028, -0.0044, -0.0032,  0.0012,  0.0059,  0.0075,  0.0035, -0.0048, -0.0074, 
     -0.0040, -0.0075, -0.0157, -0.0174, -0.0151, -0.0256, -0.0671},

    {-0.2433, -0.2526, -0.2308, -0.2813, -0.2852, -0.2414, -0.0985, -0.0229, -0.0156, -0.0156, 
     -0.0162, -0.0174, -0.0125, -0.0109, -0.0091, -0.0044,  0.0037,  0.0059,  0.0121,  0.0137, 
      0.0608,  0.0135,  0.0065,  0.0010,  0.0023, -0.0011, -0.0045, -0.0006,  0.0082,  0.0200, 
      0.0298,  0.0456,  0.0441,  0.0300,  0.0237,  0.0071,  0.0021, -0.0061, -0.0111, -0.0071, 
     -0.0057, -0.0007,  0.0043,  0.0064,  0.0006, -0.0029, -0.0078, -0.0100, -0.0097, -0.0111, 
     -0.0040, -0.0064, -0.0099, -0.0079, -0.0004,  0.0062,  0.0083,  0.0023, -0.0073, -0.0098, 
     -0.0067, -0.0120, -0.0218, -0.0228, -0.0196, -0.0333, -0.0728},

    {-0.1048, -0.1296, -0.1442, -0.1500, -0.1576, -0.1282, -0.0244, -0.0128, -0.0062, -0.0097, 
     -0.0089, -0.0078, -0.0048, -0.0034, -0.0020,  0.0007,  0.0050,  0.0064,  0.0085,  0.0074, 
      0.0135,  0.0515,  0.0060,  0.0000,  0.0010, -0.0017, -0.0039, -0.0012,  0.0031,  0.0133, 
      0.0181,  0.0278,  0.0223,  0.0135,  0.0116,  0.0014, -0.0022, -0.0052, -0.0084, -0.0056, 
     -0.0043, -0.0001,  0.0037,  0.0081,  0.0060, -0.0006, -0.0042, -0.0067, -0.0060, -0.0060, 
     -0.0029, -0.0030, -0.0057, -0.0026,  0.0008,  0.0043,  0.0038,  0.0005, -0.0040, -0.0076, 
     -0.0070, -0.0092, -0.0148, -0.0204, -0.0164, -0.0222, -0.0218},

    {-0.1083, -0.1166, -0.1316, -0.1511, -0.1427, -0.1144, -0.0506, -0.0278, -0.0135, -0.0109, 
     -0.0076, -0.0052, -0.0038, -0.0028, -0.0032, -0.0021, -0.0003,  0.0021,  0.0035,  0.0052, 
      0.0065,  0.0060,  0.0464,  0.0095,  0.0043,  0.0022,  0.0019,  0.0022,  0.0032,  0.0062, 
      0.0096,  0.0140,  0.0103,  0.0072,  0.0076,  0.0015, -0.0007, -0.0007, -0.0020,  0.0006, 
      0.0015,  0.0019,  0.0027,  0.0034,  0.0019, -0.0000,  0.0004, -0.0002, -0.0006, -0.0019, 
     -0.0008, -0.0012, -0.0026, -0.0015, -0.0003,  0.0017,  0.0017,  0.0009, -0.0019, -0.0074, 
     -0.0063, -0.0050, -0.0101, -0.0175, -0.0116, -0.0140, -0.0017},

    {-0.0301, -0.0449, -0.0835, -0.1600, -0.1415, -0.1273, -0.1128, -0.0399, -0.0243, -0.0199, 
     -0.0133, -0.0087, -0.0061, -0.0055, -0.0059, -0.0092, -0.0085, -0.0052, -0.0033,  0.0025, 
      0.0010,  0.0000,  0.0095,  0.0716,  0.0085,  0.0062,  0.0096,  0.0079,  0.0056,  0.0046, 
      0.0073,  0.0109,  0.0111,  0.0110,  0.0122,  0.0042, -0.0007,  0.0030,  0.0041,  0.0086, 
      0.0104,  0.0068,  0.0053, -0.0015, -0.0033,  0.0034,  0.0060,  0.0078,  0.0044, -0.0004, 
     -0.0015, -0.0040, -0.0052, -0.0067, -0.0056, -0.0039, -0.0028, -0.0017, -0.0028, -0.0098, 
     -0.0081, -0.0040, -0.0096, -0.0164, -0.0054, -0.0049,  0.0164},

    {-0.2070, -0.2292, -0.2172, -0.2362, -0.1816, -0.1335, -0.0834, -0.0354, -0.0176, -0.0105, 
     -0.0056, -0.0088, -0.0025, -0.0015, -0.0019, -0.0043, -0.0013, -0.0011, -0.0001,  0.0021, 
      0.0023,  0.0010,  0.0043,  0.0085,  0.0543,  0.0129,  0.0150,  0.0128,  0.0095,  0.0009, 
      0.0009, -0.0020,  0.0006,  0.0025,  0.0060,  0.0056,  0.0052,  0.0067,  0.0059,  0.0070, 
      0.0068,  0.0026,  0.0019, -0.0022, -0.0080,  0.0022,  0.0040,  0.0052,  0.0022,  0.0011, 
      0.0009, -0.0007, -0.0011, -0.0024, -0.0022, -0.0008, -0.0007, -0.0006, -0.0021, -0.0101, 
     -0.0085, -0.0036, -0.0096, -0.0207, -0.0136, -0.0074,  0.0189},

    {-0.1652, -0.1729, -0.1533, -0.1509, -0.0940, -0.0618, -0.0383, -0.0302, -0.0143, -0.0074, 
     -0.0012, -0.0017,  0.0011,  0.0015,  0.0009, -0.0015,  0.0015,  0.0008,  0.0002,  0.0009, 
     -0.0011, -0.0017,  0.0022,  0.0062,  0.0129,  0.0540,  0.0173,  0.0145,  0.0096, -0.0011, 
     -0.0033, -0.0086, -0.0091, -0.0043,  0.0035,  0.0069,  0.0071,  0.0093,  0.0080,  0.0075, 
      0.0060,  0.0014, -0.0016, -0.0063, -0.0101, -0.0007,  0.0019,  0.0050,  0.0020,  0.0030, 
      0.0025,  0.0020,  0.0036,  0.0016,  0.0002,  0.0002, -0.0008, -0.0006, -0.0038, -0.0101, 
     -0.0068, -0.0035, -0.0099, -0.0196, -0.0144, -0.0111, -0.0176},

    {-0.0922, -0.1235, -0.1205, -0.1264, -0.0840, -0.0444, -0.0488, -0.0468, -0.0238, -0.0116, 
     -0.0012,  0.0010,  0.0059,  0.0040,  0.0044, -0.0021,  0.0055,  0.0006, -0.0013, -0.0020, 
     -0.0045, -0.0039,  0.0019,  0.0096,  0.0150,  0.0173,  0.0681,  0.0233,  0.0152, -0.0001, 
     -0.0075, -0.0176, -0.0215, -0.0145, -0.0050,  0.0104,  0.0077,  0.0122,  0.0128,  0.0118, 
      0.0101,  0.0032, -0.0023, -0.0087, -0.0067,  0.0008,  0.0059,  0.0108,  0.0059,  0.0057, 
      0.0020,  0.0021,  0.0030,  0.0005, -0.0008, -0.0008, -0.0025, -0.0027, -0.0017, -0.0107, 
     -0.0107, -0.0052, -0.0088, -0.0219, -0.0205, -0.0083, -0.0031},

    {-0.0831, -0.1143, -0.1253, -0.1562, -0.1075, -0.0905, -0.0736, -0.0513, -0.0240, -0.0157, 
     -0.0040, -0.0055,  0.0026,  0.0011,  0.0045, -0.0010,  0.0030,  0.0014,  0.0003, -0.0000, 
     -0.0006, -0.0012,  0.0022,  0.0079,  0.0128,  0.0145,  0.0233,  0.0651,  0.0227,  0.0130, 
      0.0013, -0.0051, -0.0124, -0.0079,  0.0034,  0.0208,  0.0111,  0.0109,  0.0091,  0.0085, 
      0.0073,  0.0025,  0.0004, -0.0040, -0.0060,  0.0008,  0.0025,  0.0069,  0.0022,  0.0021, 
      0.0003, -0.0012, -0.0026, -0.0034, -0.0024, -0.0016, -0.0024, -0.0034, -0.0033, -0.0130, 
     -0.0132, -0.0083, -0.0134, -0.0257, -0.0240, -0.0173, -0.0052},

    {-0.1101, -0.1596, -0.1419, -0.2283, -0.1911, -0.1475, -0.0977, -0.0359, -0.0239, -0.0276, 
     -0.0123, -0.0210, -0.0092, -0.0096, -0.0021, -0.0081, -0.0018,  0.0014,  0.0045,  0.0056, 
      0.0082,  0.0031,  0.0032,  0.0056,  0.0095,  0.0096,  0.0152,  0.0227,  0.0878,  0.0387, 
      0.0282,  0.0273,  0.0198,  0.0094,  0.0120,  0.0231,  0.0110,  0.0038, -0.0003,  0.0005, 
      0.0011,  0.0001,  0.0003, -0.0007, -0.0096, -0.0089, -0.0061, -0.0041, -0.0076, -0.0084, 
     -0.0057, -0.0081, -0.0100, -0.0068, -0.0024,  0.0014,  0.0026, -0.0019, -0.0022, -0.0090, 
     -0.0120, -0.0119, -0.0144, -0.0212, -0.0318, -0.0235, -0.0079},

    { 0.0158, -0.0383, -0.0855, -0.2249, -0.2126, -0.2602, -0.1397, -0.0521, -0.0301, -0.0383, 
     -0.0300, -0.0388, -0.0159, -0.0127, -0.0025, -0.0061,  0.0054,  0.0076,  0.0123,  0.0110, 
      0.0200,  0.0133,  0.0062,  0.0046,  0.0009, -0.0011, -0.0001,  0.0130,  0.0387,  0.1163, 
      0.0592,  0.0828,  0.0584,  0.0238,  0.0219,  0.0307, -0.0001, -0.0112, -0.0137, -0.0081, 
     -0.0052,  0.0015,  0.0072,  0.0124, -0.0017, -0.0044, -0.0106, -0.0100, -0.0123, -0.0146, 
     -0.0088, -0.0117, -0.0180, -0.0132, -0.0026,  0.0060,  0.0064, -0.0024, -0.0095, -0.0171, 
     -0.0186, -0.0231, -0.0330, -0.0369, -0.0405, -0.0419, -0.0858},

    {-0.1108, -0.1104, -0.1478, -0.3308, -0.3719, -0.3922, -0.1996, -0.0412, -0.0340, -0.0272, 
     -0.0331, -0.0425, -0.0344, -0.0255, -0.0154, -0.0128,  0.0009,  0.0039,  0.0146,  0.0187, 
      0.0298,  0.0181,  0.0096,  0.0073,  0.0009, -0.0033, -0.0075,  0.0013,  0.0282,  0.0592, 
      0.1506,  0.1466,  0.1400,  0.0691,  0.0162,  0.0145, -0.0035, -0.0181, -0.0220, -0.0136, 
     -0.0098, -0.0009,  0.0058,  0.0140, -0.0130, -0.0045, -0.0157, -0.0189, -0.0203, -0.0237, 
     -0.0145, -0.0187, -0.0248, -0.0212, -0.0086,  0.0060,  0.0132,  0.0013, -0.0088, -0.0124, 
     -0.0149, -0.0255, -0.0352, -0.0436, -0.0517, -0.0435, -0.0666},

    {-0.3811, -0.3373, -0.3585, -0.5694, -0.6285, -0.6654, -0.3345, -0.0690, -0.0507, -0.0442, 
     -0.0546, -0.0685, -0.0512, -0.0370, -0.0238, -0.0160,  0.0029,  0.0064,  0.0232,  0.0292, 
      0.0456,  0.0278,  0.0140,  0.0109, -0.0020, -0.0086, -0.0176, -0.0051,  0.0273,  0.0828, 
      0.1466,  0.2524,  0.1950,  0.0994,  0.0436,  0.0194, -0.0067, -0.0284, -0.0335, -0.0202, 
     -0.0136,  0.0011,  0.0140,  0.0271, -0.0063,  0.0014, -0.0200, -0.0256, -0.0280, -0.0349, 
     -0.0197, -0.0272, -0.0363, -0.0321, -0.0116,  0.0093,  0.0193,  0.0013, -0.0198, -0.0214, 
     -0.0195, -0.0382, -0.0574, -0.0644, -0.0654, -0.0672, -0.1413},

    {-0.5813, -0.5058, -0.4442, -0.6545, -0.6760, -0.6233, -0.3486, -0.0580, -0.0573, -0.0408, 
     -0.0563, -0.0746, -0.0641, -0.0469, -0.0347, -0.0272, -0.0112, -0.0071,  0.0149,  0.0284, 
      0.0441,  0.0223,  0.0103,  0.0111,  0.0006, -0.0091, -0.0215, -0.0124,  0.0198,  0.0584, 
      0.1400,  0.1950,  0.2717,  0.1418,  0.0522,  0.0162,  0.0002, -0.0267, -0.0328, -0.0198, 
     -0.0139, -0.0002,  0.0134,  0.0190, -0.0165, -0.0015, -0.0219, -0.0265, -0.0286, -0.0374, 
     -0.0213, -0.0340, -0.0431, -0.0426, -0.0192,  0.0029,  0.0198,  0.0031, -0.0169, -0.0055, 
     -0.0012, -0.0242, -0.0360, -0.0359, -0.0381, -0.0408, -0.0856},

    {-0.5736, -0.5594, -0.4520, -0.5749, -0.5435, -0.4169, -0.2145, -0.0572, -0.0488, -0.0478, 
     -0.0479, -0.0530, -0.0502, -0.0343, -0.0244, -0.0188, -0.0155, -0.0093,  0.0070,  0.0201, 
      0.0300,  0.0135,  0.0072,  0.0110,  0.0025, -0.0043, -0.0145, -0.0079,  0.0094,  0.0238, 
      0.0691,  0.0994,  0.1418,  0.1682,  0.0932,  0.0216,  0.0096, -0.0140, -0.0211, -0.0125, 
     -0.0086,  0.0014,  0.0127,  0.0103, -0.0061,  0.0025, -0.0161, -0.0184, -0.0194, -0.0257, 
     -0.0128, -0.0247, -0.0335, -0.0331, -0.0167, -0.0046,  0.0106,  0.0031, -0.0156, -0.0053, 
      0.0049, -0.0104, -0.0229, -0.0203, -0.0118, -0.0351, -0.0744},

    {-0.5507, -0.5784, -0.4458, -0.4824, -0.4409, -0.3290, -0.1061, -0.0487, -0.0357, -0.0627, 
     -0.0485, -0.0468, -0.0380, -0.0214, -0.0106, -0.0066, -0.0105, -0.0036,  0.0070,  0.0163, 
      0.0237,  0.0116,  0.0076,  0.0122,  0.0060,  0.0035, -0.0050,  0.0034,  0.0120,  0.0219, 
      0.0162,  0.0436,  0.0522,  0.0932,  0.1864,  0.0354,  0.0120, -0.0046, -0.0137, -0.0078, 
     -0.0046,  0.0033,  0.0155,  0.0144,  0.0065,  0.0090, -0.0114, -0.0134, -0.0150, -0.0188, 
     -0.0069, -0.0165, -0.0252, -0.0227, -0.0119, -0.0083,  0.0031,  0.0010, -0.0214, -0.0188, 
     -0.0030, -0.0109, -0.0325, -0.0359, -0.0193, -0.0636, -0.1496},

    {-0.1059, -0.1570, -0.1376, -0.1947, -0.1425, -0.1698, -0.1304, -0.0840, -0.0369, -0.0233, 
     -0.0068, -0.0145, -0.0068, -0.0053,  0.0011, -0.0032, -0.0011, -0.0011,  0.0007,  0.0046, 
      0.0071,  0.0014,  0.0015,  0.0042,  0.0056,  0.0069,  0.0104,  0.0208,  0.0231,  0.0307, 
      0.0145,  0.0194,  0.0162,  0.0216,  0.0354,  0.0959,  0.0248,  0.0086,  0.0026,  0.0024, 
      0.0022,  0.0036,  0.0081,  0.0096, -0.0042,  0.0029, -0.0017,  0.0025, -0.0027, -0.0045, 
     -0.0019, -0.0095, -0.0182, -0.0198, -0.0120, -0.0087, -0.0024, -0.0052, -0.0127, -0.0153, 
     -0.0098, -0.0125, -0.0208, -0.0227, -0.0294, -0.0435, -0.1043},

    {-0.1705, -0.1968, -0.1603, -0.1672, -0.1067, -0.0903, -0.0909, -0.0607, -0.0300, -0.0092, 
      0.0029, -0.0044, -0.0063, -0.0036, -0.0005, -0.0025, -0.0011, -0.0018, -0.0005,  0.0030, 
      0.0021, -0.0022, -0.0007, -0.0007,  0.0052,  0.0071,  0.0077,  0.0111,  0.0110, -0.0001, 
     -0.0035, -0.0067,  0.0002,  0.0096,  0.0120,  0.0248,  0.0654,  0.0135,  0.0078,  0.0051, 
      0.0034,  0.0014,  0.0019, -0.0046, -0.0051,  0.0004,  0.0002,  0.0035,  0.0010,  0.0008, 
      0.0027, -0.0023, -0.0043, -0.0076, -0.0051, -0.0047, -0.0005, -0.0013, -0.0058, -0.0060, 
     -0.0015, -0.0020, -0.0064, -0.0061, -0.0045, -0.0134, -0.0643},

    { 0.0025, -0.0303, -0.0336, -0.0102,  0.0275,  0.0346, -0.0121, -0.0252, -0.0097,  0.0017, 
      0.0089,  0.0028,  0.0054,  0.0051,  0.0045,  0.0025,  0.0012, -0.0004, -0.0030, -0.0024, 
     -0.0061, -0.0052, -0.0007,  0.0030,  0.0067,  0.0093,  0.0122,  0.0109,  0.0038, -0.0112, 
     -0.0181, -0.0284, -0.0267, -0.0140, -0.0046,  0.0086,  0.0135,  0.0551,  0.0130,  0.0095, 
      0.0070,  0.0019, -0.0015, -0.0073, -0.0086,  0.0001,  0.0045,  0.0077,  0.0058,  0.0077, 
      0.0054,  0.0044,  0.0050,  0.0021, -0.0010, -0.0045, -0.0040, -0.0016, -0.0021, -0.0053, 
     -0.0025,  0.0011, -0.0009, -0.0044, -0.0015, -0.0033, -0.0192},

    { 0.0493,  0.0200,  0.0227,  0.0371,  0.0664,  0.0591, -0.0086, -0.0194, -0.0075,  0.0021, 
      0.0083,  0.0041,  0.0068,  0.0070,  0.0062,  0.0020, -0.0007, -0.0032, -0.0060, -0.0058, 
     -0.0111, -0.0084, -0.0020,  0.0041,  0.0059,  0.0080,  0.0128,  0.0091, -0.0003, -0.0137, 
     -0.0220, -0.0335, -0.0328, -0.0211, -0.0137,  0.0026,  0.0078,  0.0130,  0.0547,  0.0117, 
      0.0098,  0.0033, -0.0018, -0.0082, -0.0047,  0.0040,  0.0103,  0.0132,  0.0104,  0.0098, 
      0.0052,  0.0053,  0.0067,  0.0027, -0.0011, -0.0046, -0.0051, -0.0021,  0.0001, -0.0031, 
     -0.0019,  0.0033,  0.0039,  0.0011,  0.0047,  0.0136,  0.0217},

    { 0.0050, -0.0268, -0.0345, -0.0416, -0.0076, -0.0075, -0.0479, -0.0297, -0.0135, -0.0034, 
      0.0018, -0.0004,  0.0031,  0.0034,  0.0020, -0.0010, -0.0019, -0.0033, -0.0048, -0.0035, 
     -0.0071, -0.0056,  0.0006,  0.0086,  0.0070,  0.0075,  0.0118,  0.0085,  0.0005, -0.0081, 
     -0.0136, -0.0202, -0.0198, -0.0125, -0.0078,  0.0024,  0.0051,  0.0095,  0.0117,  0.0501, 
      0.0102,  0.0045,  0.0006, -0.0050, -0.0044,  0.0045,  0.0101,  0.0123,  0.0093,  0.0071, 
      0.0037,  0.0028,  0.0034, -0.0004, -0.0025, -0.0043, -0.0042, -0.0019, -0.0007, -0.0049, 
     -0.0035,  0.0013,  0.0004, -0.0040,  0.0024,  0.0092,  0.0299},

    { 0.0181, -0.0084, -0.0149, -0.0325, -0.0015, -0.0148, -0.0509, -0.0253, -0.0119, -0.0054, 
     -0.0000, -0.0020,  0.0014,  0.0013,  0.0001, -0.0029, -0.0032, -0.0041, -0.0051, -0.0031, 
     -0.0057, -0.0043,  0.0015,  0.0104,  0.0068,  0.0060,  0.0101,  0.0073,  0.0011, -0.0052, 
     -0.0098, -0.0136, -0.0139, -0.0086, -0.0046,  0.0022,  0.0034,  0.0070,  0.0098,  0.0102, 
      0.0502,  0.0059,  0.0027, -0.0025, -0.0020,  0.0066,  0.0122,  0.0129,  0.0094,  0.0055, 
      0.0023,  0.0006,  0.0001, -0.0029, -0.0041, -0.0055, -0.0049, -0.0028, -0.0012, -0.0054, 
     -0.0046, -0.0001, -0.0013, -0.0065,  0.0010,  0.0080,  0.0383},

    {-0.0090, -0.0359, -0.0236, -0.0398, -0.0094, -0.0151, -0.0347, -0.0182, -0.0078, -0.0085, 
     -0.0028, -0.0046, -0.0016, -0.0009, -0.0012, -0.0027,  0.0002, -0.0007, -0.0010, -0.0003, 
     -0.0007, -0.0001,  0.0019,  0.0068,  0.0026,  0.0014,  0.0032,  0.0025,  0.0001,  0.0015, 
     -0.0009,  0.0011, -0.0002,  0.0014,  0.0033,  0.0036,  0.0014,  0.0019,  0.0033,  0.0045, 
      0.0059,  0.0452,  0.0059,  0.0063,  0.0019,  0.0055,  0.0072,  0.0066,  0.0049,  0.0013, 
      0.0004, -0.0014, -0.0035, -0.0048, -0.0039, -0.0039, -0.0030, -0.0022, -0.0029, -0.0055, 
     -0.0044, -0.0028, -0.0050, -0.0080, -0.0021, -0.0002,  0.0095},

    {-0.0084, -0.0608, -0.0548, -0.0753, -0.0576, -0.0762, -0.0719, -0.0185, -0.0096, -0.0098, 
     -0.0063, -0.0119, -0.0065, -0.0047, -0.0029, -0.0049, -0.0051, -0.0029, -0.0009,  0.0017, 
      0.0043,  0.0037,  0.0027,  0.0053,  0.0019, -0.0016, -0.0023,  0.0004,  0.0003,  0.0072, 
      0.0058,  0.0140,  0.0134,  0.0127,  0.0155,  0.0081,  0.0019, -0.0015, -0.0018,  0.0006, 
      0.0027,  0.0059,  0.0562,  0.0212,  0.0120,  0.0111,  0.0034,  0.0007,  0.0000, -0.0018, 
     -0.0020, -0.0055, -0.0096, -0.0091, -0.0072, -0.0062, -0.0034, -0.0025, -0.0024, -0.0068, 
     -0.0069, -0.0049, -0.0089, -0.0136, -0.0082, -0.0054, -0.0049},

    {-0.1149, -0.1079, -0.0483, -0.0645, -0.0526, -0.0858, -0.0730, -0.0140, -0.0085, -0.0109, 
     -0.0087, -0.0186, -0.0089, -0.0055, -0.0039,  0.0011, -0.0005,  0.0010,  0.0012,  0.0023, 
      0.0064,  0.0081,  0.0034, -0.0015, -0.0022, -0.0063, -0.0087, -0.0040, -0.0007,  0.0124, 
      0.0140,  0.0271,  0.0190,  0.0103,  0.0144,  0.0096, -0.0046, -0.0073, -0.0082, -0.0050, 
     -0.0025,  0.0063,  0.0212,  0.0986,  0.0036,  0.0130,  0.0014, -0.0040, -0.0021, -0.0040, 
     -0.0031, -0.0056, -0.0117, -0.0095, -0.0078, -0.0063, -0.0023, -0.0019,  0.0005, -0.0026, 
     -0.0060, -0.0050, -0.0055, -0.0148, -0.0150, -0.0080, -0.0351},

    {-0.4191, -0.3362, -0.3522, -0.1293, -0.1089, -0.0286,  0.0266, -0.0375, -0.0156, -0.0127, 
     -0.0003,  0.0177, -0.0020, -0.0012,  0.0010, -0.0014, -0.0042, -0.0059, -0.0029, -0.0017, 
      0.0006,  0.0060,  0.0019, -0.0033, -0.0080, -0.0101, -0.0067, -0.0060, -0.0096, -0.0017, 
     -0.0130, -0.0063, -0.0165, -0.0061,  0.0065, -0.0042, -0.0051, -0.0086, -0.0047, -0.0044, 
     -0.0020,  0.0019,  0.0120,  0.0036,  0.1506,  0.0194,  0.0101,  0.0044,  0.0038, -0.0008, 
     -0.0047, -0.0057, -0.0092, -0.0064, -0.0066, -0.0057, -0.0024, -0.0026,  0.0025, -0.0013, 
     -0.0066, -0.0032, -0.0023, -0.0100, -0.0097, -0.0010,  0.0766},

    {-0.2075, -0.1938, -0.1701, -0.1563, -0.1137, -0.1340, -0.0880, -0.0235, -0.0090, -0.0065, 
     -0.0032, -0.0087, -0.0032, -0.0005,  0.0016, -0.0023, -0.0071, -0.0077, -0.0064, -0.0038, 
     -0.0029, -0.0006, -0.0000,  0.0034,  0.0022, -0.0007,  0.0008,  0.0008, -0.0089, -0.0044, 
     -0.0045,  0.0014, -0.0015,  0.0025,  0.0090,  0.0029,  0.0004,  0.0001,  0.0040,  0.0045, 
      0.0066,  0.0055,  0.0111,  0.0130,  0.0194,  0.0665,  0.0148,  0.0101,  0.0070,  0.0026, 
     -0.0002, -0.0029, -0.0057, -0.0074, -0.0075, -0.0083, -0.0060, -0.0035, -0.0009, -0.0066, 
     -0.0066, -0.0010, -0.0033, -0.0131, -0.0014,  0.0046,  0.0315},

    {-0.1022, -0.1255, -0.1193, -0.1058, -0.0314, -0.0335, -0.0538, -0.0249, -0.0040, -0.0026, 
      0.0036,  0.0014,  0.0043,  0.0033,  0.0014, -0.0018, -0.0045, -0.0066, -0.0078, -0.0059, 
     -0.0078, -0.0042,  0.0004,  0.0060,  0.0040,  0.0019,  0.0059,  0.0025, -0.0061, -0.0106, 
     -0.0157, -0.0200, -0.0219, -0.0161, -0.0114, -0.0017,  0.0002,  0.0045,  0.0103,  0.0101, 
      0.0122,  0.0072,  0.0034,  0.0014,  0.0101,  0.0148,  0.0642,  0.0205,  0.0165,  0.0075, 
      0.0027,  0.0014, -0.0008, -0.0034, -0.0053, -0.0073, -0.0067, -0.0038,  0.0002, -0.0046, 
     -0.0048,  0.0016,  0.0026, -0.0053,  0.0036,  0.0165,  0.0645},

    {-0.0633, -0.0738, -0.0667, -0.0579, -0.0009, -0.0108, -0.0569, -0.0359, -0.0127, -0.0043, 
      0.0028,  0.0034,  0.0061,  0.0044,  0.0025, -0.0006, -0.0027, -0.0055, -0.0076, -0.0061, 
     -0.0100, -0.0067, -0.0002,  0.0078,  0.0052,  0.0050,  0.0108,  0.0069, -0.0041, -0.0100, 
     -0.0189, -0.0256, -0.0265, -0.0184, -0.0134,  0.0025,  0.0035,  0.0077,  0.0132,  0.0123, 
      0.0129,  0.0066,  0.0007, -0.0040,  0.0044,  0.0101,  0.0205,  0.0600,  0.0165,  0.0090, 
      0.0038,  0.0025,  0.0015, -0.0021, -0.0037, -0.0059, -0.0060, -0.0036, -0.0006, -0.0043, 
     -0.0037,  0.0017,  0.0028, -0.0029,  0.0039,  0.0159,  0.0588},

    {-0.0430, -0.0303, -0.0310, -0.0072,  0.0382,  0.0155, -0.0419, -0.0251, -0.0094, -0.0025, 
      0.0031,  0.0063,  0.0085,  0.0069,  0.0045,  0.0011, -0.0024, -0.0040, -0.0066, -0.0058, 
     -0.0097, -0.0060, -0.0006,  0.0044,  0.0022,  0.0020,  0.0059,  0.0022, -0.0076, -0.0123, 
     -0.0203, -0.0280, -0.0286, -0.0194, -0.0150, -0.0027,  0.0010,  0.0058,  0.0104,  0.0093, 
      0.0094,  0.0049,  0.0000, -0.0021,  0.0038,  0.0070,  0.0165,  0.0165,  0.0555,  0.0104, 
      0.0053,  0.0053,  0.0051,  0.0023, -0.0010, -0.0040, -0.0046, -0.0017,  0.0014, -0.0021, 
     -0.0016,  0.0040,  0.0058,  0.0018,  0.0074,  0.0166,  0.0413},

    { 0.1267,  0.1095,  0.0780,  0.1146,  0.1229,  0.0939,  0.0265, -0.0071, -0.0016,  0.0056, 
      0.0077,  0.0096,  0.0129,  0.0124,  0.0106,  0.0068,  0.0001, -0.0013, -0.0059, -0.0067, 
     -0.0111, -0.0060, -0.0019, -0.0004,  0.0011,  0.0030,  0.0057,  0.0021, -0.0084, -0.0146, 
     -0.0237, -0.0349, -0.0374, -0.0257, -0.0188, -0.0045,  0.0008,  0.0077,  0.0098,  0.0071, 
      0.0055,  0.0013, -0.0018, -0.0040, -0.0008,  0.0026,  0.0075,  0.0090,  0.0104,  0.0530, 
      0.0078,  0.0100,  0.0119,  0.0090,  0.0028, -0.0018, -0.0050, -0.0009,  0.0024, -0.0010, 
     -0.0001,  0.0055,  0.0071,  0.0028,  0.0056,  0.0123,  0.0315},

    {-0.0610, -0.0584, -0.0507, -0.0214,  0.0098,  0.0101, -0.0070, -0.0113, -0.0039,  0.0017, 
      0.0031,  0.0022,  0.0055,  0.0060,  0.0036,  0.0048,  0.0017,  0.0012, -0.0007, -0.0014, 
     -0.0040, -0.0029, -0.0008, -0.0015,  0.0009,  0.0025,  0.0020,  0.0003, -0.0057, -0.0088, 
     -0.0145, -0.0197, -0.0213, -0.0128, -0.0069, -0.0019,  0.0027,  0.0054,  0.0052,  0.0037, 
      0.0023,  0.0004, -0.0020, -0.0031, -0.0047, -0.0002,  0.0027,  0.0038,  0.0053,  0.0078, 
      0.0460,  0.0083,  0.0105,  0.0076,  0.0042,  0.0018, -0.0005,  0.0016, -0.0003, -0.0026, 
      0.0007,  0.0033,  0.0011, -0.0003,  0.0033,  0.0003, -0.0182},

    {-0.0383, -0.0331, -0.0355,  0.0123,  0.0404,  0.0483,  0.0324,  0.0009,  0.0028,  0.0065, 
      0.0061,  0.0071,  0.0111,  0.0113,  0.0077,  0.0102,  0.0053,  0.0046,  0.0008, -0.0028, 
     -0.0064, -0.0030, -0.0012, -0.0040, -0.0007,  0.0020,  0.0021, -0.0012, -0.0081, -0.0117, 
     -0.0187, -0.0272, -0.0340, -0.0247, -0.0165, -0.0095, -0.0023,  0.0044,  0.0053,  0.0028, 
      0.0006, -0.0014, -0.0055, -0.0056, -0.0057, -0.0029,  0.0014,  0.0025,  0.0053,  0.0100, 
      0.0083,  0.0531,  0.0180,  0.0166,  0.0102,  0.0068,  0.0010,  0.0036,  0.0027, -0.0015, 
      0.0007,  0.0047,  0.0029, -0.0002,  0.0009, -0.0011, -0.0228},

    { 0.0438,  0.0716,  0.0556,  0.1039,  0.1183,  0.1173,  0.0768,  0.0183,  0.0094,  0.0129, 
      0.0098,  0.0112,  0.0120,  0.0118,  0.0062,  0.0094,  0.0036,  0.0041,  0.0002, -0.0044, 
     -0.0099, -0.0057, -0.0026, -0.0052, -0.0011,  0.0036,  0.0030, -0.0026, -0.0100, -0.0180, 
     -0.0248, -0.0363, -0.0431, -0.0335, -0.0252, -0.0182, -0.0043,  0.0050,  0.0067,  0.0034, 
      0.0001, -0.0035, -0.0096, -0.0117, -0.0092, -0.0057, -0.0008,  0.0015,  0.0051,  0.0119, 
      0.0105,  0.0180,  0.0695,  0.0245,  0.0153,  0.0109,  0.0020,  0.0056,  0.0034,  0.0003, 
      0.0041,  0.0083,  0.0060,  0.0039,  0.0074,  0.0055, -0.0190},

    { 0.0684,  0.1012,  0.0872,  0.1430,  0.1471,  0.1347,  0.0997,  0.0271,  0.0135,  0.0118, 
      0.0083,  0.0120,  0.0158,  0.0131,  0.0096,  0.0122,  0.0039,  0.0069,  0.0027, -0.0032, 
     -0.0079, -0.0026, -0.0015, -0.0067, -0.0024,  0.0016,  0.0005, -0.0034, -0.0068, -0.0132, 
     -0.0212, -0.0321, -0.0426, -0.0331, -0.0227, -0.0198, -0.0076,  0.0021,  0.0027, -0.0004, 
     -0.0029, -0.0048, -0.0091, -0.0095, -0.0064, -0.0074, -0.0034, -0.0021,  0.0023,  0.0090, 
      0.0076,  0.0166,  0.0245,  0.0679,  0.0185,  0.0135,  0.0040,  0.0073,  0.0089,  0.0026, 
      0.0020,  0.0075,  0.0060, -0.0002, -0.0011, -0.0036, -0.0259},

    {-0.0874, -0.0574, -0.0493, -0.0274, -0.0085,  0.0135,  0.0367,  0.0085,  0.0049,  0.0014, 
     -0.0008,  0.0030,  0.0080,  0.0067,  0.0055,  0.0085,  0.0071,  0.0083,  0.0065,  0.0012, 
     -0.0004,  0.0008, -0.0003, -0.0056, -0.0022,  0.0002, -0.0008, -0.0024, -0.0024, -0.0026, 
     -0.0086, -0.0116, -0.0192, -0.0167, -0.0119, -0.0120, -0.0051, -0.0010, -0.0011, -0.0025, 
     -0.0041, -0.0039, -0.0072, -0.0078, -0.0066, -0.0075, -0.0053, -0.0037, -0.0010,  0.0028, 
      0.0042,  0.0102,  0.0153,  0.0185,  0.0551,  0.0152,  0.0066,  0.0058,  0.0029,  0.0004, 
      0.0016,  0.0017, -0.0017, -0.0020, -0.0027, -0.0117, -0.0399},

    {-0.2115, -0.1756, -0.1657, -0.1716, -0.1404, -0.0988, -0.0172, -0.0101, -0.0055, -0.0049, 
     -0.0076, -0.0045,  0.0008,  0.0011,  0.0005,  0.0054,  0.0082,  0.0088,  0.0100,  0.0059, 
      0.0062,  0.0043,  0.0017, -0.0039, -0.0008,  0.0002, -0.0008, -0.0016,  0.0014,  0.0060, 
      0.0060,  0.0093,  0.0029, -0.0046, -0.0083, -0.0087, -0.0047, -0.0045, -0.0046, -0.0043, 
     -0.0055, -0.0039, -0.0062, -0.0063, -0.0057, -0.0083, -0.0073, -0.0059, -0.0040, -0.0018, 
      0.0018,  0.0068,  0.0109,  0.0135,  0.0152,  0.0588,  0.0114,  0.0074,  0.0016, -0.0019, 
     -0.0004, -0.0021, -0.0088, -0.0108, -0.0099, -0.0189, -0.0767},

    {-0.2362, -0.1814, -0.1424, -0.1556, -0.1363, -0.1103, -0.0375, -0.0139, -0.0118, -0.0063, 
     -0.0097, -0.0092, -0.0078, -0.0052, -0.0048, -0.0002,  0.0031,  0.0040,  0.0079,  0.0075, 
      0.0083,  0.0038,  0.0017, -0.0028, -0.0007, -0.0008, -0.0025, -0.0024,  0.0026,  0.0064, 
      0.0132,  0.0193,  0.0198,  0.0106,  0.0031, -0.0024, -0.0005, -0.0040, -0.0051, -0.0042, 
     -0.0049, -0.0030, -0.0034, -0.0023, -0.0024, -0.0060, -0.0067, -0.0060, -0.0046, -0.0050, 
     -0.0005,  0.0010,  0.0020,  0.0040,  0.0066,  0.0114,  0.0503,  0.0071,  0.0018,  0.0008, 
      0.0016, -0.0014, -0.0062, -0.0073, -0.0092, -0.0169, -0.0853},

    {-0.1175, -0.0814, -0.0619, -0.0686, -0.0502, -0.0389, -0.0129, -0.0081, -0.0074, -0.0013, 
     -0.0047, -0.0046, -0.0039, -0.0020, -0.0031,  0.0012, -0.0020,  0.0010,  0.0032,  0.0035, 
      0.0023,  0.0005,  0.0009, -0.0017, -0.0006, -0.0006, -0.0027, -0.0034, -0.0019, -0.0024, 
      0.0013,  0.0013,  0.0031,  0.0031,  0.0010, -0.0052, -0.0013, -0.0016, -0.0021, -0.0019, 
     -0.0028, -0.0022, -0.0025, -0.0019, -0.0026, -0.0035, -0.0038, -0.0036, -0.0017, -0.0009, 
      0.0016,  0.0036,  0.0056,  0.0073,  0.0058,  0.0074,  0.0071,  0.0469,  0.0059,  0.0027, 
      0.0031,  0.0046,  0.0015, -0.0019, -0.0007, -0.0078, -0.0500},

    { 0.1850,  0.1919,  0.1879,  0.2052,  0.1825,  0.1285,  0.0441,  0.0216,  0.0051,  0.0165, 
      0.0066,  0.0047,  0.0012,  0.0001, -0.0014, -0.0013, -0.0090, -0.0050, -0.0057, -0.0048, 
     -0.0073, -0.0040, -0.0019, -0.0028, -0.0021, -0.0038, -0.0017, -0.0033, -0.0022, -0.0095, 
     -0.0088, -0.0198, -0.0169, -0.0156, -0.0214, -0.0127, -0.0058, -0.0021,  0.0001, -0.0007, 
     -0.0012, -0.0029, -0.0024,  0.0005,  0.0025, -0.0009,  0.0002, -0.0006,  0.0014,  0.0024, 
     -0.0003,  0.0027,  0.0034,  0.0089,  0.0029,  0.0016,  0.0018,  0.0059,  0.0636,  0.0186, 
      0.0039,  0.0137,  0.0270,  0.0129,  0.0037,  0.0223,  0.0310},

    { 0.1712,  0.2233,  0.2565,  0.2969,  0.2423,  0.2213,  0.0956,  0.0509,  0.0199,  0.0222, 
      0.0088,  0.0081, -0.0020, -0.0021, -0.0035, -0.0035, -0.0080, -0.0075, -0.0083, -0.0074, 
     -0.0098, -0.0076, -0.0074, -0.0098, -0.0101, -0.0101, -0.0107, -0.0130, -0.0090, -0.0171, 
     -0.0124, -0.0214, -0.0055, -0.0053, -0.0188, -0.0153, -0.0060, -0.0053, -0.0031, -0.0049, 
     -0.0054, -0.0055, -0.0068, -0.0026, -0.0013, -0.0066, -0.0046, -0.0043, -0.0021, -0.0010, 
     -0.0026, -0.0015,  0.0003,  0.0026,  0.0004, -0.0019,  0.0008,  0.0027,  0.0186,  0.0712, 
      0.0200,  0.0185,  0.0397,  0.0460,  0.0291,  0.0387,  0.0567},

    {-0.0225,  0.0388,  0.0784,  0.0996,  0.0864,  0.1216,  0.0576,  0.0291,  0.0121,  0.0104, 
      0.0031,  0.0036, -0.0029, -0.0011, -0.0030, -0.0014, -0.0052, -0.0052, -0.0050, -0.0040, 
     -0.0067, -0.0070, -0.0063, -0.0081, -0.0085, -0.0068, -0.0107, -0.0132, -0.0120, -0.0186, 
     -0.0149, -0.0195, -0.0012,  0.0049, -0.0030, -0.0098, -0.0015, -0.0025, -0.0019, -0.0035, 
     -0.0046, -0.0044, -0.0069, -0.0060, -0.0066, -0.0066, -0.0048, -0.0037, -0.0016, -0.0001, 
      0.0007,  0.0007,  0.0041,  0.0020,  0.0016, -0.0004,  0.0016,  0.0031,  0.0039,  0.0200, 
      0.0610,  0.0157,  0.0248,  0.0405,  0.0360,  0.0252,  0.0213},

    { 0.0559,  0.0881,  0.0963,  0.1188,  0.1292,  0.1408,  0.0421,  0.0150,  0.0048,  0.0121, 
      0.0061,  0.0045,  0.0016,  0.0023, -0.0007, -0.0013, -0.0108, -0.0084, -0.0095, -0.0075, 
     -0.0120, -0.0092, -0.0050, -0.0040, -0.0036, -0.0035, -0.0052, -0.0083, -0.0119, -0.0231, 
     -0.0255, -0.0382, -0.0242, -0.0104, -0.0109, -0.0125, -0.0020,  0.0011,  0.0033,  0.0013, 
     -0.0001, -0.0028, -0.0049, -0.0050, -0.0032, -0.0010,  0.0016,  0.0017,  0.0040,  0.0055, 
      0.0033,  0.0047,  0.0083,  0.0075,  0.0017, -0.0021, -0.0014,  0.0046,  0.0137,  0.0185, 
      0.0157,  0.0604,  0.0310,  0.0332,  0.0352,  0.0366,  0.0513},

    { 0.2786,  0.3006,  0.3236,  0.3756,  0.3279,  0.3129,  0.1070,  0.0512,  0.0219,  0.0307, 
      0.0165,  0.0138,  0.0029,  0.0032, -0.0006, -0.0040, -0.0154, -0.0138, -0.0174, -0.0157, 
     -0.0218, -0.0148, -0.0101, -0.0096, -0.0096, -0.0099, -0.0088, -0.0134, -0.0144, -0.0330, 
     -0.0352, -0.0574, -0.0360, -0.0229, -0.0325, -0.0208, -0.0064, -0.0009,  0.0039,  0.0004, 
     -0.0013, -0.0050, -0.0089, -0.0055, -0.0023, -0.0033,  0.0026,  0.0028,  0.0058,  0.0071, 
      0.0011,  0.0029,  0.0060,  0.0060, -0.0017, -0.0088, -0.0062,  0.0015,  0.0270,  0.0397, 
      0.0248,  0.0310,  0.1028,  0.0655,  0.0503,  0.0763,  0.1695},

    { 0.4187,  0.4461,  0.4393,  0.4682,  0.3160,  0.3359,  0.1040,  0.0922,  0.0477,  0.0354, 
      0.0210,  0.0200,  0.0068,  0.0025, -0.0016, -0.0051, -0.0105, -0.0123, -0.0165, -0.0174, 
     -0.0228, -0.0204, -0.0175, -0.0164, -0.0207, -0.0196, -0.0219, -0.0257, -0.0212, -0.0369, 
     -0.0436, -0.0644, -0.0359, -0.0203, -0.0359, -0.0227, -0.0061, -0.0044,  0.0011, -0.0040, 
     -0.0065, -0.0080, -0.0136, -0.0148, -0.0100, -0.0131, -0.0053, -0.0029,  0.0018,  0.0028, 
     -0.0003, -0.0002,  0.0039, -0.0002, -0.0020, -0.0108, -0.0073, -0.0019,  0.0129,  0.0460, 
      0.0405,  0.0332,  0.0655,  0.1660,  0.1041,  0.0957,  0.1592},

    { 0.2768,  0.3445,  0.3120,  0.2842,  0.1905,  0.2473,  0.0580,  0.0440,  0.0269,  0.0172, 
      0.0053, -0.0016, -0.0002,  0.0013, -0.0029, -0.0072, -0.0129, -0.0125, -0.0156, -0.0151, 
     -0.0196, -0.0164, -0.0116, -0.0054, -0.0136, -0.0144, -0.0205, -0.0240, -0.0318, -0.0405, 
     -0.0517, -0.0654, -0.0381, -0.0118, -0.0193, -0.0294, -0.0045, -0.0015,  0.0047,  0.0024, 
      0.0010, -0.0021, -0.0082, -0.0150, -0.0097, -0.0014,  0.0036,  0.0039,  0.0074,  0.0056, 
      0.0033,  0.0009,  0.0074, -0.0011, -0.0027, -0.0099, -0.0092, -0.0007,  0.0037,  0.0291, 
      0.0360,  0.0352,  0.0503,  0.1041,  0.1788,  0.1192,  0.1552},

    { 0.6965,  0.6895,  0.6361,  0.6217,  0.4815,  0.4354,  0.1661,  0.0656,  0.0260,  0.0261, 
      0.0088, -0.0041,  0.0027,  0.0045,  0.0033, -0.0109, -0.0197, -0.0231, -0.0269, -0.0256, 
     -0.0333, -0.0222, -0.0140, -0.0049, -0.0074, -0.0111, -0.0083, -0.0173, -0.0235, -0.0419, 
     -0.0435, -0.0672, -0.0408, -0.0351, -0.0636, -0.0435, -0.0134, -0.0033,  0.0136,  0.0092, 
      0.0080, -0.0002, -0.0054, -0.0080, -0.0010,  0.0046,  0.0165,  0.0159,  0.0166,  0.0123, 
      0.0003, -0.0011,  0.0055, -0.0036, -0.0117, -0.0189, -0.0169, -0.0078,  0.0223,  0.0387, 
      0.0252,  0.0366,  0.0763,  0.0957,  0.1192,  0.2788,  0.4800},

    { 2.9242,  2.0968,  1.1163,  0.5801,  0.2387,  0.8689,  0.4481,  0.0211,  0.0175, -0.0113, 
      0.0076,  0.0502,  0.0360,  0.0223,  0.0422, -0.0196, -0.0710, -0.0579, -0.0795, -0.0671, 
     -0.0728, -0.0218, -0.0017,  0.0164,  0.0189, -0.0176, -0.0031, -0.0052, -0.0079, -0.0858, 
     -0.0666, -0.1413, -0.0856, -0.0744, -0.1496, -0.1043, -0.0643, -0.0192,  0.0217,  0.0299, 
      0.0383,  0.0095, -0.0049, -0.0351,  0.0766,  0.0315,  0.0645,  0.0588,  0.0413,  0.0315, 
     -0.0182, -0.0228, -0.0190, -0.0259, -0.0399, -0.0767, -0.0853, -0.0500,  0.0310,  0.0567, 
      0.0213,  0.0513,  0.1695,  0.1592,  0.1552,  0.4800,  4.7875}
};

/* Inverse Gamma 4.204e-03 4.202e-01 */
double simevals[67] = 
{
    310.30, 25.815, 23.381, 4.2054, 2.8835, 2.0697, 1.7758, 0.97085, 0.61964, 0.44248,
    0.31220, 0.31016, 0.30472, 0.29729, 0.18909, 0.17261, 0.15538, 0.11715, 0.10828, 0.10749,
    0.10607, 0.10544, 0.10077, 0.071170, 0.070950, 0.066103, 0.064815, 0.056509, 0.055751, 0.046457,
    0.042207, 0.037712, 0.031944, 0.028278, 0.020632, 0.019811, 0.019278, 0.017944, 0.017393, 0.016847,
    0.016037, 0.014610, 0.013335, 0.013324, 0.012756, 0.012629, 0.010911, 0.010611, 0.010134, 0.0097525,
    0.0095817, 0.0080242, 0.0075681, 0.0067824, 0.0053294, 0.0051037, 0.0039548, 0.0037919, 0.0036660, 0.0036545,
    0.0034841, 0.0034483, 0.0028551, 0.0026013, 0.0020196, 0.0016284, 0.0011814
};


/* Inverse Gamma 4.37e-03 3.95e-01 */
double simevals2[67] =
{
    5.587480e+00, 6.371975e+02, 4.592334e-03, 9.538267e-01, 3.205965e+00,
    2.038829e-03, 2.185746e-02, 8.378868e-02, 1.109509e-01, 4.275248e-03,
    5.172678e-03, 5.678137e-02, 2.392720e-02, 3.698641e+00, 8.570359e-01,
    3.907999e-01, 1.281967e-02, 4.530836e-02, 1.676085e-02, 9.889964e-03,
    2.630001e-03, 1.724972e-03, 1.261005e-01, 1.907326e+00, 5.899872e-02,
    3.226196e-02, 1.931122e-02, 4.912686e-02, 2.037596e-03, 5.260642e-03,
    4.347827e-02, 9.293019e-03, 2.499389e-03, 2.863749e-02, 2.168186e-02,
    1.952129e-02, 1.740615e-03, 2.212923e-02, 5.689231e-02, 1.538157e-01,
    3.438735e-02, 2.428651e-01, 3.179598e+00, 2.826661e-02, 1.165826e+01,
    2.880055e-02, 3.223456e-02, 5.549698e-02, 7.194860e-03, 1.437791e-03,
    1.077393e-01, 8.518754e-03, 4.028714e+01, 3.772714e-02, 2.027990e-03,
    5.645355e-03, 9.494095e-02, 7.281758e-02, 8.104411e-03, 2.027819e-02,
    1.676140e-01, 5.190187e-03, 9.170322e-01, 8.651568e-02, 1.501937e-02,
    1.105640e-02, 6.329355e-03
};

/*     double vars[PROTLEN] =  */
/*     { */
/*         80.058435, 68.686109, 52.881181, 40.386666, 25.835760, 14.463241,  5.635496,  0.860140,  0.253389,  0.134224, */
/*          0.063120,  0.110445,  0.040397,  0.020041,  0.032696,  0.028820,  0.037114,  0.020125,  0.016056,  0.015035, */
/*          0.018088,  0.016750,  0.014714,  0.033482,  0.019304,  0.019573,  0.029238,  0.035231,  0.086287,  0.170425, */
/*          0.254145,  0.445542,  0.479989,  0.286341,  0.254984,  0.098763,  0.046304,  0.018421,  0.014904,  0.014127, */
/*          0.014518,  0.013132,  0.021864,  0.063105,  0.121133,  0.031659,  0.023586,  0.018720,  0.018023,  0.015087, */
/*          0.013685,  0.014129,  0.023615,  0.020292,  0.015396,  0.016640,  0.014133,  0.014423,  0.035111,  0.049323, */
/*          0.036059,  0.029266,  0.077555,  0.152862,  0.158790,  0.256059,  4.890281 */
/*     }; */

#endif
