/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/input/now.cc
 */

#ifndef COMMON_TAR_INPUT_NOW_H
#define COMMON_TAR_INPUT_NOW_H

#include <tar/input/filter.h>

/**
  * The tar_input_filter_now class is used to represent a filter which
  * set the file last modifiied time in tar archive file headers.
  */
class tar_input_filter_now:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_now();

    /**
      * The constructor.
      *
      * \param deeper
      *     The input stream to apply the filter to.
      */
    tar_input_filter_now(tar_input *deeper);

    // See base class for documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The mtime instance variable is used to remember the last time
      * modified to be set in each file header in the tar archive.
      */
    long mtime;

    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_now();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_now(const tar_input_filter_now &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_now &operator = (const tar_input_filter_now &);
};

#endif /* COMMON_TAR_INPUT_NOW_H */
