/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tapioca/core/tpa-manager.h>
#include <tapioca/core/tpa-account.h>
#include <tapioca/core/tpa-ifaces.h>
#include <tapioca/base/tpa-errors.h>
#include <tapioca/base/tpa-debug.h>

#include <glib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <signal.h>
#include <sys/types.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define MANAGER_TYPE             (manager_get_type())
#define MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), MANAGER_TYPE, Manager))
#define MANAGER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass), MANAGER_TYPE, ManagerClass))
#define IS_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), MANAGER_TYPE))
#define IS_MANAGER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass), MANAGER_TYPE))
#define MANAGER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), MANAGER_TYPE, ManagerClass))
#define MANAGER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), MANAGER_TYPE, ManagerPrivate))

typedef struct _Manager      Manager;
typedef struct _ManagerClass ManagerClass;

struct _ManagerClass {
    TpaManagerClass parent_class;
};

struct _Manager {
    TpaManager parent;
};

GType manager_get_type (void);

G_END_DECLS

static TpaError manager_request_connection      (GObject *obj,
                                                 const gchar *protocol,
                                                 GHashTable *parameters,
                                                 gchar **name);

G_DEFINE_TYPE(Manager, manager, TPA_TYPE_MANAGER)

static void
manager_class_init (ManagerClass *klass)
{
    GObjectClass *gobject_class = NULL;

    gobject_class = (GObjectClass *) klass;
}

static void
manager_init (Manager *manager)
{
    TpaIConnectionManager *iface = TPA_ICONNECTION_MANAGER (manager);

    iface->request_connection = manager_request_connection;
}

static TpaError
manager_request_connection (GObject *obj,
                            const gchar *protocol,
                            GHashTable *parameters,
                            gchar **name)
{
    g_debug ("(%p, %s, %p, %p)", obj, protocol, parameters, name);
    return TPA_ERROR_NOT_IMPLEMENTED;
}

/* variables */
static GMainLoop *mainloop;
static Manager *manager;

int main (int argc, char **argv)
{
    const gchar *protocols[2] = { "manager", NULL };

    g_type_init ();
    mainloop = g_main_loop_new (NULL, FALSE);

    tpa_debug_set_flags_from_env ();

    manager = MANAGER (tpa_manager_new (MANAGER_TYPE, "manager", protocols));
    g_debug ("(%p) Creating %s service... ", manager, DBUS_CONNECTION_MANAGER_IFACE);
    if (manager) {
        tpa_manager_add_string_param (TPA_MANAGER (manager), "account", 1, "foo@bar.com");
        tpa_manager_add_string_param (TPA_MANAGER (manager), "password", 0, "");
        tpa_manager_add_string_param (TPA_MANAGER (manager), "server", 0, "jabber.org");
        tpa_manager_add_string_param (TPA_MANAGER (manager), "resource", 0, "foo");
        g_debug ("OK");
        g_debug ("Listening...");
        g_main_run (mainloop);
    }

    return 0;
}
