/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tapioca/core/tpa-manager.h>
#include <tapioca/core/tpa-connection-manager-private.h>
#include <tapioca/core/tpa-account.h>
#include <tapioca/core/tpa-connection-private.h>
#include <tapioca/core/tpa-aliasing-private.h>
#include <tapioca/core/tpa-avatars-private.h>
#include <tapioca/core/tpa-capabilities-private.h>
#include <tapioca/core/tpa-contact-info-private.h>
#include <tapioca/core/tpa-forwarding-private.h>
#include <tapioca/core/tpa-presence-private.h>
#include <tapioca/core/tpa-properties-private.h>
#include <tapioca/core/tpa-session.h>
#include <tapioca/core/tpa-channel-private.h>
#include <tapioca/core/tpa-text-private.h>
#include <tapioca/core/tpa-group-private.h>
#include <tapioca/core/tpa-ice-private.h>

#include <glib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <signal.h>
#include <sys/types.h>

#define _DBUS_SERVICE "org.freedesktop.Telepathy"

/* variables */
static GMainLoop *mainloop;
static TpaManager *manager;
static TpaAccount *account;
static TpaSession *session;

int main (int argc, char **argv)
{
    GError *error = NULL;
    guint *ret = g_new0 (guint, 1);
    const gchar *protocols[2] = { "manager", NULL };

    g_type_init ();
    mainloop = g_main_loop_new (NULL, FALSE);

    tpa_debug_set_flags_from_env ();

    // TODO: Test cases.
    manager = tpa_manager_new (TPA_TYPE_MANAGER, "manager", protocols);
    g_debug ("(%p) Testing %s.ConnectionManager core API... ", manager, _DBUS_SERVICE);
    if (manager) {
        tpa_manager_add_string_param (manager, "account", 1, "foo@bar.com");
        tpa_manager_add_string_param (manager, "password", 0, "");
        tpa_manager_add_string_param (manager, "server", 0, "jabber.org");
        tpa_manager_add_string_param (manager, "resource", 0, "foo");
        /* Test ConnectionManager interface methods */
        tpa_connection_manager_request_connection (G_OBJECT (manager),
            "core",
            NULL,
            NULL,
            NULL,
            &error);
        if (error)
            g_error_free (error);
        error = NULL;
        tpa_connection_manager_get_parameters (G_OBJECT (manager), "manager", NULL, &error);
        if (error)
            g_error_free (error);
        error = NULL;
        tpa_connection_manager_list_protocols (G_OBJECT (manager), NULL, &error);
        if (error)
            g_error_free (error);
        error = NULL;

        /* Test ConnectionManager interface signals */
        account = tpa_account_new (TPA_TYPE_ACCOUNT, manager, NULL, "protocol", "account");
        g_debug ("(%p) Testing %s.Connection core API... ", account, _DBUS_SERVICE);
        if (account) {
            /* Test Connection interface methods */
            tpa_connection_connect (G_OBJECT (account), &error);
            if (error)
                g_error_free (error);
            error = NULL;

            tpa_connection_disconnect (G_OBJECT (account), &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_get_interfaces (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_get_protocol (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_get_self_handle (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_get_status (G_OBJECT (account), ret, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_hold_handles (G_OBJECT (account), 0, NULL, NULL);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_inspect_handles (G_OBJECT (account), 0, NULL, NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_list_channels (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_release_handles (G_OBJECT (account), 0, 0, NULL);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_request_channel (G_OBJECT (account), NULL, 0, 0, FALSE, NULL);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_connection_request_handles (G_OBJECT (account), 0, NULL, NULL);
            if (error)
                g_error_free (error);
            error = NULL;

            g_debug ("(%p) Testing %s.Connection.Interface.Aliasing core API... ", account, _DBUS_SERVICE);
            tpa_aliasing_get_alias_flags (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_aliasing_request_aliases (G_OBJECT (account), NULL, NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_aliasing_set_aliases (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;

            g_debug ("(%p) Testing %s.Connection.Interface.Avatars core API... ", account, _DBUS_SERVICE);
            tpa_avatars_get_avatar_requirements (G_OBJECT (account), NULL, NULL, NULL, NULL, NULL, NULL,&error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_avatars_get_avatar_tokens (G_OBJECT (account), NULL, NULL);
            tpa_avatars_request_avatar (G_OBJECT (account), 0, NULL);
            tpa_avatars_set_avatar (G_OBJECT (account), NULL, NULL, NULL);

            g_debug ("(%p) Testing %s.Connection.Interface.Capabilities core API... ", account, _DBUS_SERVICE);
            tpa_capabilities_advertise_capabilities (G_OBJECT (account), NULL, NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_capabilities_get_capabilities (G_OBJECT (account), 0, NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;

            g_debug ("(%p) Testing %s.Connection.Interface.ContactInfo core API... ", account, _DBUS_SERVICE);
            tpa_contact_info_request_contact_info (G_OBJECT (account), 0, &error);
            if (error)
                g_error_free (error);
            error = NULL;

            g_debug ("(%p) Testing %s.Connection.Interface.Forwarding core API... ", account, _DBUS_SERVICE);
            tpa_forwarding_get_forwarding_handle (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_forwarding_set_forwarding_handle (G_OBJECT (account), 0, &error);
            if (error)
                g_error_free (error);
            error = NULL;

            g_debug ("(%p) Testing %s.Connection.Interface.Presence core API... ", account, _DBUS_SERVICE);
            tpa_presence_add_status (G_OBJECT (account), NULL, NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_presence_clear_status (G_OBJECT (account), &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_presence_get_statuses (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_presence_request_presence (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_presence_remove_status (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_presence_set_last_activity_time (G_OBJECT (account), 0, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_presence_set_status (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;

            g_debug ("(%p) Testing %s.Properties core API... ", account, _DBUS_SERVICE);
            tpa_properties_get_properties (G_OBJECT (account), NULL, NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;
            tpa_properties_set_properties (G_OBJECT (account), NULL, NULL);
            tpa_properties_list_properties (G_OBJECT (account), NULL, &error);
            if (error)
                g_error_free (error);
            error = NULL;

            /* Test Channel interface signals */

            session = tpa_text_session_new (TPA_TYPE_SESSION, account, NULL, "manager", "name");
            g_debug ("(%p) Testing %s.Channel core API... ", session, _DBUS_SERVICE);
            if (session) {
                tpa_channel_close (G_OBJECT (session), &error);
                if (error)
                    g_error_free (error);
                error = NULL;
                tpa_channel_get_channel_type (G_OBJECT (session), NULL, &error);
                if (error)
                    g_error_free (error);
                error = NULL;
                tpa_channel_get_handle (G_OBJECT (session), NULL, NULL, &error);
                if (error)
                    g_error_free (error);
                error = NULL;
                tpa_channel_get_interfaces (G_OBJECT (session), NULL, &error);
                if (error)
                    g_error_free (error);
                error = NULL;

                g_debug ("(%p) Testing %s.Channel.Interface.Text core API... ", session, _DBUS_SERVICE);
                tpa_text_acknowledge_pending_messages (G_OBJECT (session), NULL, &error);
                if (error)
                    g_error_free (error);
                error = NULL;
                tpa_text_list_pending_messages (G_OBJECT (session), FALSE, NULL, &error);
                if (error)
                    g_error_free (error);
                error = NULL;
                tpa_text_get_message_types (G_OBJECT (session), NULL, &error);
                if (error)
                    g_error_free (error);
                error = NULL;
                tpa_text_send (G_OBJECT (session), -1, "text", &error);
                if (error)
                    g_error_free (error);
                error = NULL;
            }
        }
    }

    return 0;
}
