/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_TEXT_H__
#define __TPA_TEXT_H__

#include <tapioca/base/tpa-errors.h>
#include <tapioca/base/tpa-enums.h>

G_BEGIN_DECLS

typedef struct _TpaIText TpaIText;
typedef struct _TpaITextPrivate TpaITextPrivate;

struct _TpaIText {
    GTypeInterface parent;

    TpaError    (* acknowledge_pending_messages)
                                            (GObject *obj,
                                             const GArray *ids);
    TpaError    (* list_pending_messages)   (GObject *obj,
                                             gboolean clear,
                                             GPtrArray **ret);
    TpaError    (* get_message_types)       (GObject *obj,
                                             GArray **ret);
    TpaError    (* send)                    (GObject *obj,
                                             TpaTextChannelMessageType type,
                                             const gchar *text);
    TpaError    (* set_chat_state)          (GObject *obj,
                                             guint state);
    TpaITextPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_ITEXT \
    (tpa_text_get_type ())
#define TPA_IS_ITEXT(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_ITEXT))
#define TPA_ITEXT(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_ITEXT, TpaIText))

GType       tpa_text_get_type                   (void);
void        tpa_text_init                       (TpaIText *iface,
                                                 gpointer data);
void        tpa_text_finalize                   (GObject *obj);
guint       tpa_text_get_message_index          (GObject *obj,
                                                 guint id);
void        tpa_text_signal_lost_message        (GObject *obj);
void        tpa_text_signal_received            (GObject *obj,
                                                 guint id,
                                                 const gchar *contact,
                                                 TpaTextChannelMessageType type,
                                                 guint flags,
                                                 const gchar *text);
void        tpa_text_signal_send_error          (GObject *obj,
                                                 guint error,
                                                 TpaTextChannelMessageType type,
                                                 const gchar *text);
void        tpa_text_signal_sent                (GObject *obj,
                                                 TpaTextChannelMessageType type,
                                                 const gchar *text);

G_END_DECLS

#endif /* #ifndef __TPA_TEXT_H__*/
