/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_TEXT_PRIVATE_H__
#define __TPA_TEXT_PRIVATE_H__

gboolean        tpa_text_acknowledge_pending_messages
                                                (GObject *obj,
                                                 const GArray *ids,
                                                 GError **error);
gboolean        tpa_text_list_pending_messages  (GObject *obj,
                                                 gboolean clear,
                                                 GPtrArray **ret,
                                                 GError **error);
gboolean        tpa_text_get_message_types      (GObject *obj,
                                                 GArray **ret,
                                                 GError **error);
gboolean        tpa_text_send                   (GObject *obj,
                                                 guint type,
                                                 const gchar *text,
                                                 GError **error);
void            tpa_chat_state_set_chat_state   (GObject *obj,
                                                 guint state);

#endif /* #ifndef __TPA_TEXT_PRIVATE_H__*/
