/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ROOM_LIST_H__
#define __TPA_ROOM_LIST_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIRoomList TpaIRoomList;
typedef struct _TpaRoomListPrivate TpaIRoomListPrivate;

struct _TpaIRoomList {
    GTypeInterface parent;

    TpaError    (* get_listing_rooms)       (GObject *obj,
                                             gboolean *ret);
    TpaError    (* list_rooms)              (GObject *obj);
    TpaIRoomListPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IROOM_LIST \
    (tpa_room_list_get_type ())
#define TPA_IS_IROOM_LIST(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IROOM_LIST))
#define TPA_IROOM_LIST(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IROOM_LIST, TpaIRoomList))

GType       tpa_room_list_get_type              (void);
void        tpa_room_list_init                  (TpaIRoomList *iface,
                                                 gpointer data);
void        tpa_room_list_finalize              (GObject *obj);
void        tpa_room_list_signal_got_rooms      (GObject *obj,
                                                 GPtrArray *rooms);
void        tpa_room_list_signal_listing_rooms  (GObject *obj,
                                                 gboolean rooms);
G_END_DECLS

#endif /* #ifndef __TPA_ROOM_LIST_H__*/
