/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MEDIA_H__
#define __TPA_MEDIA_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIMedia TpaIMedia;
typedef struct _TpaMediaPrivate TpaIMediaPrivate;

struct _TpaIMedia {
    GTypeInterface parent;

    TpaError    (* list_streams)            (GObject *obj,
                                             GPtrArray **ret);
    TpaError    (* request_streams)         (GObject *obj,
                                             gchar *string,
                                             const GArray *types,
                                             GArray **ret);
    TpaError    (* remove_streams)          (GObject *obj,
                                             GArray *stream_list);
    TpaIMediaPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IMEDIA \
    (tpa_media_get_type ())
#define TPA_IS_IMEDIA(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IMEDIA))
#define TPA_IMEDIA(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IMEDIA, TpaIMedia))

GType       tpa_media_get_type                  (void);
void        tpa_media_init                      (TpaIMedia *iface,
                                                 gpointer data);
void        tpa_media_finalize                  (GObject *obj);
void        tpa_media_signal_stream_added       (GObject *obj,
                                                 guint stream_id,
                                                 guint contact_id,
                                                 guint stream_type);
void        tpa_media_signal_stream_removed     (GObject *obj,
                                                 guint stream_id);
void        tpa_media_signal_stream_state_changed
                                                (GObject *obj,
                                                 guint stream_id,
                                                 guint stream_state);
G_END_DECLS

#endif /* #ifndef __TPA_MEDIA_H__*/
