/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_GROUP_H__
#define __TPA_GROUP_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaGroup TpaGroup;
typedef struct _TpaIGroup TpaIGroup;
typedef struct _TpaIGroupPrivate TpaIGroupPrivate;

struct _TpaIGroup {
    GTypeInterface parent;

    TpaError    (* add_members)             (GObject *obj,
                                             const GArray *constants,
                                             const gchar *message);
    TpaError    (* remove_members)          (GObject *obj,
                                             const GArray *constants,
                                             const gchar *message);
    TpaError    (* get_all_members)         (GObject *obj,
                                             GArray **ret,
                                             GArray **ret1,
                                             GArray **ret2);
    TpaError    (* get_group_flags)         (GObject *obj,
                                             guint *ret);
    TpaError    (* get_local_pending_members)
                                            (GObject *obj,
                                             GArray **ret);
    TpaError    (* get_remote_pending_members)
                                            (GObject *obj,
                                             GArray **ret);
    TpaError    (* get_members)
                                            (GObject *obj,
                                             GArray **ret);
    TpaIGroupPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IGROUP \
    (tpa_group_get_type ())
#define TPA_IS_IGROUP(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IGROUP))
#define TPA_IGROUP(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IGROUP, TpaIGroup))

GType       tpa_group_get_type                  (void);
void        tpa_group_init                      (TpaIGroup *obj,
                                                 gpointer data);
void        tpa_group_finalize                  (GObject *obj);
void        tpa_group_signal_group_flags_changed
                                                (GObject *obj,
                                                 guint added,
                                                 guint removed);
void        tpa_group_signal_members_changed    (GObject *obj,
                                                 const gchar *message,
                                                 GArray *added,
                                                 GArray *removed,
                                                 GArray *local_pending,
                                                 GArray *remote_pending,
                                                 const gchar *actor,
                                                 guint reason);
#define     tpa_group_signal_members_added(obj, added, actor, reason) \
    (tpa_group_signal_members_changed (obj, \
    added, \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    actor, \
    reason))
#define     tpa_group_signal_members_removed(obj, removed, actor, reason) \
    (tpa_group_signal_members_changed (obj, \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    removed, \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    actor, \
    reason))
#define     tpa_group_signal_members_local_pending(obj, local_pending, actor, reason) \
    (tpa_group_signal_members_changed (obj, \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    local_pending, \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    actor, \
    reason))
#define     tpa_group_signal_members_remote_pending(obj, remote_pending, actor, reason) \
    (tpa_group_signal_members_changed (obj, \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    g_array_new (FALSE, TRUE, sizeof (guint)), \
    remote_pending, \
    actor, \
    reason))
G_END_DECLS

#endif /* #ifndef __TPA_GROUP_H__*/
