/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"

#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#include "tpa-forwarding.h"

#include "tpa-forwarding-private.h"

#define DEBUG_DOMAIN TPA_DOMAIN_FORWARDING

#include <tapioca/base/tpa-signals-marshal.h>
#include <tapioca/base/tpa-debug.h>
#include <tapioca/base/tpa-errors.h>

/* signal enum */
enum
{
    FORWARDING_CHANGED,
    LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = {0};

struct _TpaIForwardingPrivate {
    GObject *object;
};

/* we need to define the get_type function */
GType
tpa_forwarding_get_type()
{
    static GType object_type = 0;

    if (!object_type) {
        static const GTypeInfo object_info = {
            sizeof(TpaIForwarding),
            NULL,	/* base init */
            NULL,	/* base finalize */
        };
        object_type =
            g_type_register_static(G_TYPE_INTERFACE,
                "TpaIForwarding",
                &object_info, 0);
    }
    return object_type;
}

void
tpa_forwarding_init (TpaIForwarding *iface,
                           gpointer data)
{
    VERBOSE ("(%p, %p)", iface, data);

    iface->get_forwarding_handle = NULL;
    iface->set_forwarding_handle = NULL;

    /* Interface signals */
    signals[FORWARDING_CHANGED] =
        g_signal_new ("forwarding-changed",
                      G_OBJECT_CLASS_TYPE (iface),
                      G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED,
                      0,
                      NULL, NULL,
                      g_cclosure_marshal_VOID__UINT,
                      G_TYPE_NONE, 1, G_TYPE_UINT);
    iface->priv = g_new0 (TpaIForwardingPrivate, 1);
}

void
tpa_forwarding_finalize (GObject *obj)
{
    TpaIForwarding *iface = TPA_IFORWARDING (obj);
    VERBOSE ("(%p)", obj);

    if (iface->priv)
        g_free (iface->priv);
}

/**
 * tpa_forwarding_get_forwarding_handle
 *
 * Implements DBus method GetForwardingHandle
 * on interface org.freedesktop.Telepathy.Connection.Interface.Forwarding
 *
 * @error: Used to return a pointer to a GError detailing any error
 *         that occured, DBus will throw the error only if this
 *         function returns false.
 *
 * @return: TRUE if successful, FALSE if an error was thrown.
 */
gboolean
tpa_forwarding_get_forwarding_handle (GObject *obj,
                                      guint *handle,
                                      GError **error)
{
    TpaIForwarding *iface = TPA_IFORWARDING (obj);
    TpaError error_code = TPA_ERROR_NONE;

    g_return_error_val_if_fail (iface->priv != NULL, error, TPA_ERROR_NOT_IMPLEMENTED);

    VERBOSE ("(%p)", obj);

    g_return_error_val_if_fail (iface->get_forwarding_handle != NULL, error, TPA_ERROR_NOT_IMPLEMENTED);

    error_code = iface->get_forwarding_handle (obj, handle);

    g_return_error_val_if_fail (error_code == TPA_ERROR_NONE, error, error_code);

    return TRUE;
}

/**
 * tpa_forwarding_set_forwarding_handle
 *
 * Implements DBus method SetForwardingHandle
 * on interface org.freedesktop.Telepathy.Connection.Interface.Forwarding
 *
 * @error: Used to return a pointer to a GError detailing any error
 *         that occured, DBus will throw the error only if this
 *         function returns false.
 *
 * @return: TRUE if successful, FALSE if an error was thrown.
 */
gboolean
tpa_forwarding_set_forwarding_handle (GObject *obj,
                                      guint handle,
                                      GError **error)
{
    TpaIForwarding *iface = TPA_IFORWARDING (obj);
    TpaError error_code = TPA_ERROR_NONE;

    g_return_error_val_if_fail (iface->priv != NULL, error, TPA_ERROR_NOT_IMPLEMENTED);

    VERBOSE ("(%p)", obj);

    g_return_error_val_if_fail (iface->set_forwarding_handle != NULL, error, TPA_ERROR_NOT_IMPLEMENTED);

    error_code = iface->set_forwarding_handle (obj, handle);

    g_return_error_val_if_fail (error_code == TPA_ERROR_NONE, error, error_code);

    return TRUE;
}

/**
 * tpa_forwarding_signal_forwarding_changed
 *
 * Implements DBus signal ForwardingChanged
 * on interface org.freedesktop.Telepathy.Connection.Interface.Forwarding
 */
void
tpa_forwarding_signal_forwarding_changed (GObject *obj,
                                          guint forward_to)
{
    TpaIForwarding *iface = TPA_IFORWARDING (obj);

    if (!iface)
        return;

    VERBOSE ("(%p)", obj);

    g_signal_emit (iface, signals[FORWARDING_CHANGED], 0, forward_to);
}
