/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONTACT_INFO_H__
#define __TPA_CONTACT_INFO_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIContactInfo TpaIContactInfo;
typedef struct _TpaIContactInfoPrivate TpaIContactInfoPrivate;

struct _TpaIContactInfo {
    GTypeInterface parent;

    TpaError (* request_contact_info)       (GObject *obj,
                                             guint contact);
    TpaIContactInfoPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_ICONTACT_INFO \
    (tpa_contact_info_get_type ())
#define TPA_IS_ICONTACT_INFO(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_ICONTACT_INFO))
#define TPA_ICONTACT_INFO(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_ICONTACT_INFO, TpaIContactInfo))

GType       tpa_contact_info_get_type           (void);
void        tpa_contact_info_init               (TpaIContactInfo *iface,
                                                 gpointer init);
void        tpa_contact_info_finalize           (GObject *obj);
void        tpa_contact_info_signal_got_contact_info
                                                (GObject *obj,
                                                 guint contact,
                                                 const gchar *vcard);

G_END_DECLS

#endif /* #ifndef __TPA_CONTACT_INFO_H__*/
