/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_USER_CONTACT_H__
#define __TPA_USER_CONTACT_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-contact-base.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_USER_CONTACT \
    (tpa_user_contact_get_type())
#define TPA_USER_CONTACT(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_USER_CONTACT, TpaUserContact))
#define TPA_USER_CONTACT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_USER_CONTACT, TpaUserContactClass))
#define TPA_IS_USER_CONTACT(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_USER_CONTACT))
#define TPA_IS_USER_CONTACT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_USER_CONTACT))
#define TPA_USER_CONTACT_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_USER_CONTACT, TpaUserContactClass))
#define TPA_USER_CONTACT_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_USER_CONTACT, TpaUserContactPrivate))

typedef struct _TpaUserContact TpaUserContact;
typedef struct _TpaUserContactClass TpaUserContactClass;
typedef struct _TpaUserContactPrivate TpaUserContactPrivate;

struct _TpaUserContactClass {
    TpaContactBaseClass parent_class;
};

struct _TpaUserContact {
    TpaContactBase parent;
    TpaUserContactPrivate *priv;
};

GType               tpa_user_contact_get_type           (void);
gboolean            tpa_user_contact_set_avatar         (TpaUserContact *self,
                                                         TpaAvatar *avatar);
gboolean            tpa_user_contact_set_presence       (TpaUserContact *self,
                                                         TpaContactPresence presence);
gboolean            tpa_user_contact_set_presence_message
                                                        (TpaUserContact *self,
                                                         const gchar *message);
gboolean            tpa_user_contact_set_presence_with_message
                                                        (TpaUserContact *self,
                                                         TpaContactPresence presence,
                                                         const gchar *message);
gboolean            tpa_user_contact_set_alias          (TpaUserContact *self,
                                                         const gchar *alias);
gboolean            tpa_user_contact_set_alias          (TpaUserContact *self,
                                                         const gchar *alias);
gboolean            tpa_user_contact_set_capabilities   (TpaUserContact *self,
                                                         TpaCapability capability);

G_END_DECLS

#endif /* #ifndef __TPA_USER_CONTACT_H__*/
