/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MANAGER_FACTORY_H__
#define __TPA_MANAGER_FACTORY_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-manager.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_MANAGER_FACTORY \
    (tpa_manager_factory_get_type())
#define TPA_MANAGER_FACTORY(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_MANAGER_FACTORY, TpaManagerFactory))
#define TPA_MANAGER_FACTORY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_MANAGER_FACTORY, TpaManagerFactoryClass))
#define TPA_IS_CM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_MANAGER_FACTORY))
#define TPA_IS_CM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_MANAGER_FACTORY))
#define TPA_MANAGER_FACTORY_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_MANAGER_FACTORY, TpaManagerFactoryClass))
#define TPA_MANAGER_FACTORY_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_MANAGER_FACTORY, TpaManagerFactoryPrivate))

typedef struct _TpaManagerFactory TpaManagerFactory;
typedef struct _TpaManagerFactoryClass TpaManagerFactoryClass;
typedef struct _TpaManagerFactoryPrivate TpaManagerFactoryPrivate;

struct _TpaManagerFactoryClass {
    GObjectClass parent_class;
};

struct _TpaManagerFactory {
    GObject parent;
    TpaManagerFactoryPrivate *priv;
};

GType               tpa_manager_factory_get_type        (void);
TpaManagerFactory * tpa_manager_factory_new             (void);
void                tpa_manager_factory_reload          (TpaManagerFactory *self);
GPtrArray *         tpa_manager_factory_get_all_managers
                                                        (TpaManagerFactory *self);
GPtrArray *         tpa_manager_factory_get_all_profiles
                                                        (TpaManagerFactory *self);
GPtrArray *         tpa_manager_factory_get_managers    (TpaManagerFactory *self,
                                                         const gchar *protocol);
TpaManager *        tpa_manager_factory_get_manager     (TpaManagerFactory *self,
                                                         const gchar *protocol);
TpaManager *        tpa_manager_factory_get_manager_by_name
                                                        (TpaManagerFactory *self,
                                                         const gchar *name);

G_END_DECLS

#endif /* #ifndef __TPA_MANAGER_FACTORY_H__*/
