/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONTACT_H__
#define __TPA_CONTACT_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-contact-base.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CONTACT \
    (tpa_contact_get_type())
#define TPA_CONTACT(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CONTACT, TpaContact))
#define TPA_CONTACT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CONTACT, TpaContactClass))
#define TPA_IS_CONTACT(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CONTACT))
#define TPA_IS_CONTACT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CONTACT))
#define TPA_CONTACT_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CONTACT, TpaContactClass))
#define TPA_CONTACT_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CONTACT, TpaContactPrivate))

typedef struct _TpaContact TpaContact;
typedef struct _TpaContactClass TpaContactClass;
typedef struct _TpaContactPrivate TpaContactPrivate;

struct _TpaContactClass {
    TpaContactBaseClass parent_class;
};

struct _TpaContact {
    TpaContactBase parent;
    TpaContactPrivate *priv;
};

GType               tpa_contact_get_type                (void);
TpaSubscriptionStatus
                    tpa_contact_get_subscription_status (TpaContact *self);
void                tpa_contact_subscribe               (TpaContact *self,
                                                         gboolean value);
TpaAuthorizationStatus
                    tpa_contact_get_authorization_status(TpaContact *self);
void                tpa_contact_authorize               (TpaContact *self,
                                                         gboolean value);
void                tpa_contact_hide                    (TpaContact *self,
                                                         gboolean value);
gboolean            tpa_contact_is_hidden               (TpaContact *self);
void                tpa_contact_block                   (TpaContact *self,
                                                         gboolean value);
gboolean            tpa_contact_is_blocked              (TpaContact *self);

G_END_DECLS

#endif /* #ifndef __TPA_CONTACT_H__*/
