/*
 * Tapioca library
 * Copyright (C) 2006 INdT
 * @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ENUMS_H__
#define __TPA_ENUMS_H__

#include <glib.h>

G_BEGIN_DECLS

/* Connection status */
typedef enum {
    TPA_CONNECTION_STATUS_CONNECTED = 0,
    TPA_CONNECTION_STATUS_CONNECTING = 1,
    TPA_CONNECTION_STATUS_DISCONNECTED = 2,
    TPA_CONNECTION_STATUS_LAST = TPA_CONNECTION_STATUS_DISCONNECTED
} TpaConnectionStatus;



/* Connection status reason */
typedef enum {
    TPA_CONNECTION_STATUS_REASON_NONE_SPECIFIED = 0,
    TPA_CONNECTION_STATUS_REASON_REQUESTED,
    TPA_CONNECTION_STATUS_REASON_NETWORK_ERROR,
    TPA_CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED,
    TPA_CONNECTION_STATUS_REASON_ENCRYPTION_ERROR,
    TPA_CONNECTION_STATUS_REASON_NAME_IN_USE,
    TPA_CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED,
    TPA_CONNECTION_STATUS_REASON_CERT_UNTRUSTED,
    TPA_CONNECTION_STATUS_REASON_CERT_EXPIRED,
    TPA_CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED,
    TPA_CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH,
    TPA_CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH,
    TPA_CONNECTION_STATUS_REASON_CERT_SELF_SIGNED,
    TPA_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR,
    TPA_CONNECTION_STATUS_REASON_LAST = TPA_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR
} TpaConnectionStatusReason;

/* Connection presence types */
typedef enum {
    TPA_CONNECTION_PRESENCE_TYPE_OFFLINE = 1,
    TPA_CONNECTION_PRESENCE_TYPE_AVAILABLE,
    TPA_CONNECTION_PRESENCE_TYPE_AWAY,
    TPA_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY,
    TPA_CONNECTION_PRESENCE_TYPE_HIDDEN,
    TPA_CONNECTION_PRESENCE_TYPE_LAST = TPA_CONNECTION_PRESENCE_TYPE_HIDDEN
} TpaConnectionPresenceType;

/* Handle types */
typedef enum {
    TPA_CONNECTION_HANDLE_TYPE_NONE = 0,
    TPA_CONNECTION_HANDLE_TYPE_CONTACT,
    TPA_CONNECTION_HANDLE_TYPE_ROOM,
    TPA_CONNECTION_HANDLE_TYPE_LIST,
    TPA_CONNECTION_HANDLE_TYPE_LAST = TPA_CONNECTION_HANDLE_TYPE_LIST
} TpaConnectionHandleType;

/* Channel types */
typedef enum {
    TPA_CHANNEL_TYPE_CONTACTLIST = 0,
    TPA_CHANNEL_TYPE_CONTACTSEARCH,
    TPA_CHANNEL_TYPE_STREAMEDMEDIA,
    TPA_CHANNEL_TYPE_ROOMLIST,
    TPA_CHANNEL_TYPE_TEXT,
    TPA_CHANNEL_TYPE_LAST = TPA_CHANNEL_TYPE_TEXT
} TpaChannelType;


/* Channel Text Message Types */
typedef enum {
    TPA_CHANNEL_TEXT_MESSAGE_TYPE_NORMAL = 0,
    TPA_CHANNEL_TEXT_MESSAGE_TYPE_ACTION,
    TPA_CHANNEL_TEXT_MESSAGE_TYPE_NOTICE,
    TPA_CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY,
    TPA_CHANNEL_TEXT_MESSAGE_TYPE_LAST = TPA_CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY
} TpaTextChannelMessageType;

/* Channel Group flags */
typedef enum {
    TPA_CHANNEL_GROUP_FLAG_CAN_ADD = 1,
    TPA_CHANNEL_GROUP_FLAG_CAN_REMOVE = 2,
    TPA_CHANNEL_GROUP_FLAG_CAN_RESCIND = 4,
    TPA_CHANNEL_GROUP_FLAG_MESSAGE_ADD = 8,
    TPA_CHANNEL_GROUP_FLAG_MESSAGE_REMOVE = 16,
    TPA_CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT = 32,
    TPA_CHANNEL_GROUP_FLAG_MESSAGE_REJECT = 64,
    TPA_CHANNEL_GROUP_FLAG_MESSAGE_RESCIND = 128,
    TPA_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES = 256,
    TPA_CHANNEL_GROUP_FLAG_LAST = TPA_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES
} TpaChannelGroupFlags;

/* Channel Group change reason */
typedef enum {
    TPA_CHANNEL_GROUP_CHANGE_REASON_NONE = 0,
    TPA_CHANNEL_GROUP_CHANGE_REASON_OFFLINE,
    TPA_CHANNEL_GROUP_CHANGE_REASON_KICKED,
    TPA_CHANNEL_GROUP_CHANGE_REASON_BUSY,
    TPA_CHANNEL_GROUP_CHANGE_REASON_INVITED,
    TPA_CHANNEL_GROUP_CHANGE_REASON_BANNED,
    TPA_CHANNEL_GROUP_CHANGE_REASON_LAST = TPA_CHANNEL_GROUP_CHANGE_REASON_BANNED
} TpaChannelGroupChangeReasons;

#endif
