/* Written by:                                                             */

/* Richard Taylor                                                          */
/* Okanagan University College                                             */
/* Salmon Arm BC, Canada                                                   */

/* Author gives permission for redistribution as long as his name is       */
/* mentioned in the source file.                                           */

/* $Id: subject_sameroom.c,v 1.1 2004/11/26 18:09:52 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Richard Taylor <rtaylor@ouc.bc.ca>
 *
 * DESCRIPTION:
 *
 *  Adds a weight for each tuple of a subject that is scheduled in
 *  a different room. If for example a certain subject is scheduled 
 *  in three different rooms, this module adds two weights. The goal 
 *  is to make the schedule more symmetrical, by having students for 
 *  a certain subject meet in the same room each day, if possible.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include "data.h"

int *su;
int *rm;
int *multiroom;

int init_mod() {

  su = (int *) malloc(sizeof(*su)*smapnum);
  rm = (int *) malloc(sizeof(*rm)*smapnum);
  multiroom = (int *) malloc(sizeof(*multiroom)*smapnum);

  return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,c;
	int flag,sid,rid;
	int sum;
	int nsu;

	nsu=0;                     // initialize number of subjects found

        for(c=0;c<tuplenum;c++) {  // loop through all suject-class pairs
	  rid=t->inf[c].room;      // get room id
	  sid=tuplemap[c].sid;     // get subject id
	  flag=1;                  // flag for addition to list of subjects encountered

	  for (a=0;a<nsu;a++) {
	    if (sid==su[a]) {      // if we've encountered this subject already...
	      flag=0;              // unflag for addition to list of subjects encountered
	      if (rid != rm[a]) multiroom[a]++;  // check if room is same as before
	      break;
	    }
	  }

	  if(flag) {              // if we haven't encountered this subject before...
	    su[nsu]=sid;          // add to list of subjects for this class
	    rm[nsu]=rid;          // store room for this subject
	    multiroom[nsu]=0;     // initialize multiroom flag for this subject
	    nsu++;                // increment number of subjects encountered
	  }

	} // loop over subject-class pairs

	// count number of multiroom subjects
	sum=0;
	for (a=0;a<nsu;a++) {
		sum+=multiroom[a];
	}

	return(sum);
};
