/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: subject_morning.c,v 1.3 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Patrick Cronin <pcronin@loyola.edu>
 *
 *  Minor modifications by Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Scans timetables for predefined classes (tuple ids) and adds a
 *  weight for each predefined class that is NOT in the morning. (Use
 *  this module for serious classes that, if taught in the afternoon,
 *  learners would be sleeping through).
 *
 * DEFINED TUPLE RESTRICTIONS:
 *
 *  Syntax of your config.xml file:
 *
 *  <timetable>
 *    <subject title="MATH" teacher="Cronin" perweek="4">
 *      <restriction type="morning-subject">X</restriction>
 *    </subject>
 *  </timetable>
 *
 *  Where X is the daily period number (from 0 to PERIODS - 1)
 *  that the restricted class should be on or before.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

struct _morning_class {
    int tupleid;
    int max_period;
};
typedef struct _morning_class morning_class;

morning_class * morning_classes;
int number_of_morning_classes;

int remember_tupleid(char *type, char *cont, int tupleid)
{
    int max_period;
    char *endptr;

    if (morning_classes == NULL) {
	morning_classes = (morning_class *) malloc (sizeof(morning_class) * (number_of_morning_classes + 1));
	if (morning_classes == NULL) {
	    strcpy(moderror, _("out of memory"));
	    return(1);
	}
    } else {
	morning_classes = (morning_class *) realloc (morning_classes, sizeof(morning_class) * (number_of_morning_classes + 1));
	if (morning_classes == NULL) {
	    strcpy(moderror, _("out of memory"));
	    return(1);
	}
    }
    
    max_period = (int) strtol(cont, &endptr, 10);

    if(*endptr!='\0'||*cont=='\0') {
	    strcpy(moderror, _("invalid period"));
	    return(1);
    }

    if(max_period<0||max_period>=PERIODS) {
	    strcpy(moderror, _("invalid period"));
	    return(1);
    }

    /* remember that first morning_class is in position 0 */
    morning_classes[number_of_morning_classes].tupleid = tupleid;
    morning_classes[number_of_morning_classes].max_period = max_period;
    number_of_morning_classes++;

    return 0;
}

parop tuple_restrictions[] = { 
	{ type : "morning-subject", parfunc: remember_tupleid },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
    number_of_morning_classes = 0;

    return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
    int sum;
    int i;
    int period, max_period;

    sum=0;
    for (i=0;i<number_of_morning_classes;i++) {
	period = (t->inf[morning_classes[i].tupleid].time) % PERIODS;
	max_period=morning_classes[i].max_period;

	if ( period  > max_period ) {
	    sum = sum + (period - max_period);
	}
    }
    return(sum);
};
