#!/usr/bin/perl

$cvsid='$Id: moddocdb.pl,v 1.2 2004/01/16 21:36:49 avian Exp $';

print <<END;
<?xml version="1.0"?>
<!DOCTYPE article PUBLIC "-//OASIS//DTD DocBook XML V4.2//EN" "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd">

<article>
<articleinfo>
<title>Tablix modules HOWTO, part 2</title>
<author>
<firstname>Tomaz</firstname>
<surname>Solc</surname>
<authorblurb>
<para><email>tomaz.solc\@siol.net</email></para>
</authorblurb>
</author>
<pubdate>
$cvsid
</pubdate>
<abstract>
<para>
As  of  version  0.0.4  Tablix  supports  loadable  modules  that include timetable grading routines. Each module includes one  part  of  the fitness function that is used by the genetic algorithm to select best timetables out of a large search space. This document describes in detail how to use and program new modules to extend Tablix functionality.
</para>
</abstract>
</articleinfo>

<sect1>
<title>Introduction</title>

<para>Tablix comes with a number of modules that are ready for use and provide basic functionality. This section includes documentation for each module that is included in the stable distribution.</para>

<para>You probably won't find all restrictions you want here. See part one of this HOWTO for instructions on how to write your own modules.</para>

<para>If you think your module should be included in the distribution, please send the source code to the above email address.</para>

<para>Modules documented in this document:</para>

<itemizedlist>
END
foreach $module_src (@ARGV) {
	
	$module_src1=$module_src;

	$module_src1=~s/.*\///;

	$module=$module_src1;

	unless($module=~s/\.c/.so/) { die("$0: File name must end in .c"); }

	print <<END;
<listitem><para>
$module
</para></listitem>
END

}
print <<END;
</itemizedlist>
</sect1>
END

foreach $module_src (@ARGV) {

$module_src1=$module_src;

$module_src1=~s/.*\///;

$module=$module_src1;

unless($module=~s/\.c/.so/) { die("$0: File name must end in .c"); }

print <<END;
<sect1>
<title>
$module
</title>

<sect2>
<title>
Source
</title>
<para>
$module_src1
</para>
</sect2>

END

print(STDERR "$module_src\n");

open($INPUT, "<", $module_src);

$write=0;
$comment=0;
$mustclose=0;
$nomore=1;
$para=0;
$listing=0;
while(defined($line=<$INPUT>)&&$nomore) {
	$comment=1 if($line=~/\/\*/); 
	if($line=~/\*\//) {
		$comment=0;
		$nomore=0 if($write);
	}

	next unless($comment);

	if($line=~/AUTHOR:/) { $write=1; }

	next unless($write);

	$short=$line;
	$short=~s/ *\* ?//; 

	if($short!~/^ +\</) {
		if($listing) {
			$listing=0;
			print <<END
</programlisting>
END
		}
	}

	if($short=~/^[A-Z]/) {
		if($mustclose) {
			print <<END;
</sect2>
END
		}
		$short=~s/://;
		$short=reverse($short);
		$f=chop($short);
		$short=$f.lc(reverse($short));
		$mustclose=1;
		print <<END;
<sect2>
<title>
$short
</title>
END
	} elsif($short=~/^ [A-Za-z]/ ) {
		$short=~s/\</<email/;
		$short=~s/\>/<\/email>/;
		$short=~s/\<email/<email>/;
		print("<para>") unless($para);
		$para=1;
		print($short); 
	} elsif($short=~/^ +\</) {
		$short=~s/\>/&gt;/g;
		$short=~s/\</&lt;/g;
		
		unless($listing) {
			$listing=1;
			print <<END;
<programlisting>
END
		}

		print("$short");
	} else {
		if($para) {
			print("</para>\n");
			$para=0;
		} 
	}
}

close($INPUT);

print("</para>\n") if($para);

if($mustclose) {
	print <<END;
</sect2>
END
}

print <<END;
</sect1>
END
}

print("</article>\n");
