# PhotoAlbumReaderPicasa.py 
#  
#  Copyright (c) 2005 INdT (Instituto Nokia de Technologia)
#  
#  Author: Kenneth Rohde Christiansen <kenneth.christiansen@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import os
import Utils
import AlternativePath

def read_albums(album_path):
	albums = []
	album_size = 0
	album_name = u"Unknown"

	path = os.path.expanduser(album_path) 

	if os.path.exists(path) and os.path.isdir(path):
		for current_dir in os.listdir(path):

			if os.path.isdir(os.path.join (path, current_dir)):
				album_name = os.path.basename(current_dir)
				album_location = os.path.join(path, album_name)

				album_size = sum([d.size for d in AlternativePath.path(album_location).walkfiles()]) / 1024

				albums.append( (album_name, album_size, album_location) ) 

	return albums
