/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef APENTRY_H
#define APENTRY_H

#include <qmutex.h>
#include <string.h>
#include <stdio.h>
#include <iostream>

#include <klocale.h>

using namespace std;

class APEntry
{
    private:
	QMutex mut;
        char* MAC;		//BSSID (MAC of the AP)-->unique
        char* essid;		//ESSID 
	char* vendor;		//VENDOR
        int mode;		//0=Master, 1=AdHoc
        bool wep;
        unsigned int channel;
        int signal;		//may be in dBm (negative) or RSSI (positive)
	int noise;
	int signalmax;
	int snrmax;
	float latitude;
	float longitude;

    protected:
	void ErrorMem ();
	char* PutString (char *);
	
    public:
        APEntry();					//constructor
	APEntry(char *m, char *e, int s):MAC(m),essid(e),signal(s) {};	//constructor usec for QStrList
	APEntry( const APEntry & );			//constructor copia
	~APEntry() { delete [] MAC; delete [] essid; delete [] vendor; qDebug("Deleting apentry"); }	//destructor

	void reset();

	void setEssid(char*);
	char* getEssid(char *);

	void setMAC(char*);
	char* getMAC(char *);

	void setVendor(char*);
	char* getVendor(char *);

	void setMode(int);
	int getMode();
	QString getModeString();
	static QString getModeString(int);

	void setWEP(bool);
	bool getWEP();

	void setChannel(unsigned int);
	unsigned int getChannel();

	void setSignal(int);
	int getSignal();

	void setNoise(int);
	int getNoise();

	void setSNRMax(int);
	int getSNRMax();

	void setSignalMax(int);
	int getSignalMax();

	void setLatitude(float);
	float getLatitude();

	void setLongitude(float);
	float getLongitude();

	///////////// OPERATORS ///////////
	APEntry &operator=( const APEntry & );
	
};
#endif
