#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "lib/stemmer.h"


MODULE = SWISH::Stemmer		PACKAGE = SWISH::Stemmer		

PROTOTYPES: DISABLE



SV *
SwishStem(word)
        char *word
    PREINIT:
        char *newword;
        int   length;
        unsigned char *p;
    CODE:
        /* default to undefined */
        ST(0) = sv_newmortal();
        
        length = strlen( word ) + 100;
        newword = (char *)emalloc( length+1 ); /* leak! */
        strcpy( newword, word );

        /* Lower case here -- stemmer expects a lower case word */
        p = newword;
        while (*p) {
            *p = tolower((unsigned char)*p);
            p++;
        }        

        /* set return value only if stem returns OK */
        if ( Stem(&newword, &length) == STEM_OK )
            sv_setpv( ST(0), newword );
        efree( newword );
            


