#ifndef STYLECLOCK_H
#define STYLECLOCK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kpanelapplet.h>
#include <qstring.h>
#include <kconfig.h>
#include <vector>
#include <qdatetime.h>
#include <dcopobject.h>
#include "styleclockwidget/clockappinterface.h"

class ClockPaintView;
class Prefs;
class KPopupMenu;
class AlarmDlg;
class DatePicker;

class StyleClock : public KPanelApplet, public ClockAppInterface, 
    virtual public DCOPObject
{
    Q_OBJECT
    K_DCOP
k_dcop:
    void debugMode(bool);

public:
    StyleClock(const QString& configFile, Type t = Normal, int actions = 0,
        QWidget *parent = 0, const char *name = 0);
    /** destructor */
    ~StyleClock();
    
    virtual int widthForHeight(int height) const;
    virtual int heightForWidth(int width) const;
    virtual void about();
    virtual void help();
    virtual void preferences();
        
    virtual void mousePressEvent(QMouseEvent *e);
    QDateTime getAlarmTime();
        
protected:
    void resizeEvent(QResizeEvent *);
    std::vector<QDateTime> alarmTimeList;
    std::vector<int> timerTimeList;
    
private:
    void updateThemeMenu();
    void setAlarmTime(QDateTime t, bool bAsk=true);
    void toggleCalendar();
    QString secsToString(int t);

    
    QString configFile;
    KConfig *ksConfig;
    ClockPaintView *mainView;
    Prefs* prefs;
    KPopupMenu* contextMenu;
    KPopupMenu* themeMenu;
    KPopupMenu* timerMenu;
    KPopupMenu* alarmMenu;
    QDateTime alarmTime;
    int cancelAlarmItemIndex;
    AlarmDlg *alarmDlg;
    DatePicker *datePicker;
    
private slots:
    void slotShowPreferences();
    void slotApplySettings();
    void slotThemesMenuClicked(int n);
    void slotAboutToShowThemeMenu();
    void slotAboutToShowAlarmMenu();
    void slotAboutToShowTimerMenu();
    void slotAboutToShowContextMenu();
    void slotTimerMenuClicked(int n);
    void slotAlarmMenuClicked(int n);
    void showStartAlarmDialog(QDateTime initialTime);
    void showStartTimerDialog(int initialTime);
    void slotCustomTimer();
    void slotCustomAlarm();
    void slotCancelAlarm();
    void slotAlarm();
    void slotClockSizeSuggestionChanged();
    void slotDatePickerDeleted();
};

#endif
