#ifndef _UTIL_H
#define _UTIL_H 1

// It seems Windows does not have this function... how odd
#ifndef strndup
inline char *strndup(const char *src, int size) {
	char *dst = (char *)malloc(size + 1);
	strncpy(dst, src, size);
	dst[size] = 0;
	return dst;
}
#endif

inline int strcatlim(char *dst, const char *src, int size) {
	unsigned int left = size - strlen(dst) - 1;	// How much of src we can copy
	if (left < strlen(src)) {
		strncat(dst, src, left);
		return strlen(src) - left;	// Return the amount that didn't get copied
	} else {
		strcat(dst, src);
		return 0;					// Return 0 because we were able to copy it all
	}
}

// Some system headers define these already (notably windef.h)

#ifndef max
inline int max(int a, int b) {
	return (a > b) ? a : b;
}
#endif

#ifndef min
inline int min(int a, int b) {
	return (a < b) ? a : b;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif

char *nstrcat(int n, ...);
char *nstrcat_r(int n, ...);

void ReplaceSpace(char **old);

#ifdef __cplusplus
}
#endif

#endif
