var speeddial_gPrefBranch = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.speeddial.");

function speeddial_initPrefs() {
  if(document.documentElement.getButton && document.documentElement.getButton('extra2')) {
    var extra2 = document.documentElement.getButton('extra2');
    extra2.setAttribute('type', 'menu');
    extra2.setAttribute('popup', 'speeddial-settings-popup');
  }
}

function speeddial_defaultSettings() {
  var strings = document.getElementById("prefsStrings");
  if (!confirm(strings.getString('prefs.confirm'))) return false;

  var count = { value : 0 };
  var childList = speeddial_gPrefBranch.getChildList("", count);

  for (var i = 0; i < count.value; i++) {
    if(speeddial_gPrefBranch.prefHasUserValue(childList[i]) && childList[i] != "changelog") {
      speeddial_gPrefBranch.clearUserPref(childList[i]);
    }
  }

  window.alert(strings.getString('prefs.defaultsuccess'));
  return true;
}

function speeddial_importSettings() {
  var targetFile = speeddial_loadFromFile();
  if(!targetFile) return false;
  
  return importFile(targetFile);
}

function importFile(targetFile) {
  var i;
  var cont;
  var speeddialImport = new Array();
  var appendFilters = null;
  var pattern = new Array();
  var charset = "UTF-8";
  var is = Components.classes["@mozilla.org/intl/converter-input-stream;1"].createInstance(Components.interfaces.nsIConverterInputStream);
  var stream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
  var strings = document.getElementById("prefsStrings");
  var totalImports = 0;

  stream.init(targetFile, 0x01, 0444, null);
  is.init(stream, charset, 1024, 0xFFFD);
  
  if (is instanceof Components.interfaces.nsIUnicharLineInputStream) {
    var line = {};
    do {
      cont = is.readLine(line);
      pattern[pattern.length] = line.value;
    } while (cont);
  }
  
  is.close();
  stream.close();
  
  if ((pattern[1].indexOf("Speed Dial - Settings") < 0) && (pattern[1].indexOf("Speed Dial - Dials") < 0)) {
    alert(strings.getString('prefs.invalid'));
    return false;
  }
  
  if (!confirm(strings.getString('prefs.import'))) return false;

  for (i = 6; i < pattern.length; i++) {
    var index = pattern[i].indexOf("=");

    if (index > 0) {
      speeddialImport[totalImports] = [];
      speeddialImport[totalImports].push(pattern[i].substring(0, index));
      speeddialImport[totalImports].push(pattern[i].substring(index + 1, pattern[i].length));
      totalImports++;
    }
  }
  
  var processedThumbnails = new Array();

  for(i = 0; i < totalImports; i++) {
    try {
      var addCharAsComplex = false;
      var prefIsEncoded = false;
      var prefType;
      
      if (speeddialImport[i][0].indexOf("thumbnail-") == 0) {
        // Determine preference type
        if ((speeddialImport[i][0].indexOf("-label") > -1)||(speeddialImport[i][0].indexOf("-title") > -1)) {
          addCharAsComplex = true;
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        } else if (speeddialImport[i][0].indexOf("-refreshinterval") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-layout") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-dynamictitle") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_BOOL;
        } else if (speeddialImport[i][0].indexOf("-manualrefresh") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_BOOL;
        } else if (speeddialImport[i][0].indexOf("-js") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_BOOL;
        } else {
          // Char by default
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        }
        var number = (speeddialImport[i][0].split("-", 2))[1];
        if (!processedThumbnails[number]) {
          // Refresh thumbnail
          SpeedDialUtils.deassignThumbnail(number);
          processedThumbnails[number] = true;
        }
      } else if (speeddialImport[i][0].indexOf("group-") == 0) {
        if (speeddialImport[i][0].indexOf("-title") > -1) {
          addCharAsComplex = true;
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        } else if (speeddialImport[i][0].indexOf("-style") > -1) {
          prefIsEncoded = true;
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        } else if (speeddialImport[i][0].indexOf("-rows") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-columns") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-minimumWidth") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-minimumHeight") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-maximumWidth") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-maximumHeight") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-widthModifier") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-heightModifier") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-widthModifierType") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-heightModifierType") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else {
          // Char by default
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        }
      } else {
        try {
          prefType = speeddial_gPrefBranch.getPrefType(speeddialImport[i][0]);
        } catch (e) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        }
      }
      switch (prefType) {
        case Components.interfaces.nsIPrefBranch.PREF_BOOL:
          speeddial_gPrefBranch.setBoolPref(speeddialImport[i][0],/true/i.test(speeddialImport[i][1]));
          break;

        case Components.interfaces.nsIPrefBranch.PREF_INT:
          speeddial_gPrefBranch.setIntPref(speeddialImport[i][0], speeddialImport[i][1]);
          break;

        case Components.interfaces.nsIPrefBranch.PREF_STRING:
          var pref = speeddialImport[i][1];
//          if (pref.indexOf('"') == 0) // in prev version we use " " for string
//            pref = pref.substring(1,pref.length - 1);
          
          if (addCharAsComplex) {
            var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
            str.data = decodeURI(pref);
            speeddial_gPrefBranch.setComplexValue(speeddialImport[i][0], Components.interfaces.nsISupportsString, str);
          } else if (prefIsEncoded) {
            speeddial_gPrefBranch.setCharPref(speeddialImport[i][0], decodeURI(pref));
          } else {
            speeddial_gPrefBranch.setCharPref(speeddialImport[i][0], pref);
          }
          break;
      }
    } catch(e) { alert(e); }
  }
  
  // Refresh updated thumbnails
  for (i=1; i<processedThumbnails.length; i++) {
    if (processedThumbnails[i]) {
      if (speeddial_gPrefBranch.prefHasUserValue("thumbnail-" + i + "-url")) {
        speeddial_gPrefBranch.setBoolPref("thumbnail-" + i + "-manualrefresh", true);
      }
    }
  }

  window.alert(strings.getString('prefs.importsuccess'));
  return true;
/*
  alert(strings.getString('prefs.importfailed'));
  return false;
*/
}

function getMIMEService()
{
  const mimeSvcContractID = "@mozilla.org/mime;1";
  const mimeSvcIID = Components.interfaces.nsIMIMEService;
  const mimeSvc = Components.classes[mimeSvcContractID].getService(mimeSvcIID);
  return mimeSvc;
}


function speeddial_saveToFile(patterns, isHtml) {
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

  var strings = document.getElementById("prefsStrings");

  fp.init(window, strings.getString('prefs.save'), fp.modeSave);
  if (isHtml) {
    fp.defaultExtension = 'html';
    fp.defaultString = strings.getString('exportedFile.defaultFileName') + '.' + fp.defaultExtension;
    var mimeInfo = getMIMEService().getFromTypeAndExtension("text/html", fp.defaultExtension);
    if (mimeInfo) {
      var extEnumerator = mimeInfo.getFileExtensions();

      var extString = "";
      while (extEnumerator.hasMore()) {
        var extension = extEnumerator.getNext();
        if (extString)
          extString += "; ";    // If adding more than one extension,
                                // separate by semi-colon
        extString += "*." + extension;
      }

      if (extString)
        fp.appendFilter(mimeInfo.description, extString);
    }
  } else {
    fp.defaultExtension = 'speeddial';
    fp.defaultString = strings.getString('prefs.defaultFileName') + '.' + fp.defaultExtension;
    fp.appendFilter(strings.getString('prefs.filter'), "*.speeddial");
  }
  fp.appendFilters(fp.filterAll);

  if(fp.show() != fp.returnCancel) {

    if(fp.file.exists()) fp.file.remove(true);
    fp.file.create(fp.file.NORMAL_FILE_TYPE, 0666);
    stream.init(fp.file, 0x02, 0x200, null);

    for(var i = 0; i < patterns.length; i++) {
      patterns[i] = patterns[i] + "\n";
      stream.write(patterns[i], patterns[i].length);
    }

    stream.close();
  } else {
  }
}

function speeddial_loadFromFile() {
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);

  var strings = document.getElementById("prefsStrings");

  fp.init(window, strings.getString('prefs.open'), fp.modeOpen);
  fp.defaultExtension = 'speeddial';
  fp.appendFilter(strings.getString('prefs.filter'), "*.speeddial");
  fp.appendFilters(fp.filterAll);

  if(fp.show() != fp.returnCancel) {
    return fp.file;
  }

  return null;
}

function showFirstTimeConfig() {
  if (document.documentElement.openSubDialog) {
    document.documentElement.openSubDialog("chrome://speeddial/content/firstTimeConfig.xul", "resizable", null);
  } else {
    openDialog("chrome://speeddial/content/firstTimeConfig.xul", "",
               "centerscreen,chrome,dialog,resizable,modal");
  }
}

function restoreBackupPopupShowing(event) {
  var menu = event.target;
  var strings = document.getElementById("prefsStrings");
    
  // Empty current
  while (menu.firstChild)
    menu.removeChild(menu.firstChild);

  var file = Components.classes["@mozilla.org/file/directory_service;1"]
                   .getService(Components.interfaces.nsIProperties)
                   .get("ProfD", Components.interfaces.nsIFile);
  file.append(SpeedDialUtils.backupFolder);

  var populatedMenu = false;
  // Create new
  if (file.exists() && file.isDirectory()) {
    var backupNameMatch = "\\d+\\.speeddial";
    var enumerator = file.directoryEntries;
    var fileArray = new Array();
    while (enumerator.hasMoreElements()) {
      var targetFile = enumerator.getNext().QueryInterface(Components.interfaces.nsIFile);
      if ((targetFile.isFile()) && (targetFile.leafName.match(backupNameMatch))) {
        fileArray.push(new SpeedDialUtils.FileRef(targetFile.leafName, targetFile.path));
      }
    }

    fileArray.sort();
    
    for (var c=0; c<fileArray.length; c++) {
      var dateString = fileArray[c].leafName;
      var year = parseInt(dateString.substring(0, 4));
      var month = parseInt(dateString.substring(4, 6)) - 1;
      var day = parseInt(dateString.substring(6, 8));
      var date = new Date();
      date.setFullYear(year, month, day);
      var menuitem = document.createElement("menuitem");
      menuitem.setAttribute("label", date.toLocaleDateString());
      menuitem.setAttribute("targetBackup", fileArray[c].path);
      menu.appendChild(menuitem);
      populatedMenu = true;
    }
  }
  
  if (!populatedMenu) {
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute("label", strings.getString("nobackups.label"));
    menuitem.setAttribute("disabled", "true");
    menu.appendChild(menuitem);
  }
  
  var menuSeparator = document.createElement("menuseparator");
  menu.appendChild(menuSeparator);
  var optionsMenuItem = document.createElement("menuitem");
  optionsMenuItem.setAttribute("label", strings.getString("showbackupfolder.label"));
  menu.appendChild(optionsMenuItem);
}

function restoreBackup(event) {
  var targetBackup = event.target.getAttribute("targetBackup");
  
  if (!targetBackup) {
    // Must be open backup folder
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsILocalFile);
    file.append(SpeedDialUtils.backupFolder);
    file.launch();
    return;
  }
  
  var obj = Components.classes["@mozilla.org/file/local;1"].
        createInstance(Components.interfaces.nsILocalFile);
  obj.initWithPath(targetBackup);
  importFile(obj);
}

function exportHtml() {
  var strings = document.getElementById("prefsStrings");
  var bundle = document.getElementById("bundle_speeddial");
  var enableGroups = speeddial_gPrefBranch.getBoolPref("enableGroups");
  var numGroups = 1;
  if (enableGroups) {
    numGroups = speeddial_gPrefBranch.getIntPref("numGroups");
  }
  
  var outputHtml = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n"
  + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
  + "<head>\n"
  + "<title>" + strings.getString('exportedFile.title') +"</title>"
  + "<style>\n"
  + "  ol {\n"
  + "    list-style-type: none;\n"
  + "  }\n\n"
  + "  ol li:before {\n"
  + "    content: counter(item) \". \";\n"
  + "    counter-increment: item;\n"
  + "  }\n"
  + "</style>\n"
  + "<body>\n";
  var currentDial = 1;
  for (var c=1;c<=numGroups;c++) {
    if (enableGroups) {
      outputHtml += "<h3>";
      if (speeddial_gPrefBranch.prefHasUserValue("group-" + c + "-title")) {
        outputHtml += speeddial_gPrefBranch.getComplexValue("group-" + c + "-title", Components.interfaces.nsISupportsString).data
      } else {
        outputHtml += bundle.getFormattedString("untitledGroup.label", [c]);
      }
      outputHtml += "</h3>\n";
    }
    outputHtml += "<ol style=\"counter-reset: item " + (currentDial-1) + ";\">\n";
    
    var screenRows;
    var screenColumns;
    
    if (speeddial_gPrefBranch.prefHasUserValue("group-" + c + "-rows")) {
      screenRows = speeddial_gPrefBranch.getIntPref("group-" + c + "-rows");
    } else {
      screenRows = speeddial_gPrefBranch.getIntPref("rows");
    }
    if (speeddial_gPrefBranch.prefHasUserValue("group-" + c + "-columns")) {
      screenColumns = speeddial_gPrefBranch.getIntPref("group-" + c + "-columns");
    } else {
      screenColumns = speeddial_gPrefBranch.getIntPref("columns");
    }
    
    for (var d=0; d<(screenRows*screenColumns); d++) {
      outputHtml += "<li>\n";
      
      if (speeddial_gPrefBranch.prefHasUserValue("thumbnail-" + currentDial + "-url")) {
        var thumbnailTitle = speeddial_gPrefBranch.getComplexValue("thumbnail-" + currentDial + "-label", Components.interfaces.nsISupportsString).data;
        var thumbnailURL =  speeddial_gPrefBranch.getCharPref("thumbnail-" + currentDial + "-url");
        outputHtml += "<a href=\"" + thumbnailURL + "\">";
        
        if (thumbnailTitle == "") {
          outputHtml +=  bundle.getString("untitled.label");
        } else {
          outputHtml +=  thumbnailTitle;
        }
        outputHtml += "</a>\n";
      } else {
        outputHtml +=  bundle.getString("unassigned.label");
        outputHtml += "\n";
      }

      outputHtml += "</li>\n";
      
      currentDial++;
    }
    
    outputHtml += "</ol>\n";
  }
  outputHtml += "<p>\n" +
  strings.getFormattedString("exportedFile.generatedby", ["<a href=\"http://speeddial.uworks.net/\">Speed Dial</a>"])
  "</p>\n</body>\n"
  + "</html>";
  return outputHtml;
}


