// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var targetDial = -1;
var retVals = null;

function Startup() {
  // Set variables
  targetDial = window.arguments[0];
  //retVals = window.arguments[1];

  var list = document.getElementById("targetGroup");
  var numGroups = gPref.getIntPref("extensions.speeddial.numGroups");
  var speedDialBundle = document.getElementById("bundle_speeddial");

  for (var b=1; b<=numGroups; b++) {
    var label;
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + b + "-title")) {
      label = gPref.getComplexValue("extensions.speeddial.group-" + b + "-title", Components.interfaces.nsISupportsString).data;
    } else {
      label = speedDialBundle.getFormattedString("untitledGroup.label", [b]);
    }
    list.appendItem(label, b, "");
  }
  
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
    var targetURL = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
    if (SpeedDialUtils.stringStartsWith(targetURL, "chrome://speeddial/content/speeddial.xul?group=")) {
      var targetGroup = parseInt(targetURL.substring("chrome://speeddial/content/speeddial.xul?group=".length));
      list.selectedIndex = targetGroup - 1;
    } else {
      list.selectedIndex = 0;
    }
  } else {
    list.selectedIndex = 0;
  }
}

function onOK(event) {
  var list = document.getElementById("targetGroup");
  var targetGroup = list.selectedIndex + 1;
  
  // Delete thumbnail
  SpeedDialUtils.deassignThumbnail(targetDial);
  
  gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", "chrome://speeddial/content/speeddial.xul?group=" + targetGroup);
  gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js", true);
  
  var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
  str.data = list.selectedItem.getAttribute("label");
  gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
  
  if (SpeedDialUtils.isFirefox3()) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
  }
  
  return true;
}

function onCancel(event) {
  if (retVals != null) {
    retVals.canceled = true;
  }
  return true;
}

function openFullEdit() {
  window.opener.openDialog("chrome://speeddial/content/editDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent",
             targetDial);
  window.close();
}
