var speeddial_gPrefBranch = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.speeddial.");

function speeddial_initPrefs() {
  if(document.documentElement.getButton && document.documentElement.getButton('extra2')) {
    var extra2 = document.documentElement.getButton('extra2');
    extra2.setAttribute('type', 'menu');
    extra2.setAttribute('popup', 'speeddial-settings-popup');
  }
}

function speeddial_defaultSettings() {
  var strings = document.getElementById("prefsStrings");
  if (!confirm(strings.getString('prefs.confirm'))) return false;

  var count = { value : 0 };
  var childList = speeddial_gPrefBranch.getChildList("", count);

  for (var i = 0; i < count.value; i++) {
    if(speeddial_gPrefBranch.prefHasUserValue(childList[i]) && childList[i] != "changelog") {
      speeddial_gPrefBranch.clearUserPref(childList[i]);
    }
  }

  window.alert(strings.getString('prefs.defaultsuccess'));
  return true;
}

function speeddial_extendInt(aInput) {
  if (aInput < 10) return "0" + aInput.toString();
  else return aInput;
}

function speeddial_exportSettings(onlyDials) {
  var now = new Date();
  var sDate = speeddial_extendInt(now.getMonth() + 1) + "/" + speeddial_extendInt(now.getDate()) + "/" + now.getFullYear();
  var sTtime = speeddial_extendInt(now.getHours()) + ":" + speeddial_extendInt(now.getMinutes()) + ":" + speeddial_extendInt(now.getSeconds());
  var sGMT = now.toGMTString();

  var speeddialExport = new Array;
  speeddialExport[0] = "-----------------------------------------------------------------------\n";
  speeddialExport[0] += "                       Speed Dial - ";
  if (onlyDials) {
    speeddialExport[0] += "Dials";
  } else {
    speeddialExport[0] += "Settings";
  }
  speeddialExport[0] += "\n";
  speeddialExport[0] += "          " + sDate + ", " + sTtime + " (" + sGMT + ")\n";
  speeddialExport[0] += "-----------------------------------------------------------------------\n";
  speeddialExport[0] += "                         DO NOT EDIT THIS FILE\n";
  speeddialExport[0] += "-----------------------------------------------------------------------";

  var count = { value : 0 };
  var childList = speeddial_gPrefBranch.getChildList("", count);
  var currentIndex = 1;
  for(var i = 0; i < count.value; i++) {
    try {
      if (!onlyDials || (childList[i].match("^thumbnail-") == "thumbnail-")) {
        if (childList[i].match("-lastsaved$") != "-lastsaved") {
          switch(speeddial_gPrefBranch.getPrefType(childList[i])) {
            case Components.interfaces.nsIPrefBranch.PREF_BOOL:
              speeddialExport[currentIndex] = childList[i] + '=' + speeddial_gPrefBranch.getBoolPref(childList[i]);
              break;

            case Components.interfaces.nsIPrefBranch.PREF_INT:
              speeddialExport[currentIndex] = childList[i] + '=' + speeddial_gPrefBranch.getIntPref(childList[i]);
              break;

            case Components.interfaces.nsIPrefBranch.PREF_STRING:
              speeddialExport[currentIndex] = childList[i] + '=' + speeddial_gPrefBranch.getCharPref(childList[i]);
              break;
          }
          currentIndex++;
        }
      }
    } catch(e) { }
  }

  speeddialExport.sort();
  speeddial_saveToFile(speeddialExport);
}


function speeddial_importSettings() {
  var strings = document.getElementById("prefsStrings");

  var pattern = speeddial_loadFromFile();
  if(!pattern) return false;

  var i;
  var speeddialImport = new Array;
  var appendFilters = null;

  if ((pattern[1].indexOf("Speed Dial - Settings") < 0) && (pattern[1].indexOf("Speed Dial - Dials") < 0)) {
    alert(strings.getString('prefs.invalid'));
    return false;
  }

  if (!confirm(strings.getString('prefs.import'))) return false;

  for (i = 6; i < pattern.length; i++) {
    var index = pattern[i].indexOf("=");

    if (index > 0) {
      speeddialImport[i] = [];
      speeddialImport[i].push(pattern[i].substring(0, index));
      speeddialImport[i].push(pattern[i].substring(index + 1, pattern[i].length));
    }
  }
  
  var processedThumbnails = new Array();

  for(i = 6; i < speeddialImport.length; i++) {
    try {
      var addCharAsComplex = false;
      var prefType;
      
      if (speeddialImport[i][0].indexOf("thumbnail-") == 0) {
        // Determine preference type
        if (speeddialImport[i][0].indexOf("-label") > -1) {
          addCharAsComplex = true;
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        } else if (speeddialImport[i][0].indexOf("-refreshinterval") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_INT;
        } else if (speeddialImport[i][0].indexOf("-dynamictitle") > -1) {
          prefType = Components.interfaces.nsIPrefBranch.PREF_BOOL;
        } else {
          // Char by default
          prefType = Components.interfaces.nsIPrefBranch.PREF_STRING;
        }
        var number = (speeddialImport[i][0].split("-", 2))[1];
        if (!processedThumbnails[number]) {
          // Refresh thumbnail
          processedThumbnails[number] = true;
        }
      } else {
        prefType = speeddial_gPrefBranch.getPrefType(speeddialImport[i][0]);
      }
      switch (prefType) {
        case Components.interfaces.nsIPrefBranch.PREF_BOOL:
          speeddial_gPrefBranch.setBoolPref(speeddialImport[i][0],/true/i.test(speeddialImport[i][1]));
          break;

        case Components.interfaces.nsIPrefBranch.PREF_INT:
          speeddial_gPrefBranch.setIntPref(speeddialImport[i][0], speeddialImport[i][1]);
          break;

        case Components.interfaces.nsIPrefBranch.PREF_STRING:
          var pref = speeddialImport[i][1];
          if (pref.indexOf('"') == 0) // in prev version we use " " for string
            pref = pref.substring(1,pref.length - 1);
          if (addCharAsComplex) {
            var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
            str.data = pref;
            speeddial_gPrefBranch.setComplexValue(speeddialImport[i][0], Components.interfaces.nsISupportsString, str);
          } else {
            speeddial_gPrefBranch.setCharPref(speeddialImport[i][0], pref);
          }
          break;
      }
    } catch(e) { alert(e); }
  }
  
  // Refresh updated thumbnails
  for (i=1; i<processedThumbnails.length; i++) {
    if (processedThumbnails[i]) {
      speeddial_gPrefBranch.setBoolPref("thumbnail-" + i + "-manualrefresh", true);
    }
  }

  window.alert(strings.getString('prefs.importsuccess'));
  return true;
/*
  alert(strings.getString('prefs.importfailed'));
  return false;
*/
}


function speeddial_saveToFile(patterns) {
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

  var strings = document.getElementById("prefsStrings");

  fp.init(window, strings.getString('prefs.save'), fp.modeSave);
  fp.defaultExtension = 'speeddial';
  fp.defaultString = strings.getString('prefs.defaultFileName') + '.' + fp.defaultExtension;
  fp.appendFilter(strings.getString('prefs.filter'), "*.speeddial");
  fp.appendFilters(fp.filterAll);

  if(fp.show() != fp.returnCancel) {

    if(fp.file.exists()) fp.file.remove(true);
    fp.file.create(fp.file.NORMAL_FILE_TYPE, 0666);
    stream.init(fp.file, 0x02, 0x200, null);

    for(var i = 0; i < patterns.length; i++) {
      patterns[i] = patterns[i] + "\n";
      stream.write(patterns[i], patterns[i].length);
    }

    stream.close();
  } else {
  }
}


function speeddial_loadFromFile() {
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);

  var strings = document.getElementById("prefsStrings");

  fp.init(window, strings.getString('prefs.open'), fp.modeOpen);
  fp.defaultExtension = 'speeddial';
  fp.appendFilter(strings.getString('prefs.filter'), "*.speeddial");
  fp.appendFilters(fp.filterAll);

  if(fp.show() != fp.returnCancel) {
    var result = new Array();
    var charset = "UTF-8";
    var is = Components.classes["@mozilla.org/intl/converter-input-stream;1"].createInstance(Components.interfaces.nsIConverterInputStream);

    stream.init(fp.file, 0x01, 0444, null);
    is.init(stream, charset, 1024, 0xFFFD);
    
    if (is instanceof Components.interfaces.nsIUnicharLineInputStream) {
      var line = {};
      do {
        cont = is.readLine(line);
        result[result.length] = line.value;
      } while (cont);
    }
    
    is.close();
    stream.close();

    return result;
  }

  return null;
}

function showFirstTimeConfig() {
  openDialog("chrome://speeddial/content/firstTimeConfig.xul", "",
             "centerscreen,chrome,dialog,resizable,modal");
}
